// --------------------------------
// <copyright file="Log4NetLogger.cs" company="Genesys Telecommunications Laboratories">
//
//  Any authorized distribution of any copy of this code (including any related 
//  documentation) must reproduce the following restrictions, disclaimer and copyright 
//  notice:
//  The Genesys Name, trademarks and/or logo(s) of Genesys shall not be used to Name 
//  (even as a part of another Name), endorse and/or promote products derived from 
//  this code without prior written permission from Genesys Telecommunications 
//  Laboratories, Inc. 
//  
//  The use, copy, and/or distribution of this code is subject to the terms of the Genesys 
//  Developer License Agreement.  This code shall not be used, copied, and/or 
//  distributed under any other license agreement.    
//  THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES, INC. 
//  (\'GENESYS\') 'AS IS' WITHOUT ANY WARRANTY OF ANY KIND. GENESYS HEREBY 
//  DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS, REPRESENTATIONS AND 
//  WARRANTIES WITH RESPECT TO THIS CODE (OR ANY PART THEREOF), INCLUDING, BUT 
//  NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
//  PARTICULAR PURPOSE OR NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL 
//  NOT BE LIABLE FOR ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO 
//  EVENT SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, 
//  CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING, BUT 
//  NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).
//  Copyright (c) 2008-2009 Genesys Telecommunications Laboratories, Inc. All Rights Reserved.
//
// </copyright>
// ---------------------------------


namespace TestServices
{
    using System;
    using System.Text;

    // using Apache.Avalon.Framework;
    using Genesyslab.Platform.Commons.Logging;
    using log4net;

    /// <summary>
    /// The default log4net wrapper class for Logger.
    /// </summary>
    public class Log4NetLogger : ILogger
    {
        #region Fields

        //underlying implementation
        private ILog m_logger;

        private string m_name;

        #endregion Fields

        /// <summary>
        /// Creates a m_logger that delegates to specified category.
        /// </summary>
        /// <param Name="logImpl">The ILog to delegate to.</param>
        /// <param Name="Name">The current category Name.</param>
        public Log4NetLogger(ILog logImpl, string name)
        {
            m_logger = logImpl;
            m_name = name;
        }

        #region ILogger Members

        /// <summary>
        /// Logs a debug message.
        /// </summary>
        /// <param Name="message">The Message</param>
        public void Debug(object message)
        {
            m_logger.Debug(message);
        }

        /// <summary>
        /// Logs a debug message. 
        /// </summary>
        /// <param Name="message">The Message</param>
        /// <param Name="exception">The Exception</param>
        public void Debug(object message, Exception exception)
        {
            m_logger.Debug(message, exception);
        }

        /// <summary>
        /// Logs a debug message.
        /// </summary>
        /// <param Name="format">Message format</param>
        /// <param Name="args">Array of objects to write using format</param>
        public void DebugFormat(string format, params Object[] args)
        {
            Debug(String.Format(format, args));
        }

        /// <summary>
        /// Determines if messages of priority "debug" will be logged.
        /// </summary>
        /// <value>True if "debug" messages will be logged.</value> 
        public bool IsDebugEnabled
        {
            get
            {
                return m_logger.IsDebugEnabled;
            }
        }

        /// <summary>
        /// Logs an info message.
        /// </summary>
        /// <param Name="message">The Message</param>
        public void Info(object message)
        {
            m_logger.Info(message);
        }

        /// <summary>
        /// Logs an info message. 
        /// </summary>
        /// <param Name="message">The Message</param>
        /// <param Name="exception">The Exception</param>
        public void Info(object message, Exception exception)
        {
            m_logger.Info(message, exception);
        }

        /// <summary>
        /// Logs an info message.
        /// </summary>
        /// <param Name="format">Message format</param>
        /// <param Name="args">Array of objects to write using format</param>
        public void InfoFormat(string format, params Object[] args)
        {
            Info(String.Format(format, args));
        }

        /// <summary>
        /// Determines if messages of priority "info" will be logged.
        /// </summary>
        /// <value>True if "info" messages will be logged.</value>
        public bool IsInfoEnabled
        {
            get
            {
                return m_logger.IsInfoEnabled;
            }
        }
        /// <summary>
        /// Logs a warn message.
        /// </summary>
        /// <param Name="message">The Message</param>
        public void Warn(object message)
        {
            m_logger.Warn(message);
        }

        /// <summary>
        /// Logs a warn message. 
        /// </summary>
        /// <param Name="message">The Message</param>
        /// <param Name="exception">The Exception</param>
        public void Warn(object message, Exception exception)
        {
            m_logger.Warn(message, exception);
        }

        /// <summary>
        /// Logs a warn message.
        /// </summary>
        /// <param Name="format">Message format</param>
        /// <param Name="args">Array of objects to write using format</param>
        public void WarnFormat(string format, params Object[] args)
        {
            Warn(String.Format(format, args));
        }

        /// <summary>
        /// Determines if messages of priority "warn" will be logged.
        /// </summary>
        /// <value>True if "warn" messages will be logged.</value>
        public bool IsWarnEnabled
        {
            get
            {
                return m_logger.IsWarnEnabled;
            }
        }

        /// <summary>
        /// Logs an error message.
        /// </summary>
        /// <param Name="message">The Message</param>
        public void Error(object message)
        {
            m_logger.Error(message);
        }

        /// <summary>
        /// Logs an error message. 
        /// </summary>
        /// <param Name="message">The Message</param>
        /// <param Name="exception">The Exception</param>
        public void Error(object message, Exception exception)
        {
            m_logger.Error(message, exception);
        }

        /// <summary>
        /// Logs an error message.
        /// </summary>
        /// <param Name="format">Message format</param>
        /// <param Name="args">Array of objects to write using format</param>
        public void ErrorFormat(string format, params Object[] args)
        {
            Error(String.Format(format, args));
        }

        /// <summary>
        /// Determines if messages of priority "error" will be logged.
        /// </summary>
        /// <value>True if "error" messages will be logged.</value>
        public bool IsErrorEnabled
        {
            get
            {
                return m_logger.IsErrorEnabled;
            }
        }

        /// <summary>
        /// Logs a fatal error message.
        /// </summary>
        /// <param Name="message">The Message</param>
        public void FatalError(object message)
        {
            m_logger.Fatal(message);
        }

        /// <summary>
        /// Logs a fatal error message.
        /// </summary>
        /// <param Name="message">The Message</param>
        /// <param Name="exception">The Exception</param>
        public void FatalError(object message, Exception exception)
        {
            m_logger.Fatal(message, exception);
        }

        /// <summary>
        /// Logs a fatal error message.
        /// </summary>
        /// <param Name="format">Message format</param>
        /// <param Name="args">Array of objects to write using format</param>
        public void FatalErrorFormat(string format, params Object[] args)
        {
            FatalError(String.Format(format, args));
        }

        /// <summary>
        /// Determines if messages of priority "fatalError" will be logged.
        /// </summary>
        /// <value>True if "fatalError" messages will be logged.</value>
        public bool IsFatalErrorEnabled
        {
            get
            {
                return m_logger.IsFatalEnabled;
            }
        }

        /// <summary>
        /// Creates a new child logger.
        /// The Name of the child logger is [current-loggers-Name].[passed-in-Name]
        /// </summary>
        /// <param Name="Name">The Subname of this logger.</param>
        /// <returns>The New ILogger instance.</returns> 
        /// <exception cref="System.ArgumentException">If the Name has an empty element Name.</exception>
        public ILogger CreateChildLogger(string name)
        {
            StringBuilder childLoggerNameBuilder = new StringBuilder(m_name);
            childLoggerNameBuilder.Append(".");
            childLoggerNameBuilder.Append(name);

            string childLoggerName = childLoggerNameBuilder.ToString();

            return new Log4NetLogger(LogManager.GetLogger(childLoggerName), childLoggerName);
        }

        #endregion ILogger Members
    }
}
