/*=====================================================================
Any authorized distribution of any copy of this code (including any related documentation) must reproduce the following restrictions, disclaimer and copyright notice:
The Genesys name, trademarks and/or logo(s) of Genesys shall not be used to name (even as a part of another name), endorse and/or promote products derived from this code without prior written permission from Genesys Telecommunications Laboratories, Inc.
The use, copy, and/or distribution of this code is subject to the terms of the Genesys Developer License Agreement.  This code shall not be used, copied, and/or distributed under any other license agreement.
THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES, INC. (GENESYS) AS IS WITHOUT ANY WARRANTY OF ANY KIND. GENESYS HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS, REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).
Copyright &copy; 2007 Genesys Telecommunications Laboratories, Inc. All rights reserved.

=====================================================================*/
package agent.interaction.samples;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

import  com.genesyslab.ail.applicationblocks.connector.ApplicationParameters;

/**
 * This class reads Configuration Layer data from a properties file called
 * <code>AgentInteraction.properties.</code> This data includes information
 * such as the host and port to use, the name of an application to connect to
 * and the attributes of three agents for use in the examples.
 *
 * Once this data has been stored in the fields of this class, it is available
 * to the Agent Interaction (Java) code examples by means of getter and
 * setter methods.
 * @version 7.5.001.02
 */
public class AgentInteractionData {
	
	private ApplicationParameters mApplicationParameters;

	/** 
	 * Constructor. 
	 */
    public AgentInteractionData() {
    	mApplicationParameters = new ApplicationParameters();
        try {
            loadData();
        } catch (Exception exception) {
            exception.printStackTrace();
        }
    }
    
    public ApplicationParameters getApplicationParameters()
    {
    	return mApplicationParameters;
    }

   

    public void loadData() throws Exception {
    	
    	 
        
        // Load the properties from the properties file.
        File propertiesFile = new File("agentInteraction.properties");
        System.out.println("The properties file is at " + propertiesFile.getAbsolutePath());
        FileInputStream fileInputStream = new FileInputStream(propertiesFile);
        Properties properties = new java.util.Properties();
        properties.load(fileInputStream);

        
         /* Retrieve Connection information from the properties file */
         String configServerHost = properties
                .getProperty("ConfigServerHost");
         int configServerPort = Integer
                .parseInt(properties
                        .getProperty("ConfigServerPort"));

        String configServerBackupHost = properties
                .getProperty("ConfigServerBackupHost");
        int configServerBackupPort = Integer
                .parseInt(properties
                        .getProperty("ConfigServerBackupPort"));

        String configLayerUserName = properties
                .getProperty("ConfigLayerUserName");
        String configLayerPassword = properties
                .getProperty("ConfigLayerPassword");

        String applicationName = properties
                .getProperty("ApplicationName");
        String applicationTypeString = properties
                .getProperty("ApplicationType");
        
        ApplicationParameters.ApplicationType applicationType;
        if ("server"
                .equalsIgnoreCase(applicationTypeString)) {
            applicationType = ApplicationParameters.ApplicationType.SERVER;
        } else {
            applicationType = ApplicationParameters.ApplicationType.CLIENT;
        }

        int connectionCheckIntervalInSeconds = Integer
                .parseInt(properties
                        .getProperty("ConnectionCheckIntervalInSeconds"));
        int serverRequestTimeoutInSeconds = Integer
                .parseInt(properties
                        .getProperty("ServerRequestTimeoutInSeconds"));
        int serverRequestAttempts = Integer
        .parseInt(properties
                .getProperty("ServerRequestAttempts"));
        
        mApplicationParameters.init(
        		configServerHost,      	configServerPort,
				configServerBackupHost,	configServerBackupPort,
				configLayerUserName,	configLayerPassword,
				applicationName, applicationType,
				connectionCheckIntervalInSeconds,
				serverRequestAttempts,
				serverRequestTimeoutInSeconds);

        // These should match objects in the configuration layer
        agent1UserName = properties.getProperty("Agent1_UserName");
        agent2UserName = properties.getProperty("Agent2_UserName");
        agent3UserName = properties.getProperty("Agent3_UserName");

        place1 = properties.getProperty("Place1");
        place2 = properties.getProperty("Place2");
        place3 = properties.getProperty("Place3");

        loginId1 = properties
                .getProperty("LoginId1");
        loginId2 = properties
                .getProperty("LoginId2");
        loginId3 = properties
                .getProperty("LoginId3");

        password1 = properties
                .getProperty("Password1");
        password2 = properties
                .getProperty("Password2");
        password3 = properties
                .getProperty("Password3");

        dn1 = properties.getProperty("DN1");
        dn2 = properties.getProperty("DN2");
        dn3 = properties.getProperty("DN3");

        queue = properties.getProperty("Queue");
    }

    public String getDn1() {
        return dn1;
    }

    public String getDn2() {
        return dn2;
    }

    public String getDn3() {
        return dn3;
    }

    public String getPassword1() {
        return password1;
    }

    public String getPassword2() {
        return password2;
    }

    public String getPassword3() {
        return password3;
    }

    public String getPlace1() {
        return place1;
    }

    public String getPlace2() {
        return place2;
    }

    public String getPlace3() {
        return place3;
    }

    public String getQueue() {
        return queue;
    }

    public String getAgent1UserName() {
        return agent1UserName;
    }

    public String getAgent2UserName() {
        return agent2UserName;
    }

    public String getAgent3UserName() {
        return agent3UserName;
    }
    public String getLoginId1() {
        return loginId1;
    }

    public String getLoginId2() {
        return loginId2;
    }

    public String getLoginId3() {
        return loginId3;
    }

    // More Configuration Layer information
    public String agent1UserName;
    public String agent2UserName;
    public String agent3UserName;
    public String place1;
    public String place2;
    public String place3;
    public String loginId1;
    public String loginId2;
    public String loginId3;
    public String password1;
    public String password2;
    public String password3;
    public String dn1;
    public String dn2;
    public String dn3;
    public String queue;

}