/*=====================================================================
Any authorized distribution of any copy of this code (including any related documentation) must reproduce the following restrictions, disclaimer and copyright notice:
The Genesys name, trademarks and/or logo(s) of Genesys shall not be used to name (even as a part of another name), endorse and/or promote products derived from this code without prior written permission from Genesys Telecommunications Laboratories, Inc.
The use, copy, and/or distribution of this code is subject to the terms of the Genesys Developer License Agreement.  This code shall not be used, copied, and/or distributed under any other license agreement.

THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES, INC. (GENESYS) AS IS WITHOUT ANY WARRANTY OF ANY KIND. GENESYS HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS, REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).
Copyright &copy; 2007 Genesys Telecommunications Laboratories, Inc. All rights reserved.

 =====================================================================*/
package agent.interaction.samples;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

/**
 * This class creates a graphical user interface that is used by all of the
 * Agent Interaction (Java) code examples.
 *
 * All of the widgets needed by the examples are created before the GUI is
 * displayed, but they are only enabled if they are needed by the sample that
 * is being run.
 * @version 7.5.001.02
 */
class AgentInteractionGui {

    static Font BOLD = new Font("", Font.BOLD, 10);

    private static Color DARK_FADED_GREEN = new Color(0, 153, 0);
    private static Color LIGHT_WEAK_GREEN = new Color(153, 204, 153);
    private static Color PALE_WEAK_GREEN = new Color(204, 255, 204);
    private static Color PALE_WEAK_YELLOW = new Color(255, 255, 204);
    private static Color PALE_WEAK_RED = new Color(255, 204, 204);
    static Color ACTIVE_BACKGROUND_COLOR = PALE_WEAK_GREEN;
    static Color ACTIVE_BUTTON_COLOR = PALE_WEAK_GREEN;
    private static Color DN_EVENT_COLOR = Color.blue;
    private static Color PLACE_EVENT_COLOR = DARK_FADED_GREEN;
    private static Color INTERACTION_EVENT_COLOR = Color.magenta;
    private static Color ERROR_COLOR = Color.red;
    
    /// colors for chat session
    private static Color ELSE_COLOR=Color.RED;	
    private static Color CUSTO_COLOR=DARK_FADED_GREEN;
    private static Color AGENT_COLOR = Color.BLUE;	
    private static Color DEFAULT_COLOR=Color.BLACK;
    
    private static int SPACE_UNDER_TEXT_FIELD = 3;
    private static int SPACE_NEXT_TO_BORDER = 1;

    private static String SIMPLE_VOICE_INTERACTION_SAMPLE_TYPE = "SimpleVoiceInteraction";
    private static String MULTIPARTY_VOICE_INTERACTION_SAMPLE_TYPE = "MultipartyVoiceInteraction";
    private static String SIMPLE_EMAIL_INTERACTION_SAMPLE_TYPE = "SimpleEmailInteraction";
    private static String SIMPLE_OPEN_MEDIA_INTERACTION_SAMPLE_TYPE = "SimpleOpenMediaInteraction";
    private static String SIMPLE_CHAT_INTERACTION_SAMPLE_TYPE = "SimpleChatInteraction";
    
    private static String NEWLINE = "\n";
    private static String DN_EVENT_STYLE = "dnEvent";
    private static String PLACE_EVENT_STYLE = "placeEvent";
    private static String INTERACTION_EVENT_STYLE = "interactionEvent";
    private static String ERROR_STYLE = "errorEvent";
    
	public static String ELSE_STYLE="else";
	public static String CUSTO_STYLE="customer";
	public static String AGENT_STYLE="agent";
	public static String DEFAULT_STYLE="default";
    
  
    
    

    boolean logInteractionEvents = true;
    boolean createDetailedInteractionEventMessages = false;
    boolean logDnEvents = true;
    boolean createDetailedDnEventMessages = true;
    boolean logPlaceEvents = true;
    boolean createDetailedPlaceEventMessages = false;

    private boolean needSimpleVoiceInteractionWidgets = false;
    private boolean needMultipartyVoiceInteractionWidgets = false;
    private boolean needSimpleEmailInteractionWidgets = false;
    private boolean needSimpleOpenMediaInteractionWidgets = false;
    private boolean needSimpleChatInteractionWidgets = false;

    JFrame mainGuiWindow;
    private Container contentPane;
    private GridBagConstraints gridBagConstraints = new GridBagConstraints();

    JButton loginButton;
    JButton logoutButton;
    JButton readyButton;
    JButton notReadyButton;
    JButton afterCallWorkButton;
    JTextPane logAreaTextPane;
    JTabbedPane interactionTabbedPane;

    Calendar calendar = new GregorianCalendar();
    DateFormat timestamp = new SimpleDateFormat("yyyy-dd-MM HH:mm:ss:SSS");

    //--Place Table
    OpenMediaTableModel placeTableModel;
    JScrollPane placeTableScrollPane;

    JLabel loginNameLabel;
    JLabel dnLabel;
    JLabel agentPlaceLabel;
    JLabel agentQueueLabel;
    JLabel interactionDnisLabel;
    JLabel interactionAniLabel;
    JLabel interactionSubjectLabel;
    JLabel interactionPartiesLabel;
    private JPanel loginPanel;
    private TitledBorder simplePlaceTitledBorder;
    private JPanel masterVoiceInteractionPanel;
    JPanel simpleVoiceInteractionPanel;
    private TitledBorder simpleVoiceInteractionPanelTitledBorder;
    private JPanel simpleVoiceTargetDnPanel;
    JLabel simpleVoiceTargetDnLabel;
    JTextField simpleVoiceTargetDnTextField;
    private JPanel simpleVoiceInteractionBoxPanel;
    private JPanel simpleVoiceInteractionButtons;
    private JPanel multipartyVoiceInteractionPanel;
    private TitledBorder multipartyVoiceInteractionPanelTitledBorder;
    private JPanel multipartyVoiceTargetDnPanel;
    JLabel multipartyVoiceTargetDnLabel;
    private JPanel multipartyVoiceRadioButtonPanel;
    private TitledBorder multipartyVoiceRadioButtonPanelTitledBorder;
    JTextField multipartyVoiceTargetDnTextField;
    JLabel multipartyVoiceReasonLabel;
    JTextField multipartyVoiceReasonTextField;
    private JPanel multipartyVoiceInteractionButtonPanel;
    JRadioButton singleStepRadioButton;
    JRadioButton dualStepRadioButton;
    JRadioButton muteTransferRadioButton;
    private JPanel masterMultipartyVoiceRadioButtonPanel;
    JPanel masterEmailInteractionPanel;
    private TitledBorder masterEmailInteractionPanelTitledBorder;
    JTextArea inboundEmailTextArea;
    JButton acceptButton;
    JButton replyButton;
    JButton emailReleaseButton;
    JButton emailDoneButton;
	JTextArea responseTextArea;
	JFrame replyWindow;
	JButton sendButton;
    JPanel masterOpenMediaInteractionPanel;
    private TitledBorder masterOpenMediaInteractionPanelTitledBorder;
    JTextArea openMediaTextArea;
    JButton acceptOpenMediaInteractionButton;
    JButton openMediaInteractionDoneButton;
    private JPanel masterStatusPanel;
    private JScrollPane logAreaTextPaneScrollPane;
    JButton answerButton;
    JButton doneButton;
    JButton releaseButton;
    JButton makeCallButton;
    JButton holdButton;
    JButton retrieveButton;
    JButton conferenceButton;
    JButton transferButton;
    JButton completeButton;
    private JPanel interactionEventLogConfigurationPanel;
    private JRadioButton noInteractionEventsLoggingRadioButton;
    private JRadioButton standardInteractionEventsLoggingRadioButton;
    private JRadioButton debugInteractionEventsLoggingRadioButton;
    private JPanel dnEventLogConfigurationPanel;
    private JRadioButton noDnEventsLoggingRadioButton;
    private JRadioButton standardDnEventsLoggingRadioButton;
    private JRadioButton debugDnEventsLoggingRadioButton;
    private JPanel placeEventLogConfigurationPanel;
    private JRadioButton noPlaceEventsLoggingRadioButton;
    private JRadioButton standardPlaceEventsLoggingRadioButton;
    private JRadioButton debugPlaceEventsLoggingRadioButton;
    
    
    //// chat widgets
    StyledDocument chatSessionStyledDocument;
	JScrollPane chatSessionScrollPane;
	public JTextPane chatSessionTextPane;
	public JTextArea chatMsgTextArea;
	public JButton sendChatMsgButton;
	JPanel masterChatInteractionPanel;
    TitledBorder masterChatInteractionPanelTitledBorder;
    public JButton joinChatInteractionButton;
    public JButton quitChatInteractionButton;
    public JButton doneChatInteractionButton;
    public JCheckBox coBrowseCheckBox;
    public JFrame coBrowseWindow;
    public DefaultListModel  coBmodel ;
    
    StyledDocument logAreaStyledDocument;
    String newline = "\n";
    
    
    // Chat interaction sample widgets

    public AgentInteractionGui(String windowTitle, String sampleType) {
        determineCodeSampleType(sampleType);
        createGui(windowTitle);
    }

    /*
     * This method figures out what type of code example is being run.
     *
     * This information is used to determine whether widgets used by that code
     * example will need to be enabled when the GUI is activated.
     *
     * @param sampleType
     *            The type of code example being executed.
     */
    private void determineCodeSampleType(String sampleType) {
        if (sampleType == SIMPLE_VOICE_INTERACTION_SAMPLE_TYPE) {
            needSimpleVoiceInteractionWidgets = true;
        }
        if (sampleType == MULTIPARTY_VOICE_INTERACTION_SAMPLE_TYPE) {
            needSimpleVoiceInteractionWidgets = true;
            needMultipartyVoiceInteractionWidgets = true;
        }
        if (sampleType == SIMPLE_EMAIL_INTERACTION_SAMPLE_TYPE) {
            needSimpleEmailInteractionWidgets = true;
        }
        if (sampleType == SIMPLE_OPEN_MEDIA_INTERACTION_SAMPLE_TYPE) {
            needSimpleOpenMediaInteractionWidgets = true;
        }
        if (sampleType == SIMPLE_CHAT_INTERACTION_SAMPLE_TYPE) {
            needSimpleChatInteractionWidgets = true;
        }
    }

    /*
     * This method sets the Java look and feel to the look and feel of the
     * platform the example is being run on.
     *
     * Then it creates the main window (JFrame) and content pane being used by
     * the GUI. After that, it calls methods that create the various components
     * of the user interface.
     *
     * @param windowTitle
     *            The title of the GUI window for the example that is currently
     *            being run.
     */
    private void createGui(String windowTitle) {

        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        } catch (Exception exception) {
            exception.printStackTrace();
        }

        // Create the main window
        mainGuiWindow = new JFrame(windowTitle);
        mainGuiWindow.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        contentPane = mainGuiWindow.getContentPane();
        contentPane.setLayout(new GridBagLayout());

        loginPanel = createLoginPanel();

        interactionTabbedPane = createInteractionPanels();
        contentPane.add(interactionTabbedPane, gridBagConstraints);
        masterStatusPanel = createStatusPanels();
        logAreaTextPane = createLogAreaScrollPane();

    }

    /*
     * This method creates buttons that log an agent in and out, and that set
     * the agent in a state of either ready, not ready or after call waiting.
     *
     * The buttons are used by all of the Agent Interaction (Java) code
     * examples.
     */
    private JPanel createLoginPanel() {

    	JPanel masterLoginPanel = new JPanel();
    	masterLoginPanel.setLayout(new BoxLayout(
         		masterLoginPanel, BoxLayout.Y_AXIS));

        JPanel loginPanel = new JPanel();
        loginPanel.setBackground(ACTIVE_BACKGROUND_COLOR);
        // Put the buttons into a labelled border
        loginPanel.setLayout(new GridLayout(0, 1, 0, 1));
        simplePlaceTitledBorder = BorderFactory
                .createTitledBorder("Simple Place");
        simplePlaceTitledBorder.setTitleFont(BOLD);
        loginPanel.setBorder(simplePlaceTitledBorder);

        // Add a "Log in" button
        loginButton = new JButton("Log In");
        loginPanel.add(loginButton);
        loginButton.setBackground(ACTIVE_BUTTON_COLOR);
        loginButton.setFont(BOLD);

        // Add a "Log out" button
        logoutButton = new JButton("Log Out");
        loginPanel.add(logoutButton);
        logoutButton.setBackground(ACTIVE_BUTTON_COLOR);
        logoutButton.setFont(BOLD);

        // Add a Ready button
        readyButton = new JButton("Ready");
        loginPanel.add(readyButton);
        readyButton.setBackground(ACTIVE_BUTTON_COLOR);
        readyButton.setFont(BOLD);

        // Add a Not Ready button
        notReadyButton = new JButton("Not Ready");
        loginPanel.add(notReadyButton);
        notReadyButton.setBackground(ACTIVE_BUTTON_COLOR);
        notReadyButton.setFont(BOLD);

        // Add an After Call Work button
        afterCallWorkButton = new JButton("ACW");
        loginPanel.add(afterCallWorkButton);
        afterCallWorkButton.setBackground(ACTIVE_BUTTON_COLOR);
        afterCallWorkButton.setFont(BOLD);

        //Add login panel
        masterLoginPanel.add(loginPanel);


//      Add a status table
        placeTableModel = new OpenMediaTableModel();
    	placeTableModel.colName0 = "Name";
    	placeTableModel.colName1 = "Status";
    	placeTableModel.NUM_COLUMNS = 2;

    	JTable placeTable = new JTable(placeTableModel);

    	placeTable.setSelectionBackground(new Color(2,131,212));
    	placeTable.setSelectionForeground(new Color(255,255,255));


    	placeTableScrollPane = new JScrollPane(placeTable);
    	placeTable.setPreferredScrollableViewportSize(new Dimension(120, 80));
    	placeTable.setAutoResizeMode(JTable.AUTO_RESIZE_ALL_COLUMNS);
     	placeTableScrollPane.setBackground(ACTIVE_BACKGROUND_COLOR);

    	masterLoginPanel.add(placeTableScrollPane);




        // Add Simple Place button panel to content pane
        gridBagConstraints.insets = new Insets(1, 0, 0, 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = GridBagConstraints.NORTH;
        contentPane.add(masterLoginPanel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);


        return loginPanel;
    }

    /*
     * This method creates a panel that contains two panels used for voice
     * interactions.
     *
     * The first panel holds widgets used for simple voice interactions, such as
     * making and answering a call, putting a call on hold, and releasing the
     * call. This panel is used by both the SimpleVoiceInteraction and
     * MultipartyVoiceInteraction code examples.
     *
     * The other panel is used for multiparty voice interactions and contains
     * widgets used to transfer a call and set up a three-way conference call.
     */
    private JTabbedPane createInteractionPanels() {
        JTabbedPane interactionTabbedPane = new JTabbedPane();


        /////////////// VOICE ///////////////////////////////////////////////
        masterVoiceInteractionPanel = new JPanel();
        masterVoiceInteractionPanel.setLayout(new BoxLayout(
                masterVoiceInteractionPanel, BoxLayout.Y_AXIS));


        // Create a simple voice interaction panel

        simpleVoiceInteractionPanel = new JPanel();
        simpleVoiceInteractionPanel.setLayout(new BoxLayout(
                simpleVoiceInteractionPanel, BoxLayout.Y_AXIS));
        simpleVoiceInteractionPanelTitledBorder = BorderFactory
                .createTitledBorder("Simple Voice Interaction");
        simpleVoiceInteractionPanel
                .setBorder(simpleVoiceInteractionPanelTitledBorder);

        simpleVoiceTargetDnPanel = createSimpleVoiceTargetDnPanel();
        simpleVoiceInteractionPanel.add(simpleVoiceTargetDnPanel);

        simpleVoiceInteractionPanel.add(Box.createRigidArea(new Dimension(0,
                SPACE_UNDER_TEXT_FIELD)));

        simpleVoiceInteractionBoxPanel = new JPanel();
        simpleVoiceInteractionBoxPanel.setLayout(new BoxLayout(
                simpleVoiceInteractionBoxPanel, BoxLayout.X_AXIS));

        simpleVoiceInteractionButtons = createSimpleVoiceInteractionButtons();
        simpleVoiceInteractionBoxPanel.add(simpleVoiceInteractionButtons);
        simpleVoiceInteractionBoxPanel.add(Box.createRigidArea(new Dimension(
                70, 0)));
        simpleVoiceInteractionPanel.add(simpleVoiceInteractionBoxPanel);
        simpleVoiceInteractionPanel.add(Box.createRigidArea(new Dimension(0,
                SPACE_NEXT_TO_BORDER)));

        masterVoiceInteractionPanel.add(simpleVoiceInteractionPanel);
        multipartyVoiceInteractionPanel = createMultipartyVoiceInteractionPanel();
        masterVoiceInteractionPanel.add(multipartyVoiceInteractionPanel);

        interactionTabbedPane.addTab("Voice", null,
                masterVoiceInteractionPanel, "Voice Interactions");

        if (needSimpleVoiceInteractionWidgets) {
            simpleVoiceInteractionPanel.setBackground(ACTIVE_BACKGROUND_COLOR);
            simpleVoiceInteractionBoxPanel
                    .setBackground(ACTIVE_BACKGROUND_COLOR);
            simpleVoiceTargetDnPanel.setBackground(ACTIVE_BACKGROUND_COLOR);
    		interactionTabbedPane.setSelectedIndex(0);
    		interactionTabbedPane.setBackgroundAt(0,
    				AgentInteractionGui.ACTIVE_BACKGROUND_COLOR);
        }
        if (needMultipartyVoiceInteractionWidgets) {
            multipartyVoiceInteractionPanel
                    .setBackground(ACTIVE_BACKGROUND_COLOR);
            multipartyVoiceTargetDnPanel.setBackground(ACTIVE_BACKGROUND_COLOR);
            multipartyVoiceInteractionButtonPanel
                    .setBackground(ACTIVE_BACKGROUND_COLOR);
            masterMultipartyVoiceRadioButtonPanel
                    .setBackground(ACTIVE_BACKGROUND_COLOR);
            multipartyVoiceRadioButtonPanel
                    .setBackground(ACTIVE_BACKGROUND_COLOR);
        }

        /////////////// EMAIL /////////////////////////////////////////////
        // Add e-mail tab to UI
        masterEmailInteractionPanel = new JPanel();
        masterEmailInteractionPanel.setLayout(new BoxLayout(
                masterEmailInteractionPanel, BoxLayout.Y_AXIS));
        masterEmailInteractionPanelTitledBorder = BorderFactory
                .createTitledBorder("Simple E-Mail Interaction");
        masterEmailInteractionPanel
                .setBorder(masterEmailInteractionPanelTitledBorder);

        JPanel emailInteractionButtonPanel = new JPanel();
        emailInteractionButtonPanel.setLayout(new BoxLayout(
                emailInteractionButtonPanel, BoxLayout.X_AXIS));

        acceptButton = createButton("Accept", emailInteractionButtonPanel);

        replyButton = createButton("Reply", emailInteractionButtonPanel);

        emailReleaseButton = createButton("Release", emailInteractionButtonPanel);

        emailDoneButton = createButton("Done", emailInteractionButtonPanel);

        acceptButton.setEnabled(false);
        replyButton.setEnabled(false);
        emailReleaseButton.setEnabled(false);
        emailDoneButton.setEnabled(false);

        masterEmailInteractionPanel.add(emailInteractionButtonPanel);
        emailInteractionButtonPanel.add(Box.createRigidArea(new Dimension(232,
                0)));

        inboundEmailTextArea = new JTextArea(
                "To accept an incoming e-mail, click the Accept button.");
        inboundEmailTextArea.setEditable(false);
        masterEmailInteractionPanel.add(inboundEmailTextArea);

        interactionTabbedPane.addTab("E-Mail", null,
                masterEmailInteractionPanel, "E-Mail Interactions");

        if (needSimpleEmailInteractionWidgets) {
            masterEmailInteractionPanel.setBackground(ACTIVE_BACKGROUND_COLOR);
            emailInteractionButtonPanel.setBackground(ACTIVE_BACKGROUND_COLOR);
            acceptButton.setBackground(ACTIVE_BUTTON_COLOR);
            replyButton.setBackground(ACTIVE_BUTTON_COLOR);
            emailReleaseButton.setBackground(ACTIVE_BUTTON_COLOR);
            emailDoneButton.setBackground(ACTIVE_BUTTON_COLOR);
            masterEmailInteractionPanelTitledBorder.setTitleFont(BOLD);
            acceptButton.setFont(BOLD);
            replyButton.setFont(BOLD);
            emailReleaseButton.setFont(BOLD);
            emailDoneButton.setFont(BOLD);
            interactionTabbedPane.setSelectedIndex(1);
    		interactionTabbedPane.setBackgroundAt(1,
    				AgentInteractionGui.ACTIVE_BACKGROUND_COLOR);
        }


        /////////////// OPEN MEDIA ///////////////////////////////////////////////
        // Add Open Media tab to UI
        masterOpenMediaInteractionPanel = new JPanel();
        masterOpenMediaInteractionPanel.setLayout(new BoxLayout(
                masterOpenMediaInteractionPanel, BoxLayout.Y_AXIS));
        masterOpenMediaInteractionPanelTitledBorder = BorderFactory
                .createTitledBorder("Simple Open Media Interaction");
        masterOpenMediaInteractionPanel
                .setBorder(masterOpenMediaInteractionPanelTitledBorder);

        JPanel openMediaInteractionButtonPanel = new JPanel();
        openMediaInteractionButtonPanel.setLayout(new BoxLayout(
                openMediaInteractionButtonPanel, BoxLayout.X_AXIS));

        acceptOpenMediaInteractionButton = createButton("Accept", openMediaInteractionButtonPanel);
        acceptOpenMediaInteractionButton.setEnabled(false);

        openMediaInteractionDoneButton = createButton("Done", openMediaInteractionButtonPanel);
        openMediaInteractionDoneButton.setEnabled(false);

        acceptOpenMediaInteractionButton.setEnabled(false);
        openMediaInteractionDoneButton.setEnabled(false);

        masterOpenMediaInteractionPanel.add(openMediaInteractionButtonPanel);
        openMediaInteractionButtonPanel.add(Box.createRigidArea(new Dimension(180,
                0)));

        openMediaTextArea = new JTextArea(
                "To accept an Open Media interaction, click the Accept button.");
        openMediaTextArea.setEditable(false);
        masterOpenMediaInteractionPanel.add(openMediaTextArea);

        interactionTabbedPane.addTab("Open Media", null,
                masterOpenMediaInteractionPanel, "Open Media Interactions");

        if (needSimpleOpenMediaInteractionWidgets) {
            masterOpenMediaInteractionPanel.setBackground(ACTIVE_BACKGROUND_COLOR);
            openMediaInteractionButtonPanel.setBackground(ACTIVE_BACKGROUND_COLOR);
            acceptOpenMediaInteractionButton.setBackground(ACTIVE_BUTTON_COLOR);
            openMediaInteractionDoneButton.setBackground(ACTIVE_BUTTON_COLOR);
            masterOpenMediaInteractionPanelTitledBorder.setTitleFont(BOLD);
            acceptOpenMediaInteractionButton.setFont(BOLD);
            openMediaInteractionDoneButton.setFont(BOLD);
            interactionTabbedPane.setSelectedIndex(2);
        }

        
        ///////////////////////////////////////////////////////////////////////////////
        //// Add Chat tab to UI
        
        
        
        masterChatInteractionPanel = new JPanel();
        masterChatInteractionPanel.setLayout(new BoxLayout(
        		masterChatInteractionPanel, BoxLayout.Y_AXIS));
        masterChatInteractionPanelTitledBorder = BorderFactory.createTitledBorder("Simple Chat Interaction");
        masterChatInteractionPanel.setBorder(masterChatInteractionPanelTitledBorder);

        JPanel chatInteractionButtonPanel = new JPanel();
        chatInteractionButtonPanel.setLayout(new BoxLayout(
        		chatInteractionButtonPanel, BoxLayout.X_AXIS));

        joinChatInteractionButton = createButton("Join", chatInteractionButtonPanel);
        joinChatInteractionButton.setEnabled(false);
        
        quitChatInteractionButton = createButton("Disconnect", chatInteractionButtonPanel);
        quitChatInteractionButton.setEnabled(false);

        doneChatInteractionButton = createButton("Done", chatInteractionButtonPanel);
        doneChatInteractionButton.setEnabled(false);
        
        coBrowseCheckBox = new JCheckBox();
        coBrowseCheckBox.setText("CoBrowse");
        coBrowseCheckBox.setEnabled(false);
        chatInteractionButtonPanel.add(coBrowseCheckBox);

        masterChatInteractionPanel.add(chatInteractionButtonPanel);
        chatInteractionButtonPanel.add(Box.createRigidArea(new Dimension(150,
                0)));
        
        masterChatInteractionPanel.add(this.createChatSessionScrollPane());
        this.writeChatMessage("fyi","To start the chat session, click the Accept button.", DEFAULT_STYLE);
        masterChatInteractionPanel.add(this.createSendChatMsgPanel());

        interactionTabbedPane.addTab("Chat", null,
                masterChatInteractionPanel, "Chat Interactions");

        if (needSimpleChatInteractionWidgets) {
        	masterChatInteractionPanel.setBackground(ACTIVE_BACKGROUND_COLOR);
            chatInteractionButtonPanel.setBackground(ACTIVE_BACKGROUND_COLOR);
            joinChatInteractionButton.setBackground(ACTIVE_BUTTON_COLOR);
            doneChatInteractionButton.setBackground(ACTIVE_BUTTON_COLOR);
            quitChatInteractionButton.setBackground(ACTIVE_BUTTON_COLOR);
            sendChatMsgButton.setBackground(ACTIVE_BUTTON_COLOR);
            coBrowseCheckBox.setBackground(ACTIVE_BUTTON_COLOR);
            masterChatInteractionPanelTitledBorder.setTitleFont(BOLD);
            joinChatInteractionButton.setFont(BOLD);
            doneChatInteractionButton.setFont(BOLD);
            quitChatInteractionButton.setFont(BOLD);
            coBrowseCheckBox.setFont(BOLD);
            sendChatMsgButton.setFont(BOLD);
            interactionTabbedPane.setSelectedIndex(3);
        }
                 
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = GridBagConstraints.NORTH;
        return interactionTabbedPane;
    }

    /**
     * Creates a dialog box to send the reply to an e-mail.
     * @param subject
     * @param addresses
     * @param text
     */
	public void createReplyWindow(String subject, String addresses, String text)
	{
		// This window contains a header, send button, and a text pane

		/// -> This build of the subject is done by AIL
		replyWindow = new JFrame(subject);
		replyWindow.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		Container contentPane = replyWindow.getContentPane();
		contentPane.setBackground(AgentInteractionGui.ACTIVE_BACKGROUND_COLOR);
		contentPane.setLayout(new BoxLayout(contentPane, BoxLayout.Y_AXIS));
		JPanel responseHeaderPanel = new JPanel();
		responseHeaderPanel
		.setBackground(AgentInteractionGui.ACTIVE_BACKGROUND_COLOR);
		responseHeaderPanel.setLayout(new BoxLayout(responseHeaderPanel,
				BoxLayout.X_AXIS));

		JLabel responseRecipient = new JLabel("To: " + addresses);
		responseRecipient.setFont(AgentInteractionGui.BOLD);
		responseHeaderPanel.add(responseRecipient);
		responseHeaderPanel.add(Box.createRigidArea(new Dimension(40, 0)));



		// Add a Send button
		sendButton = new JButton("Send");
		sendButton.setBackground(AgentInteractionGui.ACTIVE_BUTTON_COLOR);
		sendButton.setFont(AgentInteractionGui.BOLD);
		responseHeaderPanel.add(sendButton);
		contentPane.add(responseHeaderPanel);

		responseTextArea = new JTextArea(
				"\n\n_________________________________\n" + text);
		responseTextArea.setCaretPosition(0);
		responseTextArea.requestFocus();
		contentPane.add(responseTextArea);



		replyWindow.pack();
		replyWindow.setVisible(true);
		responseTextArea.requestFocus();

	}

    /**
     * Creates a dialog box to display co-browsed URLs.
     * @param subject
     * @param urls
     */
	public void createCoBrowseWindow(String subject, String[] urls)
	{
		// This window contains a list of urls

		coBrowseWindow = new JFrame(subject);
		coBrowseWindow.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		Container contentPane = coBrowseWindow.getContentPane();
		contentPane.setBackground(AgentInteractionGui.ACTIVE_BACKGROUND_COLOR);
		contentPane.setLayout(new BoxLayout(contentPane, BoxLayout.Y_AXIS));	
		coBmodel = new DefaultListModel ();
		for(int i=0;i<urls.length;i++)
			coBmodel.addElement(urls[i]);
		JList coBrowseList = new JList(coBmodel);
		JScrollPane coBScrollPane = new JScrollPane(coBrowseList);
		coBScrollPane.setPreferredSize(new Dimension(290, 110));
		coBScrollPane.setMinimumSize(new Dimension(250, 110));
		
		contentPane.add(coBScrollPane);
		coBrowseWindow.pack();
		coBrowseWindow.setVisible(true);

	}

	
    /*
     * This method creates the label and text field used for entering a
     * telephone number that may be called using the "Make Call" button.
     */
    private JPanel createSimpleVoiceTargetDnPanel() {
        JPanel simpleVoiceTargetDnPanel = new JPanel();
        simpleVoiceTargetDnPanel.setLayout(new BoxLayout(
                simpleVoiceTargetDnPanel, BoxLayout.X_AXIS));

        simpleVoiceTargetDnLabel = new JLabel("Target DN: ");
        simpleVoiceTargetDnPanel.add(simpleVoiceTargetDnLabel);
        simpleVoiceTargetDnTextField = new JTextField(10);
        simpleVoiceTargetDnTextField.setEditable(true);
        simpleVoiceTargetDnPanel.add(simpleVoiceTargetDnTextField);
        simpleVoiceTargetDnPanel
                .add(Box.createRigidArea(new Dimension(100, 0)));

        // If these widgets aren't needed, disable them
        if (!needSimpleVoiceInteractionWidgets) {
            simpleVoiceTargetDnLabel.setEnabled(false);
            simpleVoiceTargetDnTextField.setEnabled(false);
            simpleVoiceTargetDnTextField.setEditable(false);
        }

        return simpleVoiceTargetDnPanel;
    }

    /*
     * This method creates the buttons used to answer and make a call, to put it
     * on hold and retrieve it, and to release the call and mark it done.
     */
    private JPanel createSimpleVoiceInteractionButtons() {
        JPanel simpleVoiceInteractionButtons = new JPanel();
        simpleVoiceInteractionButtons.setLayout(new GridLayout(2, 0, 0, 1));

        answerButton = createButton("Answer", simpleVoiceInteractionButtons);
        releaseButton = createButton("Release", simpleVoiceInteractionButtons);
        doneButton = createButton("Done", simpleVoiceInteractionButtons);
        makeCallButton = createButton("Make Call",simpleVoiceInteractionButtons);
        holdButton = createButton("Hold", simpleVoiceInteractionButtons);
        retrieveButton = createButton("Retrieve", simpleVoiceInteractionButtons);

    	answerButton.setEnabled(false);
		makeCallButton.setEnabled(false);
		releaseButton.setEnabled(false);
		doneButton.setEnabled(false);
		holdButton.setEnabled(false);
		retrieveButton.setEnabled(false);

        if (needSimpleVoiceInteractionWidgets) {
            answerButton.setBackground(ACTIVE_BUTTON_COLOR);
            releaseButton.setBackground(ACTIVE_BUTTON_COLOR);
            doneButton.setBackground(ACTIVE_BUTTON_COLOR);
            makeCallButton.setBackground(ACTIVE_BUTTON_COLOR);
            holdButton.setBackground(ACTIVE_BUTTON_COLOR);
            retrieveButton.setBackground(ACTIVE_BUTTON_COLOR);
            simpleVoiceInteractionPanelTitledBorder.setTitleFont(BOLD);
            simpleVoiceTargetDnLabel.setFont(BOLD);
            answerButton.setFont(BOLD);
            releaseButton.setFont(BOLD);
            doneButton.setFont(BOLD);
            makeCallButton.setFont(BOLD);
            holdButton.setFont(BOLD);
            retrieveButton.setFont(BOLD);
        }


        return simpleVoiceInteractionButtons;
    }

    /*
     * This method creates the panel that holds the multiparty voice interaction
     * widgets. These widgets are contained in panels that are nested inside
     * this one.
     */
    private JPanel createMultipartyVoiceInteractionPanel() {
        JPanel multipartyVoiceInteractionPanel = new JPanel();
        multipartyVoiceInteractionPanel.setLayout(new BoxLayout(
                multipartyVoiceInteractionPanel, BoxLayout.Y_AXIS));
        multipartyVoiceInteractionPanelTitledBorder = BorderFactory
                .createTitledBorder("Multiparty Voice Interaction");
        multipartyVoiceInteractionPanel
                .setBorder(BorderFactory
                        .createTitledBorder(multipartyVoiceInteractionPanelTitledBorder));

        multipartyVoiceTargetDnPanel = createMultipartyVoiceTargetDnPanel();

        multipartyVoiceInteractionPanel.add(multipartyVoiceTargetDnPanel);

        multipartyVoiceInteractionPanel.add(Box.createRigidArea(new Dimension(
                0, SPACE_UNDER_TEXT_FIELD)));

        multipartyVoiceInteractionButtonPanel = createMultipartyVoiceInteractionButtonPanel();

        multipartyVoiceInteractionPanel
                .add(multipartyVoiceInteractionButtonPanel);

        multipartyVoiceInteractionPanel.add(Box.createRigidArea(new Dimension(
                0, SPACE_NEXT_TO_BORDER)));

        masterMultipartyVoiceRadioButtonPanel = createMultipartyVoiceRadioButtonPanel();
        multipartyVoiceInteractionPanel
                .add(masterMultipartyVoiceRadioButtonPanel);

        multipartyVoiceInteractionPanel.add(Box.createRigidArea(new Dimension(
                0, SPACE_NEXT_TO_BORDER)));

        if (!needMultipartyVoiceInteractionWidgets) {
            multipartyVoiceTargetDnLabel.setEnabled(false);
            multipartyVoiceTargetDnTextField.setEnabled(false);
            multipartyVoiceReasonLabel.setEnabled(false);
            multipartyVoiceReasonTextField.setEnabled(false);
            conferenceButton.setEnabled(false);
            transferButton.setEnabled(false);
            completeButton.setEnabled(false);
            singleStepRadioButton.setEnabled(false);
            dualStepRadioButton.setEnabled(false);
            muteTransferRadioButton.setEnabled(false);
        }

        return multipartyVoiceInteractionPanel;
    }

    private JPanel createMultipartyVoiceTargetDnPanel() {
        JPanel multipartyVoiceTargetDnPanel = new JPanel();
        multipartyVoiceTargetDnPanel.setLayout(new BoxLayout(
                multipartyVoiceTargetDnPanel, BoxLayout.X_AXIS));

        multipartyVoiceTargetDnLabel = new JLabel("Target DN: ");
        multipartyVoiceTargetDnPanel.add(multipartyVoiceTargetDnLabel);
        multipartyVoiceTargetDnTextField = new JTextField(10);
        multipartyVoiceTargetDnPanel.add(multipartyVoiceTargetDnTextField);
        multipartyVoiceTargetDnPanel.add(Box
                .createRigidArea(new Dimension(9, 0)));
        multipartyVoiceReasonLabel = new JLabel("Reason: ");
        multipartyVoiceTargetDnPanel.add(multipartyVoiceReasonLabel);
        multipartyVoiceReasonTextField = new JTextField(10);
        multipartyVoiceTargetDnPanel.add(multipartyVoiceReasonTextField);

        if (needMultipartyVoiceInteractionWidgets) {
            multipartyVoiceTargetDnLabel.setFont(BOLD);
            multipartyVoiceReasonLabel.setFont(BOLD);
        }

        return multipartyVoiceTargetDnPanel;
    }

    private JPanel createMultipartyVoiceInteractionButtonPanel() {
        JPanel multipartyVoiceInteractionButtonPanel = new JPanel();
        multipartyVoiceInteractionButtonPanel.setLayout(new BoxLayout(
                multipartyVoiceInteractionButtonPanel, BoxLayout.X_AXIS));

        conferenceButton = createButton("Conference",
                multipartyVoiceInteractionButtonPanel);
        conferenceButton.setEnabled(false);

        transferButton = createButton("Transfer",
                multipartyVoiceInteractionButtonPanel);
        transferButton.setEnabled(false);

        completeButton = createButton("Complete",
                multipartyVoiceInteractionButtonPanel);
        completeButton.setEnabled(false);
        multipartyVoiceInteractionButtonPanel.add(Box
                .createRigidArea(new Dimension(70, 0)));

        if (needMultipartyVoiceInteractionWidgets) {
            conferenceButton.setBackground(ACTIVE_BUTTON_COLOR);
            transferButton.setBackground(ACTIVE_BUTTON_COLOR);
            completeButton.setBackground(ACTIVE_BUTTON_COLOR);
            multipartyVoiceInteractionPanelTitledBorder.setTitleFont(BOLD);
            conferenceButton.setFont(BOLD);
            transferButton.setFont(BOLD);
            completeButton.setFont(BOLD);
        }

        conferenceButton.setEnabled(false);
        transferButton.setEnabled(false);
        completeButton.setEnabled(false);

        return multipartyVoiceInteractionButtonPanel;
    }

    private JPanel createMultipartyVoiceRadioButtonPanel() {
        JPanel masterMultipartyVoiceRadioButtonPanel = new JPanel();
        masterMultipartyVoiceRadioButtonPanel.setLayout(new BoxLayout(
                masterMultipartyVoiceRadioButtonPanel, BoxLayout.X_AXIS));

        multipartyVoiceRadioButtonPanel = new JPanel();
        multipartyVoiceRadioButtonPanel.setLayout(new BoxLayout(
                multipartyVoiceRadioButtonPanel, BoxLayout.X_AXIS));
        multipartyVoiceRadioButtonPanelTitledBorder = BorderFactory
                .createTitledBorder("Select Transfer Type");
        multipartyVoiceRadioButtonPanel
                .setBorder(BorderFactory
                        .createTitledBorder(multipartyVoiceRadioButtonPanelTitledBorder));

        singleStepRadioButton = new JRadioButton("Single Step", true);
        singleStepRadioButton.setEnabled(false);
        singleStepRadioButton.setMnemonic(KeyEvent.VK_E);
        singleStepRadioButton.setActionCommand("enable");
        singleStepRadioButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent event) {
            	singleStepRadioButton.setSelected(true);
            	dualStepRadioButton.setSelected(false);
            	muteTransferRadioButton.setSelected(false);
            }
        });


        multipartyVoiceRadioButtonPanel.add(singleStepRadioButton);

        dualStepRadioButton = new JRadioButton("Dual Step");
        dualStepRadioButton.setEnabled(false);
        dualStepRadioButton.setMnemonic(KeyEvent.VK_E);
        dualStepRadioButton.setActionCommand("enable");
        dualStepRadioButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent event) {
                singleStepRadioButton.setSelected(false);
                dualStepRadioButton.setSelected(true);
                muteTransferRadioButton.setSelected(false);
            }
        });
        multipartyVoiceRadioButtonPanel.add(dualStepRadioButton);

        muteTransferRadioButton = new JRadioButton("Mute");
        muteTransferRadioButton.setMnemonic(KeyEvent.VK_E);
        muteTransferRadioButton.setActionCommand("enable");
        muteTransferRadioButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent event) {
            	singleStepRadioButton.setSelected(false);
            	dualStepRadioButton.setSelected(false);
            	muteTransferRadioButton.setSelected(true);
            }
        });

        muteTransferRadioButton.setEnabled(false);
        multipartyVoiceRadioButtonPanel.add(muteTransferRadioButton);

        if (needMultipartyVoiceInteractionWidgets) {
            singleStepRadioButton.setBackground(ACTIVE_BUTTON_COLOR);
            dualStepRadioButton.setBackground(ACTIVE_BUTTON_COLOR);
            muteTransferRadioButton.setBackground(ACTIVE_BUTTON_COLOR);
            multipartyVoiceRadioButtonPanelTitledBorder.setTitleFont(BOLD);
            singleStepRadioButton.setFont(BOLD);
            dualStepRadioButton.setFont(BOLD);
            muteTransferRadioButton.setFont(BOLD);
        }

        masterMultipartyVoiceRadioButtonPanel
                .add(multipartyVoiceRadioButtonPanel);

        masterMultipartyVoiceRadioButtonPanel.add(Box
                .createRigidArea(new Dimension(99, 0)));

        return masterMultipartyVoiceRadioButtonPanel;
    }

    private JPanel createStatusPanels() {
        JPanel masterStatusPanel = new JPanel();
        masterStatusPanel.setLayout(new BoxLayout(masterStatusPanel,
                BoxLayout.Y_AXIS));

        JPanel agentStatusPanel = createAgentStatusPanel();
        masterStatusPanel.add(agentStatusPanel);

        if(this.needSimpleVoiceInteractionWidgets)
        {
        	 JPanel interactionInfoPanel = createInteractionInfoPanel();
             masterStatusPanel.add(interactionInfoPanel);
        }

        interactionEventLogConfigurationPanel = createInteractionEventLogConfigurationPanel();
        masterStatusPanel.add(interactionEventLogConfigurationPanel);
        dnEventLogConfigurationPanel = createDnEventLogConfigurationPanel();
        masterStatusPanel.add(dnEventLogConfigurationPanel);
        placeEventLogConfigurationPanel = createPlaceEventLogConfigurationPanel();
        masterStatusPanel.add(placeEventLogConfigurationPanel);

        masterStatusPanel.add(Box.createRigidArea(new Dimension(0, 15)));

        gridBagConstraints.ipadx = 10;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = GridBagConstraints.NORTH;
        contentPane.add(masterStatusPanel, gridBagConstraints);

        return masterStatusPanel;
    }

    private JPanel createInteractionEventLogConfigurationPanel() {
        JPanel interactionEventLogConfigurationPanel = new JPanel();
        interactionEventLogConfigurationPanel.setLayout(new BoxLayout(
                interactionEventLogConfigurationPanel, BoxLayout.X_AXIS));

        TitledBorder logMessageConfigurationPanelTitledBorder = BorderFactory
                .createTitledBorder("Interaction Event Log Messages");
        interactionEventLogConfigurationPanel.setBorder(BorderFactory
                .createTitledBorder(logMessageConfigurationPanelTitledBorder));

        noInteractionEventsLoggingRadioButton = new JRadioButton("None");
        noInteractionEventsLoggingRadioButton.setActionCommand("enable");
        noInteractionEventsLoggingRadioButton
                .addActionListener(new ActionListener() {
                    public void actionPerformed(ActionEvent event) {
                        logInteractionEvents = false;
                        createDetailedInteractionEventMessages = false;
                        noInteractionEventsLoggingRadioButton.setSelected(true);
                        standardInteractionEventsLoggingRadioButton
                                .setSelected(false);
                        debugInteractionEventsLoggingRadioButton
                                .setSelected(false);
                    }
                });
        interactionEventLogConfigurationPanel
                .add(noInteractionEventsLoggingRadioButton);

        standardInteractionEventsLoggingRadioButton = new JRadioButton(
                "Standard", true);
        standardInteractionEventsLoggingRadioButton.setActionCommand("enable");
        standardInteractionEventsLoggingRadioButton
                .addActionListener(new ActionListener() {
                    public void actionPerformed(ActionEvent event) {
                        logInteractionEvents = true;
                        createDetailedInteractionEventMessages = false;
                        noInteractionEventsLoggingRadioButton
                                .setSelected(false);
                        standardInteractionEventsLoggingRadioButton
                                .setSelected(true);
                        debugInteractionEventsLoggingRadioButton
                                .setSelected(false);
                    }
                });
        interactionEventLogConfigurationPanel
                .add(standardInteractionEventsLoggingRadioButton);

        debugInteractionEventsLoggingRadioButton = new JRadioButton("Debug");
        debugInteractionEventsLoggingRadioButton.setActionCommand("enable");
        debugInteractionEventsLoggingRadioButton
                .addActionListener(new ActionListener() {
                    public void actionPerformed(ActionEvent event) {
                        logInteractionEvents = true;
                        createDetailedInteractionEventMessages = true;
                        noInteractionEventsLoggingRadioButton
                                .setSelected(false);
                        standardInteractionEventsLoggingRadioButton
                                .setSelected(false);
                        debugInteractionEventsLoggingRadioButton
                                .setSelected(true);
                    }
                });
        interactionEventLogConfigurationPanel
                .add(debugInteractionEventsLoggingRadioButton);

        return interactionEventLogConfigurationPanel;
    }

    private JPanel createDnEventLogConfigurationPanel() {
        JPanel dnEventLogConfigurationPanel = new JPanel();
        dnEventLogConfigurationPanel.setLayout(new BoxLayout(
                dnEventLogConfigurationPanel, BoxLayout.X_AXIS));

        TitledBorder dnEventLogConfigurationPanelTitledBorder = BorderFactory
                .createTitledBorder("DN Event Log Messages");
        dnEventLogConfigurationPanel.setBorder(BorderFactory
                .createTitledBorder(dnEventLogConfigurationPanelTitledBorder));

        noDnEventsLoggingRadioButton = new JRadioButton("None");
        noDnEventsLoggingRadioButton.setActionCommand("enable");
        noDnEventsLoggingRadioButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent event) {
                logDnEvents = false;
                createDetailedDnEventMessages = false;
                noDnEventsLoggingRadioButton.setSelected(true);
                standardDnEventsLoggingRadioButton.setSelected(false);
                debugDnEventsLoggingRadioButton.setSelected(false);
            }
        });
        dnEventLogConfigurationPanel.add(noDnEventsLoggingRadioButton);

        standardDnEventsLoggingRadioButton = new JRadioButton("Standard", true);
        standardDnEventsLoggingRadioButton.setActionCommand("enable");
        standardDnEventsLoggingRadioButton
                .addActionListener(new ActionListener() {
                    public void actionPerformed(ActionEvent event) {
                        logDnEvents = true;
                        createDetailedDnEventMessages = false;
                        noDnEventsLoggingRadioButton.setSelected(false);
                        standardDnEventsLoggingRadioButton.setSelected(true);
                        debugDnEventsLoggingRadioButton.setSelected(false);
                    }
                });
        dnEventLogConfigurationPanel.add(standardDnEventsLoggingRadioButton);

        debugDnEventsLoggingRadioButton = new JRadioButton("Debug");
        debugDnEventsLoggingRadioButton.setActionCommand("enable");
        debugDnEventsLoggingRadioButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent event) {
                logDnEvents = true;
                createDetailedDnEventMessages = true;
                noDnEventsLoggingRadioButton.setSelected(false);
                standardDnEventsLoggingRadioButton.setSelected(false);
                debugDnEventsLoggingRadioButton.setSelected(true);
            }
        });
        dnEventLogConfigurationPanel.add(debugDnEventsLoggingRadioButton);

        return dnEventLogConfigurationPanel;
    }

    private JPanel createPlaceEventLogConfigurationPanel() {
        JPanel placeEventLogConfigurationPanel = new JPanel();
        placeEventLogConfigurationPanel.setLayout(new BoxLayout(
                placeEventLogConfigurationPanel, BoxLayout.X_AXIS));

        TitledBorder placeEventLogConfigurationPanelTitledBorder = BorderFactory
                .createTitledBorder("Place Event Log Messages");
        placeEventLogConfigurationPanel
                .setBorder(BorderFactory
                        .createTitledBorder(placeEventLogConfigurationPanelTitledBorder));

        noPlaceEventsLoggingRadioButton = new JRadioButton("None");
        noPlaceEventsLoggingRadioButton.setActionCommand("enable");
        noPlaceEventsLoggingRadioButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent event) {
                logPlaceEvents = false;
                createDetailedPlaceEventMessages = false;
                noPlaceEventsLoggingRadioButton.setSelected(true);
                standardPlaceEventsLoggingRadioButton.setSelected(false);
                debugPlaceEventsLoggingRadioButton.setSelected(false);
            }
        });
        placeEventLogConfigurationPanel.add(noPlaceEventsLoggingRadioButton);

        standardPlaceEventsLoggingRadioButton = new JRadioButton("Standard",
                true);
        standardPlaceEventsLoggingRadioButton.setActionCommand("enable");
        standardPlaceEventsLoggingRadioButton
                .addActionListener(new ActionListener() {
                    public void actionPerformed(ActionEvent event) {
                        logPlaceEvents = true;
                        createDetailedPlaceEventMessages = false;
                        noPlaceEventsLoggingRadioButton.setSelected(false);
                        standardPlaceEventsLoggingRadioButton.setSelected(true);
                        debugPlaceEventsLoggingRadioButton.setSelected(false);
                    }
                });
        placeEventLogConfigurationPanel
                .add(standardPlaceEventsLoggingRadioButton);

        debugPlaceEventsLoggingRadioButton = new JRadioButton("Debug");
        debugPlaceEventsLoggingRadioButton.setActionCommand("enable");
        debugPlaceEventsLoggingRadioButton
                .addActionListener(new ActionListener() {
                    public void actionPerformed(ActionEvent event) {
                        logPlaceEvents = true;
                        createDetailedPlaceEventMessages = true;
                        noPlaceEventsLoggingRadioButton.setSelected(false);
                        standardPlaceEventsLoggingRadioButton
                                .setSelected(false);
                        debugPlaceEventsLoggingRadioButton.setSelected(true);
                    }
                });
        placeEventLogConfigurationPanel.add(debugPlaceEventsLoggingRadioButton);

        return placeEventLogConfigurationPanel;
    }

    private JPanel createAgentStatusPanel() {
        JPanel agentStatusPanel = new JPanel();
        agentStatusPanel.setLayout(new GridLayout(0, 1, 0, 1));
        agentStatusPanel.setBorder(BorderFactory
                .createTitledBorder("Status Info"));
        agentStatusPanel.setMaximumSize(new Dimension(180, 150));
        loginNameLabel = new JLabel();
        agentStatusPanel.add(loginNameLabel);

        // Build a label for the DN status.
        dnLabel = new JLabel();
        agentStatusPanel.add(dnLabel);

        agentPlaceLabel = new JLabel();
        agentStatusPanel.add(agentPlaceLabel);

        agentQueueLabel = new JLabel();
        agentStatusPanel.add(agentQueueLabel);

        return agentStatusPanel;
    }

    private JPanel createInteractionInfoPanel() {
        JPanel interactionInfoPanel = new JPanel();
        interactionInfoPanel.setLayout(new GridLayout(0, 1, 0, 1));
        interactionInfoPanel.setBorder(BorderFactory
                .createTitledBorder("Interaction Information"));
        interactionInfoPanel.setMaximumSize(new Dimension(180, 150));
        interactionDnisLabel = new JLabel("DNIS: ");
        interactionInfoPanel.add(interactionDnisLabel);

        interactionAniLabel = new JLabel("ANI: ");
        interactionInfoPanel.add(interactionAniLabel);

        interactionSubjectLabel = new JLabel("Subject: ");
        interactionInfoPanel.add(interactionSubjectLabel);

        interactionPartiesLabel = new JLabel("Parties: ");
        interactionInfoPanel.add(interactionPartiesLabel);

        return interactionInfoPanel;
    }
    
    private JScrollPane createChatSessionScrollPane() {
        chatSessionTextPane = new JTextPane();
        chatSessionTextPane.setEditable(false);
        chatSessionStyledDocument = chatSessionTextPane.getStyledDocument();
        Style defaultStyle = StyleContext.getDefaultStyleContext().getStyle(
                StyleContext.DEFAULT_STYLE);

        Style regular = chatSessionStyledDocument.addStyle("regular", defaultStyle);
        StyleConstants.setFontFamily(defaultStyle, "SansSerif");

        Style style = chatSessionStyledDocument.addStyle(AGENT_STYLE, regular);
        StyleConstants.ColorConstants.setForeground(style, AGENT_COLOR);

        style = chatSessionStyledDocument.addStyle(CUSTO_STYLE, regular);
        StyleConstants.ColorConstants.setForeground(style, CUSTO_COLOR);

        style = chatSessionStyledDocument
                .addStyle(ELSE_STYLE, regular);
        StyleConstants.ColorConstants.setForeground(style,
                ELSE_COLOR);

        style = chatSessionStyledDocument
        .addStyle(ERROR_STYLE, regular);
StyleConstants.ColorConstants.setForeground(style,
        ERROR_COLOR);

        chatSessionScrollPane = new JScrollPane(chatSessionTextPane,
                JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,
                JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        chatSessionScrollPane.setPreferredSize(new Dimension(150, 100));
        chatSessionScrollPane.setMinimumSize(new Dimension(10, 10));
        
        return chatSessionScrollPane;
        
        
    }
    
    void setChatCaretPosition() {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
            	chatSessionTextPane.setCaretPosition(chatSessionStyledDocument
                        .getLength());
            }
        });
    }
    
    private JPanel createSendChatMsgPanel() {
    	    	
        JPanel sendChatMsgPanel = new JPanel();
        sendChatMsgPanel.setLayout(new BoxLayout(
        		sendChatMsgPanel, BoxLayout.X_AXIS));

        int rows = 6;
        int cols = 25;
        chatMsgTextArea  = new JTextArea("Enter your message.", rows, cols);
        chatMsgTextArea.setEnabled(false);
        chatMsgTextArea.setBorder((LineBorder)BorderFactory.createLineBorder(Color.black));

        sendChatMsgPanel.add(chatMsgTextArea);
        
        sendChatMsgButton = new JButton("Send");
        sendChatMsgButton.setEnabled(false);
        sendChatMsgPanel.add(sendChatMsgButton);
        
        return sendChatMsgPanel;
    }
    
    public void writeChatMessage(String id, String msgString, String msgStyle) {
        try {
        	chatSessionStyledDocument.insertString(chatSessionStyledDocument
                    .getLength(),id +
                    "> "+ msgString+ newline,
                    chatSessionStyledDocument.getStyle(msgStyle));
            setChatCaretPosition();
        } catch (BadLocationException badLocationException) {
            System.err.println("Couldn't insert chat message into text pane.");
        }
    }
    

    private JTextPane createLogAreaScrollPane() {
        JTextPane logAreaTextPane = new JTextPane();
        logAreaStyledDocument = logAreaTextPane.getStyledDocument();
        Style defaultStyle = StyleContext.getDefaultStyleContext().getStyle(
                StyleContext.DEFAULT_STYLE);

        Style regular = logAreaStyledDocument.addStyle("regular", defaultStyle);
        StyleConstants.setFontFamily(defaultStyle, "SansSerif");

        Style style = logAreaStyledDocument.addStyle(DN_EVENT_STYLE, regular);
        StyleConstants.ColorConstants.setForeground(style, DN_EVENT_COLOR);

        style = logAreaStyledDocument.addStyle(PLACE_EVENT_STYLE, regular);
        StyleConstants.ColorConstants.setForeground(style, PLACE_EVENT_COLOR);

        style = logAreaStyledDocument
                .addStyle(INTERACTION_EVENT_STYLE, regular);
        StyleConstants.ColorConstants.setForeground(style,
                INTERACTION_EVENT_COLOR);

        style = logAreaStyledDocument
        .addStyle(ERROR_STYLE, regular);
StyleConstants.ColorConstants.setForeground(style,
        ERROR_COLOR);

        logAreaTextPaneScrollPane = new JScrollPane(logAreaTextPane,
                JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,
                JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        logAreaTextPaneScrollPane.setPreferredSize(new Dimension(250, 155));
        logAreaTextPaneScrollPane.setMinimumSize(new Dimension(10, 10));
        logAreaTextPane.setEditable(false);
        gridBagConstraints.gridwidth = GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = GridBagConstraints.REMAINDER;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        contentPane.add(logAreaTextPaneScrollPane, gridBagConstraints);
        return logAreaTextPane;
    }


	/**
	 * Adds or updates a line of the place table.
	 */
	public void setPlaceStatus(String name, String status){
		// The name is the DN ID or the media name.
		// Duplicated to be displayed.
		placeTableModel.update(name, name, status) ;
	}
    /**
     * Removes a queue from the Queues table.
     */
    public void removeStatus(String name){
    	placeTableModel.removeID(name) ;
    }

    private JButton createButton(String buttonText, JPanel panel) {
        JButton button = new JButton(buttonText);
        panel.add(button);
        return button;
    }

    void writeLogMessage(String eventString, String eventStyle) {
        try {
            logAreaStyledDocument.insertString(logAreaStyledDocument
                    .getLength(),
                    createTimeStamp()+ " "+ eventString+ newline,
					logAreaStyledDocument.getStyle(eventStyle));
            setCaretPosition();
        } catch (BadLocationException badLocationException) {
            System.err.println("Couldn't insert text into text pane.");
        }
    }


    
    void setCaretPosition() {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                logAreaTextPane.setCaretPosition(logAreaStyledDocument
                        .getLength());
            }
        });
    }
    protected String createTimeStamp() {
        // Create a time stamp for application log window messages
        return timestamp.format(new GregorianCalendar().getTime());
    }

    public static void main(String[] args) {
        AgentInteractionGui agentInteractionGui = new AgentInteractionGui(
                "Agent Interaction (Java): GUI Test",
                "SimpleChatInteraction");
        agentInteractionGui.mainGuiWindow.pack();
        agentInteractionGui.mainGuiWindow.setVisible(true);
    }

}