/*=====================================================================
Any authorized distribution of any copy of this code (including any related documentation) must reproduce the following restrictions, disclaimer and copyright notice:
The Genesys name, trademarks and/or logo(s) of Genesys shall not be used to name (even as a part of another name), endorse and/or promote products derived from this code without prior written permission from Genesys Telecommunications Laboratories, Inc.
The use, copy, and/or distribution of this code is subject to the terms of the Genesys Developer License Agreement.  This code shall not be used, copied, and/or distributed under any other license agreement.
THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES, INC. (GENESYS) AS IS WITHOUT ANY WARRANTY OF ANY KIND. GENESYS HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS, REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).
Copyright &copy; 20072008 Genesys Telecommunications Laboratories, Inc. All rights reserved.
=====================================================================*/
package agent.interaction.samples;

import java.awt.event.ActionEvent;
import java.util.LinkedList;

import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;


import com.genesyslab.ail.ChatMessage;
import com.genesyslab.ail.ChatParty; 

import com.genesyslab.ail.CoBrowseURL;
import com.genesyslab.ail.Interaction;
import com.genesyslab.ail.InteractionChat;
import com.genesyslab.ail.InteractionCoBrowse;
import com.genesyslab.ail.Media;
import com.genesyslab.ail.MediaType;
import com.genesyslab.ail.event.InteractionChatEvent;
import com.genesyslab.ail.event.InteractionChatListener;
import com.genesyslab.ail.event.InteractionEvent;
import com.genesyslab.ail.exception.RequestFailedException;

/**
 * Manages a chat session. This example lets you participate in a chat session by managing a chat interaction.
 * <p>A check box lets you activate CoBrowse. If CoBrowse is active, the example adds URLs posted in a chat message to a CoBrowse interaction. 
 *  
 */
public class SimpleChatInteraction extends SimplePlace implements InteractionChatListener {

	/** Interaction for the chat interaction (if any) handled by this example. */
	InteractionChat sampleChatIxn;
	InteractionCoBrowse sampleCoBrowseIxn;
	JButton joinButton;
	JButton doneButton;
	JButton quitButton;
	JButton sendButton;
	JCheckBox coBrowseCheckBox;
	JFrame coBrowseWindow;
	
	
	JTextPane chatSessionTextPane;
	JTextArea chatMsgTextArea;
	
	public boolean sessionDisplayed = false;

	
	/**
	 * @param windowTitle
	 */
	public SimpleChatInteraction(String windowTitle) {
		super(windowTitle);
	}

	// main method
	public static void main(String[] args) {
		//Schedule a job for the event-dispatching thread:
		//creating and showing this application's GUI.
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				SimpleChatInteraction application = new SimpleChatInteraction(
				"Agent Interaction (Java API): Simple Chat Interaction");
			}
		});
	}
	/**
	 * Tells the AgentInteractionGui class which example has called
	 * the GUI, so that it can determine which widgets will be enabled when the
	 * GUI is created.
	 */
	public void setSampleType() {
		sampleType = "SimpleChatInteraction";
		mediaList = new LinkedList();
        // Add the media types used by these examples
       	mediaList.add("chat");
       	//deactivate login on voice media
       voice = false;
	}
	/**
	 * Links widgets (user interface
	 * components) to API functionality and registers a listener for
	 * events on the Place the agent has logged in to.
	 * <br/><br/>
	 * The linked widgets for Simple Email are buttons for processing
	 * an inbound email and the reply to this email.
	 * These buttons correspond to the following actions:<ul>
	 * <li>Join</li>
	 * <li>Send</li>
	 * <li>Quit</Sli>
	 * <li>Mark done</li>
	 * </ul>
	 * @see SimplePlace#linkWidgetsToGui()
	 */
	public void linkWidgetsToGui() {
		super.linkWidgetsToGui();

		// Add a join button for joining the chat session
		joinButton = agentInteractionGui.joinChatInteractionButton;
		joinButton.setAction(new AbstractAction("Join") {
			public void actionPerformed(ActionEvent actionEvent) {
				try {
					sampleChatIxn.answerCall(null);					

				} catch (Exception exception) {
					agentInteractionGui.writeLogMessage(exception.getMessage(),"ErrorEvent");
				}
			}
		});

	
		// Add a quit button for the chat session
		quitButton = agentInteractionGui.quitChatInteractionButton;
		quitButton.setAction(new AbstractAction("Quit") {
			public void actionPerformed(ActionEvent actionEvent) {
				try {
					sampleChatIxn.releaseCall(null);
				} catch (Exception exception) {
					agentInteractionGui.writeLogMessage(exception.getMessage(),"ErrorEvent");
				}
			}
		});

		// Add a done button for the chat session
		doneButton = agentInteractionGui.doneChatInteractionButton;
		doneButton.setAction(new AbstractAction("Done") {
			public void actionPerformed(ActionEvent actionEvent) {
				try {
					sampleChatIxn.markDone();
				} catch (Exception exception) {
					agentInteractionGui.writeLogMessage(exception.getMessage(),"ErrorEvent");
				}
			}
		});
		
		// Add a send button for the chat session
		sendButton = agentInteractionGui.sendChatMsgButton;
		sendButton.setAction(new AbstractAction("Send") {
			public void actionPerformed(ActionEvent actionEvent) {
				try {
					String msg = chatMsgTextArea.getText();
					sampleChatIxn.sendMessage(msg);
					chatMsgTextArea.setText("");
				} catch (Exception exception) {
					agentInteractionGui.writeLogMessage(exception.getMessage(),"ErrorEvent");
				}
			}
		});

		// Add a CoBrowse CheckBox
		coBrowseCheckBox = agentInteractionGui.coBrowseCheckBox;
		coBrowseCheckBox.setAction(new AbstractAction("CoBrowse") {
			public void actionPerformed(ActionEvent actionEvent) {
				startCoBrowse();
			}
		});
		
		joinButton.setEnabled(false);
		quitButton.setEnabled(false);
		sendButton.setEnabled(false);
		doneButton.setEnabled(false);
		coBrowseCheckBox.setEnabled(false);
		chatMsgTextArea = agentInteractionGui.chatMsgTextArea;
		chatSessionTextPane = agentInteractionGui.chatSessionTextPane;
			
	}
	
	public void setPlaceWidgetState()
    {
    	if(sampleChat != null)
    	{
    		loginButton.setEnabled(sampleChat.isPossible(Media.Action.LOGIN));
    		logoutButton.setEnabled(sampleChat.isPossible(Media.Action.LOGOUT));
    		readyButton.setEnabled(sampleChat.isPossible(Media.Action.READY));
    		notReadyButton.setEnabled(sampleChat.isPossible(Media.Action.NOTREADY));
    		afterCallWorkButton.setEnabled(false);

    		//Set status to the table.
    		agentInteractionGui.setPlaceStatus(sampleChat.getName(),sampleChat.getStatus().toString());

    	} 	else {

    		loginButton.setEnabled(true);
    		logoutButton.setEnabled(false);
    		readyButton.setEnabled(false);
    		notReadyButton.setEnabled(false);
    		afterCallWorkButton.setEnabled(false);
    		
    		agentInteractionGui.setPlaceStatus("chat","logged out");
    		
    	}
    }
		
	private void startCoBrowse()
	{
		
		if(sampleChatIxn == null)
		{
			return;
		}
		if (coBrowseCheckBox.isSelected())
		{
			// The checkbox is now selected				
			if(sampleCoBrowseIxn == null)
			{
			
               try {						
				//1. Create a new InteractionCoBrowse
				sampleCoBrowseIxn = (InteractionCoBrowse) sampleAgent.createInteraction(MediaType.COBROWSE, sampleChatIxn, sampleChatIxn.getQueue());
				
			   } catch (RequestFailedException e) {
				agentInteractionGui.writeLogMessage(e.getMessage(),"ErrorEvent on CoBrowse creation");
			   }
			}
			CoBrowseURL[] co_urls = sampleCoBrowseIxn.getURLs();
			String[] urls = new String[co_urls.length];
			for(int i= 0; i<co_urls.length; i++)
			{
				urls[i]= co_urls[i].getURL();						
			}
			//2. Create a CoBrowse Dialog Box
			agentInteractionGui.createCoBrowseWindow("CoBrowse is active", urls);
			
			
        } else {
        	
        	if(agentInteractionGui.coBrowseWindow != null)
        	{
        		// 	The checkbox is now deselected
        		agentInteractionGui.coBrowseWindow.dispose();
        		agentInteractionGui.coBrowseWindow = null;
        		agentInteractionGui.coBmodel = null;
        	}
        }

	}
	
    public void setInteractionWidgetState() {
    	///super.setInteractionWidgetState();
    	if (sampleChatIxn != null) {
			joinButton.setEnabled(sampleChatIxn
					.isPossible(InteractionChat.Action.ANSWER_CALL));
			quitButton.setEnabled(sampleChatIxn
					.isPossible(InteractionChat.Action.RELEASE_CALL));
			sendButton.setEnabled((sampleChatIxn.getStatus()== Interaction.Status.TALKING));
			coBrowseCheckBox.setEnabled((sampleChatIxn.getStatus()== Interaction.Status.TALKING));
			doneButton.setEnabled(sampleChatIxn
					.isPossible(InteractionChat.Action.MARK_DONE));
			chatMsgTextArea.setEditable(true);
			chatMsgTextArea.setEnabled(true);

		} else
		{
			joinButton.setEnabled(false);
			quitButton.setEnabled(false);
			sendButton.setEnabled(false);
			doneButton.setEnabled(false);
			chatSessionTextPane.setText("No chat session in process.");       			
			chatMsgTextArea.setText("Enter your message here.");
			chatMsgTextArea.setEditable(false);
			coBrowseCheckBox.setEnabled(false);
		}
    
    }
    public void displayInteractionChatMessage(ChatParty party, String message) 
    {
    	if(party.getType() == ChatParty.Type.AGENT)
    	{
    		agentInteractionGui.writeChatMessage(party.getNickName(), message, AgentInteractionGui.AGENT_STYLE);
    	}else if(party.getType() == ChatParty.Type.CLIENT)
    	{
    		agentInteractionGui.writeChatMessage(party.getNickName(), message, AgentInteractionGui.CUSTO_STYLE);
    	}else{
    		agentInteractionGui.writeChatMessage(party.getNickName(), message, AgentInteractionGui.DEFAULT_STYLE);
    	}
    	
    }
    
    public void checkURLs(String text)
    {
    	String[] test = text.split("http:*");
    	for(int i=1; i<test.length; i++)
    	{
    		//if the string contains a url
    		if(test[i].indexOf("//")>=0)
    		{
    			//removing extra characters
    			if(test[i].indexOf(" ")>=0)
    			{
    				String[] splitHTTP = test[i].split(" ");
    				test[i]=splitHTTP[0];
    			}
    			test[i] = "http:"+test[i];
    			agentInteractionGui.coBmodel.addElement(test[i]);
    			try {
    			sampleCoBrowseIxn.addURLs(new String[]{test[i]});
    			} catch (RequestFailedException e) {

    				agentInteractionGui.writeLogMessage(e.getMessage(),"ErrorEvent");
    			}
    		}
    	}
    	try {
//			sampleCoBrowseIxn.addURLs(test);
			sampleCoBrowseIxn.save();
		} catch (RequestFailedException e) {

			agentInteractionGui.writeLogMessage(e.getMessage(),"ErrorEvent");
		}
    }
	
	public void handleInteractionEvent(InteractionEvent event)
	{
		super.handleInteractionEvent(event);
		ChatSessionInteractionEventThread p = new ChatSessionInteractionEventThread(this,event);
		p.start();
	}
	
	/* (non-Javadoc)
	 * @see com.genesyslab.ail.event.InteractionChatListener#handleInteractionChatEvent(com.genesyslab.ail.event.InteractionChatEvent)
	 */
	public void handleInteractionChatEvent(InteractionChatEvent chatEvent) {
		InteractionChatEventThread p = new InteractionChatEventThread(this,chatEvent);
		p.start();
		
	}
	
	class ChatSessionInteractionEventThread extends Thread
	{
		InteractionEvent event;
		SimpleChatInteraction session;
		
		public ChatSessionInteractionEventThread(SimpleChatInteraction _session,InteractionEvent _event)
		{
			event=_event;
			session=_session;
			
		}
		
		public void run()
		{
			try {
				// 1. test whether or not this is a new interaction
				// to process.
				// If sampleChat is null, the event may notify
				// a new chat session.
				if (sampleChatIxn == null
						&& event.getSource() instanceof InteractionChat
						&& event.getStatus() == Interaction.Status.RINGING) {

					sampleChatIxn = (InteractionChat) event.getSource();
					chatSessionTextPane.setText("");
					agentInteractionGui.writeChatMessage(" ", "Chat session is ringing. Click the \'Join\' button to join the chat session.", AgentInteractionGui.ELSE_STYLE);
					//);  

				}

				//2. The event involves the chat session being processed
				if(sampleChatIxn  != null && event.getSource().getId() == sampleChatIxn.getId())
				{
					//	The inbound email is in talking status, and can be displayed
					if (event.getStatus() == Interaction.Status.TALKING)
					{
						if(!sessionDisplayed)
						{
							chatSessionTextPane.setText("");
							ChatMessage[] allMsg = sampleChatIxn.getMessages();
						
							for(int i=0; i<allMsg.length; i++)
							{
								displayInteractionChatMessage(allMsg[i].getParty(), allMsg[i].getText());
							}
							sessionDisplayed = true;
							sampleChatIxn.addChatListener(session,	false);
							startCoBrowse();
						}
					
					}
					// The interaction is processed, the example no longer needs to handle it
					else if (event.getStatus() == Interaction.Status.IDLE )
					{					
						if(sampleChatIxn.isDone())
						{							
							sampleChatIxn.removeChatListener(session);
							sampleChatIxn  = null;
							sessionDisplayed = false;
						}
						
						if(sampleCoBrowseIxn != null)
						{
							sampleCoBrowseIxn.save();
							//sampleCoBrowse.releaseCall(null);
							sampleCoBrowseIxn.markDone();
							sampleCoBrowseIxn = null;
							
							if(agentInteractionGui.coBrowseWindow != null)
				        	{
				        		// 	The checkbox is now deselected
				        		agentInteractionGui.coBrowseWindow.dispose();
				        		agentInteractionGui.coBrowseWindow = null;
				        		agentInteractionGui.coBmodel = null;
				        		coBrowseCheckBox.setSelected(false);
				        	}
						}
					}
					setInteractionWidgetState();
				}
			
			} catch (RequestFailedException exception) {
				agentInteractionGui.writeLogMessage(exception.getMessage(),"ErrorEvent");
			}

		}
	}

	

	class InteractionChatEventThread extends Thread
	{
		InteractionChatEvent chatEvent;
		public InteractionChatEventThread(SimpleChatInteraction chatSession, InteractionChatEvent _chatEvent)
		{
			chatEvent=_chatEvent;
			
		}
		public void run()
		{
			if(chatEvent.getEventType() == InteractionChatEvent.Type.MESSAGE_RECEIVED)
			{
				displayInteractionChatMessage(chatEvent.getParty(), chatEvent.getText());
				if(sampleCoBrowseIxn != null)
				{
					checkURLs(chatEvent.getText());
				}
			    
			}else if(chatEvent.getEventType() == InteractionChatEvent.Type.DISCONNECTED)
			{
				agentInteractionGui.writeChatMessage(" ", "You are disconnected !", AgentInteractionGui.ELSE_STYLE);
				
			}else if(chatEvent.getEventType() == InteractionChatEvent.Type.USER_JOINED)
			{
				agentInteractionGui.writeChatMessage(chatEvent.getDate().toGMTString(), chatEvent.getParty().getNickName() + " joined", AgentInteractionGui.ELSE_STYLE);
				
			}else if(chatEvent.getEventType() == InteractionChatEvent.Type.USER_LEFT)
			{
				agentInteractionGui.writeChatMessage(chatEvent.getDate().toGMTString(), chatEvent.getParty().getNickName() + " left", AgentInteractionGui.ELSE_STYLE);
				
			} else if(chatEvent.getEventType() == InteractionChatEvent.Type.USER_REENTER)
			{
				agentInteractionGui.writeChatMessage(chatEvent.getDate().toGMTString(), chatEvent.getParty().getNickName() + " reentered", AgentInteractionGui.ELSE_STYLE);
				
			}
			
			
		}
		
	}
}

