/*=====================================================================
Any authorized distribution of any copy of this code (including any related documentation) must reproduce the following restrictions, disclaimer and copyright notice:
The Genesys name, trademarks and/or logo(s) of Genesys shall not be used to name (even as a part of another name), endorse and/or promote products derived from this code without prior written permission from Genesys Telecommunications Laboratories, Inc.
The use, copy, and/or distribution of this code is subject to the terms of the Genesys Developer License Agreement.  This code shall not be used, copied, and/or distributed under any other license agreement.
THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES, INC. (GENESYS) AS IS WITHOUT ANY WARRANTY OF ANY KIND. GENESYS HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS, REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).
Copyright &copy; 20072008 Genesys Telecommunications Laboratories, Inc. All rights reserved.
=====================================================================*/
package agent.interaction.samples;

import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import com.genesyslab.ail.AilFactory;
import com.genesyslab.ail.ContactManager;
import com.genesyslab.ail.applicationblocks.connector.Connector;

/**
 * Connects to the Genesys servers. It uses the Connector Application Block
 * class to do three main things:
 *
 * <ol>
 * <li>Connect to servers.</li>
 *
 * <li>Set a default file for logging.</li>
 *
 * <li>Get an interface to the internal AilFactory object.</li>
 *
 * </ol>
 *
 * The internal AilFactory object is itself available as an interface through
 * which you access the core Agent Interaction Layer factory object &mdash; the
 * AilFactory instantiates internal classes and makes them available through
 * interfaces. You do not instantiate objects directly in your code.<br/><br/>
 *
 * As mentioned, you do not instantiate other AIL objects directly by using a
 * constructor call. However, the AIL library provides a reference system of
 * unique object IDs that are standard String objects. This allows your
 * application to manipulate each object by passing its unique ID as a parameter
 * to the methods of the AilFactory interface. <br/><br/>
 *
 * The AilFactory object is a Singleton. This means that only one instance of
 * the AilFactory object exists at runtime. All AilFactory interfaces obtained
 * through the AilLoader refer to this same object.
 */
public class SimpleConnector implements WindowListener {
	
	Connector connector;
	String defaultLogFilePath="./";
	String defaultLogFileName = "SimpleLogs.txt";

	/** Factory to be used by further examples. */
	public AilFactory ailFactory;
	/** Contact Manager to be used by further examples. */
	public ContactManager contactManager; 
	/** Data container to be used by further examples. */
    public AgentInteractionData agentInteractionData;

    /**
     * Uses data from an instance of AgentInteractionData to connect to an
     * AilLoader. After setting logging options, the AilLoader gets the static
     * AilFactory and ContactManager. <br/><br/>
     *
     * At this point, the constructor sets up the data for the agent, place
     * and DN used in the Interaction SDK Java code examples.
     */
    public SimpleConnector() {

        // Make configuration layer data available to the examples
        agentInteractionData = new AgentInteractionData();
        connector = new Connector();
        
        try {
        	// Connect to the Agent Interaction Layer
        	connector.init(agentInteractionData.getApplicationParameters());
        
        	// Set a log file
        	connector.setLog(defaultLogFileName,defaultLogFilePath);
        
        	 // Get the AIL Factory and start logging service status
            ailFactory = connector.getAIL();

            // Initialize ContactManager (for the Contacts example)
            
            contactManager = ailFactory.getContactManager();
            System.out.println("Example is connected.");
            
        } catch (Exception exception) {
            exception.printStackTrace();
        }
    }



    // Window listener methods
    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    /**
     * When you are finished using the Agent Interaction Layer, you should
     * release the AilFactory: this method makes sure you release it.
     */
    public void windowClosing(WindowEvent windowEvent) {

        try {
            connector.release();
            System.out.println("Factory is released!");
            windowEvent.getWindow().dispose();
            System.exit(0);
        } catch (Exception exception) {
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

}