/*=====================================================================
Any authorized distribution of any copy of this code (including any related documentation) must reproduce the following restrictions, disclaimer and copyright notice:
The Genesys name, trademarks and/or logo(s) of Genesys shall not be used to name (even as a part of another name), endorse and/or promote products derived from this code without prior written permission from Genesys Telecommunications Laboratories, Inc.
The use, copy, and/or distribution of this code is subject to the terms of the Genesys Developer License Agreement.  This code shall not be used, copied, and/or distributed under any other license agreement.
THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES, INC. (GENESYS) AS IS WITHOUT ANY WARRANTY OF ANY KIND. GENESYS HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS, REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).
Copyright &copy; 20072008 Genesys Telecommunications Laboratories, Inc. All rights reserved.
=====================================================================*/
package agent.interaction.samples;

import java.awt.event.ActionEvent;
import java.util.LinkedList;

import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

import com.genesyslab.ail.Interaction;
import com.genesyslab.ail.InteractionOpenMedia;
import com.genesyslab.ail.Media;
import com.genesyslab.ail.applicationblocks.openmedia.simplehandling.SimpleOpenMediaHandler;
import com.genesyslab.ail.event.InteractionEvent;
import com.genesyslab.ail.exception.RequestFailedException;

/**
 * This example uses a GUI application to show how to receive an Open Media
 * interaction. <br/><br/>
 *
 * To process the interaction, this example displays a few information
 * about the example and provides you with a button to mark it done.
 *
 * One PlaceListener is registered, which receives InteractionEvents.<br/><br/>
 * @version 7.5.001.02
 */
public class SimpleOpenMediaInteraction extends SimplePlace {

    InteractionOpenMedia sampleOpenMediaIxn;
    SimpleOpenMediaHandler sampleHandler;
    
    JButton acceptOpenMediaInteractionButton;
    JButton openMediaInteractionDoneButton;

    JLabel interactionDnis;
    JLabel interactionAni;
    JLabel interactionSubject;
    JLabel interactionThirdParty;

    JTextArea openMediaTextArea;

    // main method
    public static void main(String[] args) {
        //Schedule a job for the event-dispatching thread:
        //creating and showing this application's GUI.
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                SimpleOpenMediaInteraction application = new SimpleOpenMediaInteraction(
                        "Agent Interaction (Java): Simple Open Media Interaction");
            }
        });
    }

    /**
     * Creates an instance of SimpleOpenMediaInteraction.<br/>
     *
     * The super constructor connects to the Agent Interaction Layer.
     *
     * After connecting, it sets up an agent, place, media, and DN for use by
     * the examples. Then it creates the GUI, links the GUI components (widgets)
     * to API functionality, and starts the application.
     *
     * @param windowTitle
     *            The title of the GUI window for this example.
     */
    public SimpleOpenMediaInteraction(String windowTitle) {
        super(windowTitle);
        sampleHandler = new SimpleOpenMediaHandler(this.sampleAgent);
    }
    /**
     * Tells the AgentInteractionGui class which example has called
     * the GUI, so that it can determine which widgets will be enabled when the
     * GUI is created.
     */
    public void setSampleType() {
        sampleType = "SimpleOpenMediaInteraction";
        mediaList = new LinkedList();
        mediaList.add(workitem); // In other words, "Open Media"
    	voice = false;
    }
    /**
     * Links widgets (user interface
     * components) to API functionality and registers a listener for
     * events on the Place the agent has logged in to.
     * <br/><br/>
     * The linked widgets for Open Media are two buttons (
     * one for accepting to process the interaction,
     * one for marking done the interaction),
     * and a text area which displays interaction information
     * (this corresponds here to processing the interaction).
     *
     * @see SimplePlace#linkWidgetsToGui()
     */
    public void linkWidgetsToGui() {
        super.linkWidgetsToGui();

        // Add an Accept (Open Media interaction) button
        acceptOpenMediaInteractionButton = agentInteractionGui.acceptOpenMediaInteractionButton;
        acceptOpenMediaInteractionButton
                .setAction(new AbstractAction("Accept") {
                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            sampleHandler.accept(sampleOpenMediaIxn);
                        } catch (RequestFailedException exception) {
                        	agentInteractionGui.writeLogMessage(exception.getMessage()+ " cause: "+exception.getCause(),
                        			"errorEvent");
                        }
                    }
                });

        // Add a Done (Open Media Interaction) button
        openMediaInteractionDoneButton = agentInteractionGui.openMediaInteractionDoneButton;
        openMediaInteractionDoneButton.setAction(new AbstractAction("Done") {
            public void actionPerformed(ActionEvent actionEvent) {
            	try {
                    sampleHandler.markDone(sampleOpenMediaIxn);
                } catch (RequestFailedException exception) {
                	agentInteractionGui.writeLogMessage(exception.getMessage()+ " cause: "+exception.getCause(),
                			"errorEvent");
                }
            }
        });

        openMediaTextArea = agentInteractionGui.openMediaTextArea;

        interactionAni = agentInteractionGui.interactionAniLabel;
        interactionSubject = agentInteractionGui.interactionSubjectLabel;
        interactionThirdParty = agentInteractionGui.interactionPartiesLabel;

    }
    public void 	setPlaceWidgetState()
    {
    	if(sampleOpenMedia != null)
    	{
    		loginButton.setEnabled(sampleOpenMedia.isPossible(Media.Action.LOGIN));
    		logoutButton.setEnabled(sampleOpenMedia.isPossible(Media.Action.LOGOUT));
    		readyButton.setEnabled(sampleOpenMedia.isPossible(Media.Action.READY));
    		notReadyButton.setEnabled(sampleOpenMedia.isPossible(Media.Action.NOTREADY));
    		afterCallWorkButton.setEnabled(false);

    		//Set status to the table.
    		agentInteractionGui.setPlaceStatus(sampleOpenMedia.getName(),sampleOpenMedia.getStatus().toString());

    	} 	else {

    		loginButton.setEnabled(true);
    		logoutButton.setEnabled(false);
    		readyButton.setEnabled(false);
    		notReadyButton.setEnabled(false);
    		afterCallWorkButton.setEnabled(false);
    		
    		agentInteractionGui.setPlaceStatus(workitem,"logged out");
    		
    	}
    }
    /**
     * This class receives InteractionEvents, which are handled by the
     * handleInteractionEvent() method. This class also has widgets whose state
     * must be set when it receives these events.<br/><br/>
     *
     * This method enables or disables the specified widgets, which are normally
     * just buttons and radio buttons, but may include other widgets. To do
     * this, it use the isPossible() method of the Possible interface.
     *
     * The isPossible() method returns either true or false, depending on
     * whether a particular action is possible. This boolean value is used to
     * determine whether the widget will be enabled.
     */
    public void setInteractionWidgetState() {
    	if (sampleOpenMediaIxn instanceof InteractionOpenMedia) {
    		acceptOpenMediaInteractionButton.setEnabled(sampleOpenMediaIxn
    				.isPossible(InteractionOpenMedia.Action.ANSWER_CALL));
    		openMediaInteractionDoneButton.setEnabled(sampleOpenMediaIxn
    				.isPossible(InteractionOpenMedia.Action.MARK_DONE));
    	} else {
    		acceptOpenMediaInteractionButton.setEnabled(false);
    		openMediaInteractionDoneButton.setEnabled(false);
    		openMediaTextArea.setText("To accept an Open Media interaction, click the Accept button.");

    	}
    }

    /**
     * Receives InteractionEvents, which report changes to the status or data
     * of an interaction. If you implement the PlaceListener interface, you must
     * implement this method. <br/><br/>
     *
     * The SimpleOpenMediaInteraction code example uses this method to log these
     * InteractionEvents as they occur and to set the state of the widgets
     * used by the SimpleOpenMediaInteraction example.
     */
    public void handleInteractionEvent(InteractionEvent event) {

    	/*OpenMediaInteractionEventThread p = new OpenMediaInteractionEventThread(event, this);
    	p.start(); */
    	super.handleInteractionEvent(event);
    	
    	OpenMediaInteractionEventThread p = new OpenMediaInteractionEventThread(event, this);
    	p.start(); 
    	
    }
    
    
    public class OpenMediaInteractionEventThread extends Thread
	{
		InteractionEvent event;
		SimplePlace simplePlaceExample;
		
		public OpenMediaInteractionEventThread(InteractionEvent _event, SimplePlace _simplePlace) {
            event = _event;
            simplePlaceExample = _simplePlace;
        }
		
		public void run()
		{
			
			try {
	    		//Checking that the event reports a change on an open media interaction
	    		if(event.getSource() instanceof InteractionOpenMedia)
	    		{
	    			// if sampleInteraction is null, this is a new interaction
	    			if (sampleOpenMediaIxn == null && (event.getStatus() == Interaction.Status.RINGING)) {
	    				sampleOpenMediaIxn = (InteractionOpenMedia) event.getSource();
	    			}
	    			// if the event involves the interaction to process,
	    			// it tests the interaction status

	    			if (sampleOpenMediaIxn != null
	    					&& event.getInteraction().getId() == sampleOpenMediaIxn.getId())
	    			{
	    				// When the open media interaction is in talking status,
	    				// it means that the agent or place is owner of the interaction
	    				// this is when you can process this interaction.
	    				if (event.getStatus() == Interaction.Status.TALKING) {

	    					/// You can process the interaction.
	    					/// In this example, processing the interaction corresponds to
	    					/// displaying the text of the open media interaction

	    					sampleOpenMediaIxn = (InteractionOpenMedia) event.getSource();
	    					// You can now access the Open Media interaction's content.
	    					String someText = "Media type: "
	    						+ sampleOpenMediaIxn.getOpenMediaType()
								+ "\nInteraction type: " + sampleOpenMediaIxn.getOpenInteractionType()
								+ "\nSubject: " + sampleOpenMediaIxn.getSubject()
								+ "\nText: " + sampleOpenMediaIxn.getText()
								+ "\nDate: " + sampleOpenMediaIxn.getDateCreated().toGMTString();

	    					openMediaTextArea.setText(someText);
	    				}
	    				// If the interaction is idle, remove it.
	    				if( sampleOpenMediaIxn!=null && event.getStatus() == Interaction.Status.IDLE
	    						&& sampleOpenMediaIxn.isDone())
	    					sampleOpenMediaIxn = null;

	    				//Updating the widgets
	    				setInteractionWidgetState();
	    			}
	    		}
	    	} catch (Exception exception) {
	    		agentInteractionGui.writeLogMessage(exception.getMessage()+ " cause: "+exception.getCause(),
				"errorEvent");
	    	}
			
		}
	}
	
}