/*=====================================================================
Any authorized distribution of any copy of this code (including any related documentation) must reproduce the following restrictions, disclaimer and copyright notice:
The Genesys name, trademarks and/or logo(s) of Genesys shall not be used to name (even as a part of another name), endorse and/or promote products derived from this code without prior written permission from Genesys Telecommunications Laboratories, Inc.
The use, copy, and/or distribution of this code is subject to the terms of the Genesys Developer License Agreement.  This code shall not be used, copied, and/or distributed under any other license agreement.

THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES, INC. (GENESYS) AS IS WITHOUT ANY WARRANTY OF ANY KIND. GENESYS HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS, REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).
Copyright &copy; 2007-2008 Genesys Telecommunications Laboratories, Inc. All rights reserved.
=====================================================================*/

package agent.interaction.samples.outbound;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import agent.interaction.samples.AgentInteractionData;
import agent.interaction.samples.SimpleConnector;
import com.genesyslab.ail.Agent;
import com.genesyslab.ail.Dn;
import com.genesyslab.ail.InteractionVoice;
import com.genesyslab.ail.OutboundService;
import com.genesyslab.ail.Place;
import com.genesyslab.ail.event.CampaignEvent;
import com.genesyslab.ail.event.CampaignListener;
import com.genesyslab.ail.event.DnEvent;
import com.genesyslab.ail.event.InteractionEvent;
import com.genesyslab.ail.event.PlaceEvent;
import com.genesyslab.ail.event.PlaceListener;

/**
 * Main class of the Agent Outbound code example.<br>
 * This class implements the PlaceListener and CampaignListener interfaces to receive the status, interaction, and outbound events that occurs on a DN.
 * It does not process events but use adapters in this purpose. At startup, it creates the following instances:
 * <ul>
 * <li><code>AgentOutboundGui:</code> Provides all the GUI, including the widgets management.</li>
 * <li><code>PlaceAdapterForOutbound:</code> Manages status events and place actions (login, logout, ready, not ready) that only deal with a DN (no other media than voice is logged in).</li>
 * <li><code>VoiceInteractionAdapterForOutbound:</code> Manages voice interactions and related outbound records. </li>
 * <li><code>CampaignAdapter:</code></li> Manages campaign data.</ul>
 *
 */
public class AgentOutboundExample implements PlaceListener, CampaignListener {

	PlaceAdapterForOutbound placeForOutbound;
	InteractionVoice selectedInteraction;
	VoiceInteractionAdapterForOutbound selectedInteractionHandler ; 
	CampaignAdapter campaignAdapter;
	OutboundService outboundService;
	AgentOutboundGui outboundGui;
	AgentInteractionData agentInteractionData;
	
	
	
	/**
     * Creates an instance of AgentOutboundExample.
     *
     * The Connector class connects to the Agent Interaction Layer using the
     * AilLoader and AilFactory classes.<br>
     *
     * The AgentInteractionData class supplies data from the Configuration Layer
     * for things like host, port, place, DN and agent attributes.<br>
     *
     * After connecting, this method sets up an agent, place and DN for use by
     * the examples. Then it creates the GUI, creates the adapters that links the GUI components (widgets)
     * to API functionality, and starts the application.<br>
     * 
     * Finally, it registers listeners to handle events.
     *
     * @param windowTitle
     *            The title of the GUI window for this example.
     */
    public AgentOutboundExample(String windowTitle) {

      // Connect to AIL
    	SimpleConnector connector = new SimpleConnector();
        
        // Make configuration layer data available to the examples
        AgentInteractionData agentInteractionData = connector.agentInteractionData;

       // Set up an agent, place and DN for use by the examples
        Agent sampleAgent = (Agent) connector.ailFactory
                .getPerson(agentInteractionData.getAgent1UserName());
        Place samplePlace = connector.ailFactory.getPlace(agentInteractionData
                .getPlace1());
        
       OutboundService outboundService = samplePlace.getOutboundService();
     
        Dn sampleDn = connector.ailFactory.getDn(agentInteractionData.getDn1());      
        
        
        // Create the GUI
        outboundGui = new AgentOutboundGui(windowTitle);
        
        // Create the Place manager for login actions
        placeForOutbound = new PlaceAdapterForOutbound(samplePlace, sampleDn, agentInteractionData,  outboundGui);
        
        // Create the interaction handler to manage the selected interaction in the table.
        selectedInteractionHandler = new VoiceInteractionAdapterForOutbound(samplePlace, sampleDn, outboundService, agentInteractionData,  outboundGui);
        
        // create the adapter for handling campaign events
        campaignAdapter = new CampaignAdapter(samplePlace, sampleDn, outboundService, outboundGui);
    
    

        // Start the application
        outboundGui.mainGuiWindow
                .setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
        outboundGui.mainGuiWindow.addWindowListener(connector);
        outboundGui.mainGuiWindow.pack();
        outboundGui.mainGuiWindow.setVisible(true);
        
        
        samplePlace.addPlaceListener(this);
        outboundService.addListener(this);
        
    }

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		 //Schedule a job for the event-dispatching thread:
        //creating and showing this application's GUI.
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
            	AgentOutboundExample application = new AgentOutboundExample(
                        "Agent Interaction (Java): AgentOutboundExample");
            }
        });

	}

	/**
	 * Not implemented.
	 */
	public void dnAdded(String arg0) {
		// TODO Auto-generated method stub
		
	}
	/**
	 * Not implemented.
	 */
	public void dnRemoved(String arg0) {
		// TODO Auto-generated method stub
		
	}

	/**
	 * Manages <code>PlaceEventOutboundChainInfo</code> events. 
	 */
	public void handlePlaceEvent(PlaceEvent arg0) {
		selectedInteractionHandler.handlePlaceEvent(arg0);
		
	}
	/**
	 * Not implemented.
	 */
	public void idModified(String arg0) {
		// TODO Auto-generated method stub
		
	}
	/**
	 * Not implemented.
	 */
	public void deleted() {
		// TODO Auto-generated method stub
		
	}

	/**
	 * Handles <code>DnEvent</code> events in the <code>PlaceAdapterForOutbound</code> instance.
	 */
	public void handleDnEvent(DnEvent event) {
		placeForOutbound.handleDnEvent(event);
		
	}
	/**
	 * Not implemented.
	 */
	public void contactChanged(InteractionEvent arg0) {
		// TODO Auto-generated method stub
		
	}
	/**
	 * Not implemented.
	 */
	public void handleInteractionEvent(InteractionEvent event) {
		selectedInteractionHandler.handleInteractionEvent(event);
		
	}

	/**
	 * Handles <code>CampaignEvent</code> events in the <code>CampaignAdapter</code> instance.
	 */
	public void handleCampaignEvent(CampaignEvent event) {
		campaignAdapter.handleCampaignEvent(event);
	}

	
}
