/*=====================================================================
Any authorized distribution of any copy of this code (including any related documentation) must reproduce the following restrictions, disclaimer and copyright notice:
The Genesys name, trademarks and/or logo(s) of Genesys shall not be used to name (even as a part of another name), endorse and/or promote products derived from this code without prior written permission from Genesys Telecommunications Laboratories, Inc.
The use, copy, and/or distribution of this code is subject to the terms of the Genesys Developer License Agreement.  This code shall not be used, copied, and/or distributed under any other license agreement.
THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES, INC. (GENESYS) AS IS WITHOUT ANY WARRANTY OF ANY KIND. GENESYS HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS, REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).
Copyright &copy; 2007-2008 Genesys Telecommunications Laboratories, Inc. All rights reserved.
=====================================================================*/

package media.sdk.java.examples;

/**
* Launches the simple media server in custom mode. The custom media server periodically reads the contents of a directory in parameters.
* For each file found in the directory, this server attaches the file to a new
* interaction and submits it to Interaction Server.
* <p>To use the custom extension of this server, you must define
* an ESP strategy in the Interaction Routing Designer and create an External Service.
* In the External Service Property text box, specify the custom extension <code>media.sdk.java.examples.SimpleCustomExtension</code>
* and the method to call <code>doProcessRequest</code>.
* <p>When the interaction goes through the strategy associated with the external service,
* the custom media server gets an ESP request and calls the SimpleCustomExtension.doProcessRequest()
* method.
* <p>For details about arguments passed to the main() method, see {@link StartMedia}.
*/
public class StartCustomMedia {

	public static void main(String[] args) {
		try{
			SimpleMediaServer p =
				new SimpleMediaServer(args[0],args[1],args[2],args[3],args[4],args[5], true);
			Thread myThread = new Thread( p );
			myThread.start();

			}catch(Exception _e)
			{
				_e.printStackTrace();
			}
	}
}
