/*=====================================================================
Any authorized distribution of any copy of this code (including any related documentation) must reproduce the following restrictions, disclaimer and copyright notice:
The Genesys name, trademarks and/or logo(s) of Genesys shall not be used to name (even as a part of another name), endorse and/or promote products derived from this code without prior written permission from Genesys Telecommunications Laboratories, Inc.
The use, copy, and/or distribution of this code is subject to the terms of the Genesys Developer License Agreement.  This code shall not be used, copied, and/or distributed under any other license agreement.
THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES, INC. (GENESYS) AS IS WITHOUT ANY WARRANTY OF ANY KIND. GENESYS HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS, REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).
Copyright &copy; 2007-2008 Genesys Telecommunications Laboratories, Inc. All rights reserved.
=====================================================================*/


package media.sdk.java.examples;

/**
 * Launches the simple media server. This application reads the contents of a directory specified in parameters.
 * For each file found in the directory, this server:
 * <ul><li>Creates a new interaction.
 * <li>Attached a file to the interaction.
 * <li>Submits an interaction to Interaction Server.
 * <li>Saves the interaction in UCS.
 * </li>
 * </ul>
 * <p>When launching this application, specify the following arguments for interaction creation:
 * <ul>
 * <li>arg0 is the queue name to which media interactions are submitted.
 * <li>arg1 is the media type; possible values are defined in the configuration Layer as "Media Type" attribute values.
 * <li>arg2 is the interaction type for interactions to be submitted; possible values are defined in the Configuration Layer as "Interaction Type" attribute values.
 * <li>arg3 is the interaction subtype for interactions to be submitted; possible values are defined in the Configuration Layer as "Interaction subype" attribute values.
 * <li>arg4 is the source directory containing files to attach to the created interactions.
 * <li>arg5 is the save directory in which to save files whose interaction submission failed.
 * </ul>
 * For instance, consider the following arguments:
 * <br><code>RoutingWorkItem WorkItem Inbound InboundNew ./source/ ./save/</code><br>
 * <br>In this case, created interactions are WorkItem interactions of type Inbound, subtype InboundNew.
 * They are submitted to the queue RoutingWorkItem.
 * These interactions' attached data are obtained from the ./source directory.
 * <p>Note: Each interaction contains a single file as attached data.
 */
public class StartMedia {

	public static void main(String[] args) {
			try{
			SimpleMediaServer p =
				new SimpleMediaServer(args[0],args[1],args[2],args[3],args[4],args[5], false);
			Thread myThread = new Thread( p );
			myThread.start();

			}catch(Exception _e)
			{
				_e.printStackTrace();
			}

	}
}
