/** Any authorized distribution of any copy of this code (including any related documentation) must reproduce the following restrictions, disclaimer and copyright notice:<br>
The Genesys name, trademarks and/or logo(s) of Genesys shall not be used to name (even as a part of another name), endorse and/or promote products derived from this code without prior written permission from Genesys Telecommunications Laboratories, Inc. <br>
The use, copy, and/or distribution of this code is subject to the terms of the Genesys Developer License Agreement.  This code shall not be used, copied, and/or distributed under any other license agreement.    <br>
<br>
THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES, INC. (GENESYS) AS IS WITHOUT ANY WARRANTY OF ANY KIND. GENESYS HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS, REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).<br>
<br>Copyright &copy; 2006 Genesys Telecommunications Laboratories, Inc. All rights reserved.<br>
**/
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Threading;
using com.genesyslab.ail;
using com.genesyslab.ail.ws;
using com.genesyslab.ail.ws.agent;
using com.genesyslab.ail.ws._event;
using com.genesyslab.ail.ws.place;

namespace AgentExample
{
	/// <summary>
	/// AgentStatusForm can log an agent in a place and display DNs and media agent status. v1.4-01/03/05
	/// </summary>
	public class AgentStatusForm : System.Windows.Forms.Form, com.genesyslab.ail.ws._event.INotifyService
	{
		private System.Windows.Forms.Button buttonLogin;
		private System.Windows.Forms.Button buttonLogout;
		private System.Windows.Forms.Button buttonReady;
		private System.Windows.Forms.Button buttonNotReady;
		private System.Windows.Forms.DataGrid dataGrid1;
		private System.ComponentModel.IContainer components;

		private System.Windows.Forms.RichTextBox richTextBoxTrace;
		private System.Windows.Forms.ContextMenu contextMenuPlace;
		private System.Windows.Forms.MenuItem menuItemAgent;
		private System.Windows.Forms.MenuItem menuItemEvents;
		private System.Windows.Forms.MenuItem menuItemEditAgent;
		private System.Windows.Forms.MenuItem menuItemNotif;
		private System.Windows.Forms.MenuItem menuItemPush;
		private System.Windows.Forms.MenuItem menuItemPull;


		private System.Windows.Forms.MainMenu mainMenu;
		private Agent mAgent;
		Thread thEvents;
		public DataTable tStatus;

		/// <summary>
		/// Constructor.
		/// </summary>
		public AgentStatusForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
			// Sets the dock control of the Trace text box
			this.richTextBoxTrace.Dock = System.Windows.Forms.DockStyle.Bottom;
			this.Closed +=new EventHandler(AgentStatusForm_Closed);
			try
			{
				/// Creating Agent and Connection objects for this status form
				mAgent = new Agent();
				mAgent.mConnection = new Connection();

				/// Creating the status table that displays DNs and media status
				this.tStatus = new DataTable("Status");
				DataColumn colName2 = new DataColumn("Name",typeof(string));
				this.tStatus.Columns.Add(colName2);
				tStatus.PrimaryKey = new DataColumn[]{colName2};

				DataColumn colStatus = new DataColumn("Status",typeof(string));
				this.tStatus.Columns.Add(colStatus);
				this.dataGrid1.DataSource = tStatus;

				/// Starting the services
				this.Start();
				this.SetPullMode();

			}
			catch(AilException aile)
			{
				Trace(aile.StackTrace.ToString() + aile.Message);
				return;
			}

		}
		/////////////////////////////////////////////////////////////////////////
		/// Utilities
		/////////////////////////////////////////////////////////////////////////
		/// <summary>
		/// Displays a message in the form window.
		/// </summary>
		/// <param name="msg">Message to display.</param>
		public void Trace(string msg)
		{
			this.richTextBoxTrace.AppendText(msg+"\n");
			this.richTextBoxTrace.ScrollToCaret();
		}


		/// <summary>
		/// Gets media events and voice media events (for pull mode only).
		/// </summary>
		public void GetEvents()
		{
			if(mAgent != null)
			{

				while(mAgent.listen)
				{
					//Pulling events
					if(mAgent.HasEvent())
					{
						//Updating mAgent with pulled events
						mAgent.ProcessEvents();
						// Updating GUI
						UpdateStatuses();
						UpdateButtons();
					}
					else
						Thread.Sleep(1000);
				}
			}
		}

		/// <summary>
		/// Updates all DNs and media statuses in the data table.
		/// </summary>
		public void UpdateStatuses()
		{
			if(mAgent.mVoiceMediaInfo!= null && mAgent.mVoiceMediaInfo.Length !=0)
				foreach(VoiceMediaInfo v in mAgent.mVoiceMediaInfo)
				{
					this.SetStatus(v.dnId,v.status.ToString());
				}
			if(mAgent.mMediaInfo!= null && mAgent.mMediaInfo.Length != 0)
				foreach(MediaInfo m in mAgent.mMediaInfo)
				{
					this.SetStatus(m.name,m.status.ToString());
				}
		}
		/// <summary>
		/// Updates a DN or media status in the table of statuses.
		/// </summary>
		/// <param name="name">DN ID or Media name.</param>
		/// <param name="status">Status.</param>
		public void SetStatus(string name, string status)
		{
			Trace("Update: "+ name + " New status: "+status);
			lock (tStatus)
			{
				if(tStatus.Rows.Contains(name) == false)
				{
					DataRow myMediaRow = tStatus.NewRow();
					myMediaRow["Name"] = name;
					myMediaRow["Status"] = status;
					tStatus.Rows.Add(myMediaRow);

				}
				else
				{
					DataRow myMediaRow = tStatus.Rows.Find(name);
					myMediaRow["Status"] = status;
				}
			}
		}

		/// <summary>
		/// Sets the agent ID in the tithe bar.
		/// </summary>
		public void SetTitle()
		{
			this.Text = "Place for agent "+ mAgent.mAgentId;
		}
		/// <summary>
		/// Updates the buttons depending on the mAgent actions attributes.
		/// </summary>
		public void UpdateButtons()
		{
			bool login = false;
			this.buttonLogin.Enabled = false;
			bool logout = false;
			this.buttonLogout.Enabled = false;
			bool ready = false;
			this.buttonReady.Enabled = false;
			bool notReady = false;
			this.buttonNotReady.Enabled = false;

			Trace("Updating buttons with the following actions:");

			/// If an action is possible for at least one media or DN, this enables the corresponding button.

			try
			{
                if(mAgent.mMediaActionsPossible!= null && mAgent.mMediaActionsPossible.Length != 0)
				{
					/// Testing possible actions for each media
					foreach(MediaActionsPossible myMediaActions in mAgent.mMediaActionsPossible)
					{
						string msg = "\t"+myMediaActions.mediaType.ToString()+ " -  ";
						foreach(AgentMediaAction action in myMediaActions.agentActions)
						{
							msg+=action.ToString()+ "  ";
							login = login || (action == AgentMediaAction.LOGIN);
							logout = logout || (action == AgentMediaAction.LOGOUT);
							ready = ready || (action == AgentMediaAction.READY);
							notReady = notReady || (action == AgentMediaAction.NOT_READY);
						}
						Trace(msg);
					}

				}
                if(mAgent.mDnActionsPossible!=null && mAgent.mDnActionsPossible.Length != 0)
				{
					/// Testing possible actions for each DN
					foreach(DnActionsPossible myDnActions in mAgent.mDnActionsPossible)
					{
						string msg = "\t"+myDnActions.dnId+ " - ";
						foreach(AgentDnAction action in myDnActions.agentActions)
						{
							msg+=action.ToString()+ "  ";
							login = login || (action == AgentDnAction.LOGIN);
							logout = logout || (action == AgentDnAction.LOGOUT);
							ready = ready || (action == AgentDnAction.READY);
							notReady = notReady || (action == AgentDnAction.NOT_READY);
						}
						Trace(msg);

					}
				}

				///
               /*
				* If you are using a GAD .NET Toolkit integrating an AIL version prior to 7.0.104.0,
				* uncomment the following code.
				*/
				/*
				if(this.mAgent.mVoiceMediaInfo[0].status == VoiceMediaStatus.LOGGED_OUT && ready)
					ready = false;
					*/

				///Updating buttons
				this.buttonLogin.Enabled = login;
				this.buttonLogout.Enabled = logout;
				this.buttonNotReady.Enabled = notReady;
				this.buttonReady.Enabled = ready;
				Trace("Buttons updated");
			}
			catch(Exception _e)
			{
				Trace(_e.ToString());
			}
		}

		/// <summary>
		/// Starts the monitoring of a new Agent.
		/// </summary>
		public void Start()
		{
			/// Getting new Agent properties
			LoginForm editAgent = new LoginForm(mAgent.mAgentId,mAgent.mPlace,mAgent.mQueue,mAgent.mAgentLogin,mAgent.mAgentPassword);

			/// If the dialog box result is OK, the application assigns
			// the input to Agent attributes
			if(editAgent.ShowDialog() == DialogResult.OK)
			{
				mAgent.mAgentId = editAgent.agentID;
				mAgent.mPlace = editAgent.place;
				mAgent.mAgentPassword = editAgent.password;
				mAgent.mQueue = editAgent.queue;
				mAgent.mAgentLogin = editAgent.loginID;
				editAgent.Dispose();

				Trace("Updating application with Agent properties");
				SetTitle();
				this.tStatus.Rows.Clear();
				mAgent.Load();
				UpdateStatuses();
				UpdateButtons();

				//Registering events
				string result = this.mAgent.RegisterEvent();
				Trace(result);

			}
		}
		/// <summary>
		/// Sets the pull mode for retrieving events.
		/// </summary>
		private void SetPullMode()
		{
			this.mAgent.setNotification(null);
			thEvents = new Thread(new ThreadStart(this.GetEvents));
			thEvents.Name ="GetEvents";
			thEvents.Start();
			this.menuItemPull.Checked = true;
			this.menuItemPush.Checked = false;
			Trace("Pull mode activated");
		}
		/// <summary>
		/// Sets the push mode for retrieving events.
		/// </summary>
		private void SetPushMode()
		{
			this.mAgent.setNotification(this);
			this.menuItemPull.Checked = false;
			this.menuItemPush.Checked = true;
			Trace("Push mode activated");
		}

		/// <summary>
		/// Cleans up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.buttonLogin = new System.Windows.Forms.Button();
			this.buttonLogout = new System.Windows.Forms.Button();
			this.buttonReady = new System.Windows.Forms.Button();
			this.buttonNotReady = new System.Windows.Forms.Button();
			this.dataGrid1 = new System.Windows.Forms.DataGrid();
			this.richTextBoxTrace = new System.Windows.Forms.RichTextBox();
			this.contextMenuPlace = new System.Windows.Forms.ContextMenu();
			this.mainMenu = new System.Windows.Forms.MainMenu();
			this.menuItemAgent = new System.Windows.Forms.MenuItem();
			this.menuItemEditAgent = new System.Windows.Forms.MenuItem();
			this.menuItemEvents = new System.Windows.Forms.MenuItem();
			this.menuItemNotif = new System.Windows.Forms.MenuItem();
			this.menuItemPush = new System.Windows.Forms.MenuItem();
			this.menuItemPull = new System.Windows.Forms.MenuItem();
			((System.ComponentModel.ISupportInitialize)(this.dataGrid1)).BeginInit();
			this.SuspendLayout();
			//
			// buttonLogin
			//
			this.buttonLogin.Location = new System.Drawing.Point(8, 24);
			this.buttonLogin.Name = "buttonLogin";
			this.buttonLogin.Size = new System.Drawing.Size(64, 24);
			this.buttonLogin.TabIndex = 5;
			this.buttonLogin.Text = "Login";
			this.buttonLogin.Click += new System.EventHandler(this.buttonLogin_Click);
			//
			// buttonLogout
			//
			this.buttonLogout.Enabled = false;
			this.buttonLogout.Location = new System.Drawing.Point(8, 144);
			this.buttonLogout.Name = "buttonLogout";
			this.buttonLogout.Size = new System.Drawing.Size(64, 24);
			this.buttonLogout.TabIndex = 6;
			this.buttonLogout.Text = "Logout";
			this.buttonLogout.Click += new System.EventHandler(this.buttonLogout_Click);
			//
			// buttonReady
			//
			this.buttonReady.Enabled = false;
			this.buttonReady.Location = new System.Drawing.Point(8, 64);
			this.buttonReady.Name = "buttonReady";
			this.buttonReady.Size = new System.Drawing.Size(64, 24);
			this.buttonReady.TabIndex = 7;
			this.buttonReady.Text = "Ready";
			this.buttonReady.Click += new System.EventHandler(this.buttonReady_Click);
			//
			// buttonNotReady
			//
			this.buttonNotReady.Enabled = false;
			this.buttonNotReady.Location = new System.Drawing.Point(8, 104);
			this.buttonNotReady.Name = "buttonNotReady";
			this.buttonNotReady.Size = new System.Drawing.Size(64, 24);
			this.buttonNotReady.TabIndex = 8;
			this.buttonNotReady.Text = "NotReady";
			this.buttonNotReady.Click += new System.EventHandler(this.buttonNotReady_Click);
			//
			// dataGrid1
			//
			this.dataGrid1.DataMember = "";
			this.dataGrid1.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			this.dataGrid1.Location = new System.Drawing.Point(80, 32);
			this.dataGrid1.Name = "dataGrid1";
			this.dataGrid1.PreferredColumnWidth = 150;
			this.dataGrid1.Size = new System.Drawing.Size(328, 136);
			this.dataGrid1.TabIndex = 9;
			//
			// richTextBoxTrace
			//
			this.richTextBoxTrace.BackColor = System.Drawing.SystemColors.Info;
			this.richTextBoxTrace.ForeColor = System.Drawing.SystemColors.HotTrack;
			this.richTextBoxTrace.Location = new System.Drawing.Point(8, 200);
			this.richTextBoxTrace.Name = "richTextBoxTrace";
			this.richTextBoxTrace.Size = new System.Drawing.Size(400, 144);
			this.richTextBoxTrace.TabIndex = 11;
			this.richTextBoxTrace.Text = "";
			//
			// mainMenu
			//
			this.mainMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					 this.menuItemAgent,
																					 this.menuItemEvents});
			//
			// menuItemAgent
			//
			this.menuItemAgent.Index = 0;
			this.menuItemAgent.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						  this.menuItemEditAgent});
			this.menuItemAgent.Text = "Agent";
			//
			// menuItemEditAgent
			//
			this.menuItemEditAgent.Index = 0;
			this.menuItemEditAgent.Text = "Edit Agent";
			this.menuItemEditAgent.Click += new System.EventHandler(this.menuItemEditAgent_Click);
			//
			// menuItemEvents
			//
			this.menuItemEvents.Index = 1;
			this.menuItemEvents.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						   this.menuItemNotif});
			this.menuItemEvents.Text = "Events";
			//
			// menuItemNotif
			//
			this.menuItemNotif.Index = 0;
			this.menuItemNotif.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						  this.menuItemPush,
																						  this.menuItemPull});
			this.menuItemNotif.Text = "Notification Mode";
			//
			// menuItemPush
			//
			this.menuItemPush.Index = 0;
			this.menuItemPush.Text = "Push";
			this.menuItemPush.Click += new System.EventHandler(this.menuItemPush_Click);
			//
			// menuItemPull
			//
			this.menuItemPull.Checked = true;
			this.menuItemPull.Index = 1;
			this.menuItemPull.Text = "Pull";
			this.menuItemPull.Click += new System.EventHandler(this.menuItemPull_Click);
			//
			// StatusForm
			//
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(416, 353);
			this.Controls.Add(this.richTextBoxTrace);
			this.Controls.Add(this.dataGrid1);
			this.Controls.Add(this.buttonNotReady);
			this.Controls.Add(this.buttonReady);
			this.Controls.Add(this.buttonLogout);
			this.Controls.Add(this.buttonLogin);
			this.Menu = this.mainMenu;
			this.Name = "StatusForm";
			this.Text = "Form Agent";
			((System.ComponentModel.ISupportInitialize)(this.dataGrid1)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main()
		{
			Application.Run(new AgentStatusForm());
		}

		/// <summary>
		/// Performs the Login action. Method called when the user clicks on the Login button.
		/// </summary>
		private void buttonLogin_Click(object sender, System.EventArgs e)
		{
			Trace("Performing Login...");
			mAgent.Login();

		}

		/// <summary>
		/// Performs the Ready action. Method called when the user clicks on the Ready button.
		/// </summary>
		private void buttonReady_Click(object sender, System.EventArgs e)
		{
			Trace("Performing Ready...");
			mAgent.Ready();
		}

		/// <summary>
		/// Performs the NotReady action. Method called when the user clicks on the NotReady button.
		/// </summary>
		private void buttonNotReady_Click(object sender, System.EventArgs e)
		{
			Trace("Performing Not Ready...");
			mAgent.NotReady();

		}

		/// <summary>
		///  Performs the Logout action. Method called when the user clicks on the Logout button.
		/// </summary>
		private void buttonLogout_Click(object sender, System.EventArgs e)
		{
			Trace("Performing Logout...");
			mAgent.Logout();
		}

		/// <summary>
		/// Unregisters Events and disconnects. Method called when the user closes the application.
		/// </summary>
		private void AgentStatusForm_Closed(object sender, EventArgs e)
		{
			try
			{
			    this.mAgent.listen = false;
				this.mAgent.UnRegisterEvent();
				this.mAgent.mConnection.Disconnect();
			}catch(Exception __e)
			{}
			Application.Exit();

		}

		private void menuItemEditAgent_Click(object sender, System.EventArgs e)
		{
			Start();
		}

		/// <summary>
		/// Enables the pull mode for events.
		/// </summary>
		private void menuItemPull_Click(object sender, System.EventArgs e)
		{
			SetPullMode();
		}

		/// <summary>
		/// Enables the push mode for events.
		/// </summary>
		private void menuItemPush_Click(object sender, System.EventArgs e)
		{
			SetPushMode();
		}

		/// <summary>
		/// Method called when the underlying event service receives an event. This method is called in push mode only.
		/// </summary>
		public void notifyEvents(string subscriberId,
			com.genesyslab.ail.ws._event.Event[] events)
		{
			if (events == null)
			{
				Trace("NotifyEvents - null");
				return ;
			}
			Trace( "NotifyEvents getEvents : " +
				events.Length) ;
			foreach( Event evt in events)
			{
				mAgent.HandleEvent(evt);
				Trace( "Service :"+ evt.serviceName
					+ "Event: "+ evt.eventName
					+ "timeStamp:"+ evt.timeStamp);
				UpdateButtons();
				UpdateStatuses();
			}
		}



	}


}
