/*=====================================================================

Any authorized distribution of any copy of this code (including any related documentation) must reproduce the following restrictions, disclaimer and copyright notice:

The Genesys name, trademarks and/or logo(s) of Genesys shall not be used to name (even as a part of another name), endorse and/or promote products derived from this code without prior written permission from Genesys Telecommunications Laboratories, Inc.

The use, copy, and/or distribution of this code is subject to the terms of the Genesys Developer License Agreement.  This code shall not be used, copied, and/or distributed under any other license agreement.

THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES, INC. (GENESYS) AS IS WITHOUT ANY WARRANTY OF ANY KIND. GENESYS HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS, REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).

Copyright &copy; 2008 Genesys Telecommunications Laboratories, Inc. All rights reserved.

=====================================================================*/

package com.genesyslab.gis.services.configuration;

import com.genesyslab.gis.services.session.ConnectSessionServiceExample;
import com.genesyslab.gis.util.PropertiesLoader;

/*
 * This example demonstrates how to register for a configuration service. The
 * code also shows how to release the service and log out from GIS.
 * 
 * @Date June, 2008
 */

public class RegisterToConfigurationServiceExample {

	public ConnectSessionServiceExample cs;

	public GCESoapPort configPort;
	public GCELocator configService = new GCELocator();

	String[] services = new String[] { "GIS_CONFIGSERVICE" };

	/*
	 * This method uses the ConnectToServiceExample to login and retrieve the
	 * session id. Then it registers, by logging in, to a configuration service.
	 * 
	 * @param gisServer String value in format of <gisHost>:<gisPort>
	 */
	public void register(String gisServer) throws Exception {

		cs = new ConnectSessionServiceExample(services);
		cs.execute(gisServer);

		String cfgUserName = "default";
		String cfgUserPassw = "password";
		String cfgAppName = "default";

		// Connection parameters used to connect and register at GIS and
		// Configuration Service

		// Create Configuration Service

		configService.setMaintainSession(true);
		configPort = configService.getGCESoapPort(new java.net.URL("http://"
				+ gisServer + "/gis/services/CSProxyService?GISsessionId="
				+ cs.sid));

		// Register at the Configuration Service
		configPort.register(cfgUserName, cfgUserPassw, cfgAppName);
		System.out.println("done");
	}

	// releases the service and log out of the session
	public void releaseAndLogout() throws Exception {

		System.out.print("Releasing the configuration service license...");
		cs.port.releaseServices(services);
		System.out.println("done");

		System.out.println("Logging out of the GIS session ...");
		cs.port.logout(cs.sid);
		System.out.println("Logged out successfully.");

	}

	// Standalone option to test run this example. Creates a new instance of
	// this object and starts the process
	public static void main(String[] args) {
		String gisHost = PropertiesLoader.getOption("gis.host");
		String gisPort = PropertiesLoader.getOption("gis.port");
		try {
			RegisterToConfigurationServiceExample sb = new RegisterToConfigurationServiceExample();
			sb.register(gisHost + ":" + gisPort);
			sb.releaseAndLogout();
		} catch (Exception serviceException) {
			System.out.println(serviceException.getMessage());
		}
	}

}