/*=====================================================================

Any authorized distribution of any copy of this code (including any related documentation) must reproduce the following restrictions, disclaimer and copyright notice:

The Genesys name, trademarks and/or logo(s) of Genesys shall not be used to name (even as a part of another name), endorse and/or promote products derived from this code without prior written permission from Genesys Telecommunications Laboratories, Inc.

The use, copy, and/or distribution of this code is subject to the terms of the Genesys Developer License Agreement.  This code shall not be used, copied, and/or distributed under any other license agreement.

THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES, INC. (GENESYS) AS IS WITHOUT ANY WARRANTY OF ANY KIND. GENESYS HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS, REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).

Copyright &copy; 2008 Genesys Telecommunications Laboratories, Inc. All rights reserved.

=====================================================================*/

package com.genesyslab.gis.services.configuration;

import java.util.Iterator;

import org.apache.axis.message.MessageElement;

import com.genesyslab.gis.services.configuration.types.CSResult;
import com.genesyslab.gis.util.PropertiesLoader;

public class SolicitedNotificationByBlockingExample {

	// Connection parameters used to connect and register at GIS and
	// Configuration Service
	String gisPrincipal = "default";
	String gisCredentials = "password";
	String cfgUserName = "default";
	String cfgUserPassw = "password";
	String cfgAppName = "default";

	// execute method - accomplishes all the sample's application logic
	public void execute(String gisServer) throws Exception {

		// this class provides functionality to register, unsubscribe, release
		// and log out from the GIS configuration service
		RegisterToConfigurationServiceExample subConfig = new RegisterToConfigurationServiceExample();
		subConfig.register(gisServer); // register to GIS configuration service

		// subscribe on notifications on Agents
		System.out.println("Subscription on notifications completed ..."
				+ subConfig.configPort.subscribe("CfgAgent", "", ""));

		System.out.println("Waiting for notifications ...");
		// make a getEvent call
		CSResult result = subConfig.configPort.getEvent();
		System.out.println("Notification arrived");

		// print results
		displayNotification(result.get_any()[0], "CfgCreate", "Created");
		displayNotification(result.get_any()[0], "CfgUpdate", "Updated");
		displayNotification(result.get_any()[0], "CfgRemove", "Removed");

		// Logout from the Session service
		subConfig.releaseAndLogout();
	}

	// / Displays results of the notification
	public void displayNotification(MessageElement cfgData, String elementName,
			String textStr) {

		Iterator iter = cfgData.getChildElements();
		MessageElement oper = null;

		while (iter.hasNext())

			if (((oper = (MessageElement) iter.next()) != null)
					&& oper.getName().equals(elementName)) {
				System.out.println("\n" + textStr + ":");
				Iterator subIter = oper.getChildElements();
				MessageElement obj = null;
				while (subIter.hasNext())
					if ((obj = (MessageElement) subIter.next()) != null)
						System.out.println("  Object type = '" + obj.getName()
								+ "', DBID = " + obj.getAttributeValue("DBID")
								+ ", name = " + obj.getAttributeValue("name")
								+ "\n");
			}
	}

	// The main entry point for the application.
	public static void main(String args[]) throws Exception {
		String gisHost = PropertiesLoader.getOption("gis.host");
		String gisPort = PropertiesLoader.getOption("gis.port");
		SolicitedNotificationByBlockingExample example = new SolicitedNotificationByBlockingExample();
		example.execute(gisHost + ":" + gisPort);
	}
}
