/*=====================================================================

Any authorized distribution of any copy of this code (including any related documentation) must reproduce the following restrictions, disclaimer and copyright notice:

The Genesys name, trademarks and/or logo(s) of Genesys shall not be used to name (even as a part of another name), endorse and/or promote products derived from this code without prior written permission from Genesys Telecommunications Laboratories, Inc.

The use, copy, and/or distribution of this code is subject to the terms of the Genesys Developer License Agreement.  This code shall not be used, copied, and/or distributed under any other license agreement.

THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES, INC. (GENESYS) AS IS WITHOUT ANY WARRANTY OF ANY KIND. GENESYS HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS, REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).

Copyright &copy; 2008 Genesys Telecommunications Laboratories, Inc. All rights reserved.

=====================================================================*/

package com.genesyslab.gis.services.session;

import com.genesyslab.gis.util.PropertiesLoader;

/*
 * This example demonstrates how to browse services available, release services,
 * and logout session.
 * 
 * Date: June, 2008
 * 
 */

public class IdentifyServicesExample {

	public String[] services;

	public IdentifyServicesExample(String[] gisServices) {
		services = gisServices;
	}

	/*
	 * This method uses the ConnectToServiceExample to login and subscribe to a
	 * service. Then it browses the services available, releases those services
	 * and finally log out of the session.
	 * 
	 * @param gisServer <gis_host>:<gis_port>
	 */

	public void execute(String gisServer) throws Exception {

		ConnectSessionServiceExample cs = new ConnectSessionServiceExample(
				services);
		cs.execute(gisServer);

		// we identify which service licenses we have checked out
		String[] licenses_checked = cs.port.browseServices();
		for (int i = 0; i < licenses_checked.length; i++)
			System.out.println("browsing services available: "
					+ licenses_checked[i]);

		// we release the licenses checked
		System.out.println("releasing services...");
		String[] licenses_released = cs.port.releaseServices(services);

		for (int i = 0; i < licenses_released.length; i++)
			System.out.println("services released: " + licenses_released[i]);
		cs.port.logout(cs.sid); // logout request
		System.out.println("logout from session");

	}

	// Standalone option to test run this example. Creates a new instance of
	// this object and starts the process
	public static void main(String[] args) {
		String gisHost = PropertiesLoader.getOption("gis.host");
		String gisPort = PropertiesLoader.getOption("gis.port");
		try {
			IdentifyServicesExample example = new IdentifyServicesExample(args);
			example.execute(gisHost + ":" + gisPort);

		} catch (Exception serviceException) {
			System.out.println("Exception occured: "
					+ serviceException.getMessage());
		}
	}
}