/*=====================================================================
 * Any authorized distribution of any copy of this code (including any
 * related documentation) must reproduce the following restrictions,
 * disclaimer and copyright notice:
 *
 * The Genesys name, the trademarks and/or logo(s) of Genesys shall
 * not be used to name (even as a part of another name), endorse and/or
 * promote products derived from this code without prior written
 * permission from Genesys Telecommunications Laboratories, Inc.
 *
 * The use, copy, and/or distribution of this code is subject to the
 * terms of the Genesys Developer License Agreement.  This code shall
 * not be used, copied, and/or distributed under any other license
 * agreement.
 *
 * THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES,
 * INC. ("GENESYS") "AS IS" WITHOUT ANY WARRANTY OF ANY KIND. GENESYS
 * HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS,
 * REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY
 * PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR
 * ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT
 * SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).
 *
 * Copyright (C) 2006-2008 Genesys Telecommunications Laboratories,
 * Inc. All rights reserved.
 =====================================================================*/
package gis.sessExamples;

import gis.services.session.SessionService;
import gis.services.session.SessionServiceServiceLocator;
import gis.services.session.SessionServiceSoapBindingStub;
import gis.services.session.Identity;

import javax.xml.rpc.ServiceException;
import java.rmi.RemoteException;

/**
 * This example demonstrates how to create and log into GIS, and how to retrieve a session id
 * It also shows how to log out of a session.
 *
 * Created Date: March 25, 2003
 * Modified Date: December 20, 2007
 */

public class CreateSessionExample {

    public CreateSessionExample() {}

    public SessionService port;
    public String sid;

    /*
     * This method logs into the GIS server using the specified host and port information.
     * Then it retrieves the session from the GIS server.
     *
     * @param gisServer <gis_host>:<gis_port>
     */

    public void loginAndCreateSession(String gisServer) throws Exception {

        String url = "";
        String url_sid = "";

        //create a new proxy instance.
        SessionServiceServiceLocator service = new SessionServiceServiceLocator();
        port = service.getSessionService();
        url = "http://" + gisServer + "/gis/services/SessionService";
        //Bind session address endpoint
        ((SessionServiceSoapBindingStub) port)._setProperty(javax.xml.rpc.Stub.ENDPOINT_ADDRESS_PROPERTY, url);
        //login request
        Identity identity = new Identity();
        identity.setPrincipal("default");
        identity.setCredentials("password");
        identity.setTenant("Resources");

        System.out.println("logging into session server...");
        sid = port.login(identity);
        url_sid = url + "?GISsessionId=" + sid;

	System.out.println("logged into session server sucessfully. Session id =" + sid);
        //Bind session address endpoint with session id
        ((SessionServiceSoapBindingStub) port)._setProperty(javax.xml.rpc.Stub.ENDPOINT_ADDRESS_PROPERTY, url_sid);

    }

    //Standalone option to test run this example. Creates a new instance of this object and starts the process
    public static void main(String[] args) {
        try {
            CreateSessionExample example = new CreateSessionExample();
            example.loginAndCreateSession("localhost:9090");

            System.out.println("logging out of session server...");
            example.port.logout(example.sid);          //logout request
	    System.out.println("completed. Client logged out of session server...");

        } catch (Exception serviceException) {
            System.out.println(serviceException.getMessage());
        }
    }
}