/*=====================================================================
 * Any authorized distribution of any copy of this code (including any
 * related documentation) must reproduce the following restrictions,
 * disclaimer and copyright notice:
 *
 * The Genesys name, the trademarks and/or logo(s) of Genesys shall
 * not be used to name (even as a part of another name), endorse and/or
 * promote products derived from this code without prior written
 * permission from Genesys Telecommunications Laboratories, Inc.
 *
 * The use, copy, and/or distribution of this code is subject to the
 * terms of the Genesys Developer License Agreement.  This code shall
 * not be used, copied, and/or distributed under any other license
 * agreement.
 *
 * THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES,
 * INC. ("GENESYS") "AS IS" WITHOUT ANY WARRANTY OF ANY KIND. GENESYS
 * HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS,
 * REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY
 * PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR
 * ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT
 * SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).
 *
 * Copyright (C) 2006-2008 Genesys Telecommunications Laboratories,
 * Inc. All rights reserved.
 =====================================================================*/
package cfgNotification;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import java.net.URL;
import java.util.*;

/*
 * This class demonstrates a server side code based on the GIS notification.wsdl file.
 * The examples' version of the notify() method accepts notification of statistic or configuration requests.
 * Then it stores the data into a static hashtable. The retrieveMessage() method demonstrates a simple implementation
 * of how a remote agent desktop client can receive these published GIS data via it own client http server.
 *
 * @date Nov 25, 2003
 *
 *
 * This class is what we are publishing. The notify() method is published
 * based on the notification.wsdl file. The service needs to be deployed using the deploy.wsdd file
 *
 * Before you start, make sure the Tomcat\Axis is running. Take note on the port it is running on.
 * You may need to change the port in any affected steps below:
 *
 * To publish a java file:
 *
 *  1) create a wsdl to describe it (see angie.wsdl for reference)
 *  2) Create a wsdd deployment file. (see deploy.wsdd in samples\gisNotification)
 *  3) go to directory D:\tomcat\jakarta-tomcat-3.2.4\webapps\axis\samples\gisNotification>
 *
 *  4) run setAxisPath.bat provided
 *
 *  5) type the following (all on one line):
 *      D:\tomcat\jakarta-tomcat-3.2.4\webapps\axis\samples\angieTest>java -cp %AXISCLASSPATH%
 *         org.apache.axis.client.AdminClient -lhttp://<yourTomcatHost>:8080/axis/services/AdminService deploy.wsdd
 *
 *  6) You should see the result like this:
 *
 *    Nov 25, 2003 3:29:58 PM org.apache.axis.client.AdminClient process
 *    INFO: Processing file deploy.wsdd
 *    Nov 25, 2003 3:29:59 PM org.apache.axis.client.AdminClient main
 *    INFO: <Admin>Done processing</Admin>
 *
 *  7) You should immediately check the server-config.wsdd file. This is the Axis service deployment config file.
 *     You should see your newly deployed service entry in there. If not, your service did not deploy properly
 *
 *  8) When you see your service entry in the server-config.wsdd file, open IE and test the service
 *        "http://<yourGISHost>:8080/axis/services/cfgNotification"
 *
 *     You should see a simple message about the service:
 *
 *      Hello from Config notification service
 *	host 5551 port HOST_123 serverapp CSProxy_HOST123
 *	Got message
 *	Message: <CfgData><CfgUpdate><CfgSkill DBID="107" ownerDBID="101" name="Skill_test" tenantDBID="101" state="1"><userProperties/></CfgSkill></CfgUpdate></CfgData>
 *
 *     You should also check the wsdl for the service url:
 *
 *         http://<yourGISHost>:8080/axis/services/cfgNotification?wsdl
 *
 *   9) When you get to this step, you can try a client to access this information
 *
 */


public class NotifyService {

  private static String msg = new String();

  public void notifyMessage(String cfgData) {

    System.out.println("Got message...");
    System.out.println("Message: " + cfgData);
    msg = cfgData;
  }

  public void notifyInitMessage(String host, String port, String serverApp) {

    System.out.println("Hello from Config notification service");
    System.out.println("host " + host + " port " + port + " serverapp " + serverApp);
  }

  public String retrieveMessage(){
     return msg;
  }


}
