﻿/*=====================================================================

Any authorized distribution of any copy of this code (including any related documentation) must reproduce the following restrictions, disclaimer and copyright notice:

The Genesys name, trademarks and/or logo(s) of Genesys shall not be used to name (even as a part of another name), endorse and/or promote products derived from this code without prior written permission from Genesys Telecommunications Laboratories, Inc.

The use, copy, and/or distribution of this code is subject to the terms of the Genesys Developer License Agreement.  This code shall not be used, copied, and/or distributed under any other license agreement.

THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES, INC. (“GENESYS”) “AS IS” WITHOUT ANY WARRANTY OF ANY KIND. GENESYS HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS, REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).

Copyright &copy; 2007-2008 Genesys Telecommunications Laboratories, Inc. All rights reserved.

=====================================================================*/

using System;
using GISServices;

/*
 * This example demonstrates how to create a log into GIS and retrieve a session id
 * It also shows how to log out of a session
 *
 */

public class CreateSessionExample
{
    public SessionServiceService port;
    public string sid;

    /*
     * This method logs into the GIS server using the specified host and port information
     * Then it retrieves the session from the GIS server
     * 
     */

    public void execute(String targetHost)
    {
        string url = "";
        string url_sid = "";

        //create a new proxy instance.
        port = new SessionServiceService();
        port.Url = "http://" + targetHost + "/gis/services/SessionService";
        //login request
        Identity identity = new Identity();
        identity.principal = "default";
        identity.credentials = "password";
        identity.tenant = "Resources";

        System.Console.WriteLine("logging into session server...");
        sid = port.login(identity);
        url_sid = url + "?GISsessionId=" + sid;

        System.Console.WriteLine("logged into session server successfully. Session id =" + sid);
        port.Url = "http://" + targetHost + "/gis/services/SessionService?GISsessionId=" + sid;

    }
}
