﻿using System;
using GISServices;

/*
 * This example demonstrates how to retrieve Statistic profiles in Configuration Management
 * The items returned includes the statitic names available for subscription,
 * timerange and timeprofile if available.
 * 
 */

public class RetrieveStatisticalProfileExample
{

    /* 
     * This method uses the ConnectToServiceExample to login and subscribe to a service.
     * Then it retrieves the statistic profiles as seen under the Option tab, in the stat server
     * application object in Configuration Management.
     *
     */
    public void execute(String targetHost)
    {
        StatServiceService port_stat;

        ConnectSessionServiceExample cs = new ConnectSessionServiceExample();
        cs.execute(targetHost);

        //create a new proxy instance.
        port_stat = new StatServiceService();
        port_stat.Url = "http://" + targetHost + "/gis/services/StatService?GISsessionId=" + cs.sid;

        //-------------------------------------------------
        //Retrieve statistical profiles request
        //-------------------------------------------------
        retrieveStatisticalProfileResponse statistic_profile = port_stat.retrieveStatisticalProfile("", statisticalProfileType.statisticalProfile);
        System.Console.WriteLine("retrieving statistic profiles...");

        profileInfo info = statistic_profile.statisticalProfileInfo;
        statisticTypeInfoType[] types = info.statisticInfos;
        if (types != null)
            foreach (statisticTypeInfoType infoType in types)
            {
                System.Console.Write(infoType.typeName + "( " + infoType.type + ") ->");
                foreach (objectType type in infoType.objectTypes)
                {
                    System.Console.Write(": " + type);
                }
            }

        //retrieve filter names
        retrieveStatisticalProfileResponse filter_profile = port_stat.retrieveStatisticalProfile("", statisticalProfileType.filterProfile);
        System.Console.WriteLine("retrieving filter profiles...");
        profileInfo info1 = filter_profile.statisticalProfileInfo;
        parameter[] filters = info1.filters;
        if (filters != null)
            foreach (parameter filter in filters)
            {
                System.Console.WriteLine("Key= " + filter.key + " Value= " + filter.value);
            }
        //retrieve time profile names
        retrieveStatisticalProfileResponse time_profile = port_stat.retrieveStatisticalProfile("", statisticalProfileType.timeProfile);
        System.Console.WriteLine("retrieving time profiles...");

        profileInfo info2 = time_profile.statisticalProfileInfo;
        timeProfile[] timeProfs = info2.timeProfiles;
        if (timeProfs != null)
            foreach (timeProfile timeProf in timeProfs)
            {
                System.Console.Write("Key= " + timeProf.key + " Value= " + timeProf.value);
                System.Console.WriteLine(" time interval = " + timeProf.intervalType);
            }

        //retrieve time range names
        retrieveStatisticalProfileResponse time_range_profile = port_stat.retrieveStatisticalProfile("", statisticalProfileType.timeRangeProfile);
        System.Console.WriteLine("retrieving time range profiles...");

        profileInfo info3 = time_range_profile.statisticalProfileInfo;
        parameter[] timeRanges = info3.timeRanges;
        if (timeRanges != null)
            foreach (parameter timeRange in timeRanges)
            {
                System.Console.WriteLine("Key= " + timeRange.key + " Value= " + timeRange.value);
            }

        System.Console.WriteLine("logging out of session...");

        //logout request
        cs.port.logout(cs.sid);
    }
}
