/*=====================================================================

Any authorized distribution of any copy of this code (including any related documentation) must reproduce the following restrictions, disclaimer and copyright notice:

The Genesys name, trademarks and/or logo(s) of Genesys shall not be used to name (even as a part of another name), endorse and/or promote products derived from this code without prior written permission from Genesys Telecommunications Laboratories, Inc.

The use, copy, and/or distribution of this code is subject to the terms of the Genesys Developer License Agreement.  This code shall not be used, copied, and/or distributed under any other license agreement.

THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES, INC. (GENESYS) AS IS WITHOUT ANY WARRANTY OF ANY KIND. GENESYS HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS, REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).

Copyright &copy; 2007-2008 Genesys Telecommunications Laboratories, Inc. All rights reserved.

=====================================================================*/

using System;
using System.Threading;
using GISServices;

/*
 * This example demonstrates how to retrieve a statistic. 
 * 
 * In this example the object of interest is an agent, the statistic retrieved is the total login time 
 * for that agent. 
 * We are also assuming the agent object is under the Tenant defaultTenant. 
 * 
 * This example can be slightly modified to retrieve statistics for agent, queue, place, etc
 * See the statistic SDK documentation for details.
 */

public class RetrieveStatisticExample
{
    public StatServiceService port_stat;

    public RetrieveStatisticExample()
    {
    }

    public void execute(String targetHost)
    {
        //first step is to connect to a service. See ConnectToServiceExample.cs in current folder.

        ConnectSessionServiceExample cs = new ConnectSessionServiceExample();
        cs.execute(targetHost);

        //create a new proxy instance.
        port_stat = new StatServiceService();
        port_stat.Url = "http://" + targetHost + "/gis/services/StatService?GISsessionId=" + cs.sid;

        //build a statistic object
        statistic _statistic = new statistic();
        _statistic.statisticId = "statref1";

        //building object id
        objectIdType _objectIdType = new objectIdType();
        System.Console.WriteLine("Statistic needed for Agent 1000");
        //enter the employee id for this method
        _objectIdType.id = "1000";
        //the agent object is under the Tenant "defaultTenant"
        _objectIdType.tenantName = "defaultTenant";

        //adding object id data to statistic
        _statistic.objectId = _objectIdType;

        //building metric data
        metric _metric = new metric();

        statisticType _statisticType = new statisticType();
        objectType[] ot = new objectType[] { objectType.Agent };
        _statisticType.objectType = ot;
        _metric.statisticType = _statisticType;
        System.Console.WriteLine("Statistic interested is agent's 	Total Login Time");
        _metric.typeName = "TotalLoginTime";
        timeInterval _timeInterval = new timeInterval();
        _timeInterval.intervalType =
        timeIntervalType.GrowingWindow;
        _metric.interval = _timeInterval;

        //adding metric data to statistic
        _statistic.metric = _metric;

        //specify statistic schedule
        schedule _schedule = new schedule();
        _schedule.notificationMode = scheduleMode.ChangesBased;

        //adding schedule data to statistic
        _statistic.schedule = _schedule;

        //retrieve the statistic. StatServer is the application name of a particular Stat Server.
        retrieveStatisticResponse response = port_stat.retrieveStatistic(_statistic, "StatServer");

        //Note that first call to retrieveStatistic returns a value of zero (0), because the first call simply initializes the statistic. You must add a timeout between the
        //two calls. The GIS default session timeout is 30 secs, but you can select other value, such as 31 seconds as shown in this example.
        Thread.Sleep(31000);

        response = port_stat.retrieveStatistic(_statistic, "StatServer");
        //GIS returns the statistic value it has retrieved from Stat Server.
        statisticValue val = (statisticValue)response.statisticValue;
        System.Console.WriteLine("Retrieved statistic value = " + ((eventValue)val.eventValues.GetValue(0)).LValue);
    }
}