/*=====================================================================

Any authorized distribution of any copy of this code (including any related documentation) must reproduce the following restrictions, disclaimer and copyright notice:

The Genesys name, trademarks and/or logo(s) of Genesys shall not be used to name (even as a part of another name), endorse and/or promote products derived from this code without prior written permission from Genesys Telecommunications Laboratories, Inc.

The use, copy, and/or distribution of this code is subject to the terms of the Genesys Developer License Agreement.  This code shall not be used, copied, and/or distributed under any other license agreement.

THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES, INC. (GENESYS) AS IS WITHOUT ANY WARRANTY OF ANY KIND. GENESYS HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS, REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).

Copyright &copy; 2008 Genesys Telecommunications Laboratories, Inc. All rights reserved.

=====================================================================*/

package com.genesyslab.gis.services.notification;

import java.util.Hashtable;

public class NotificationService {

	private static Hashtable messages = new Hashtable();

	/*
	 * This method's signature follows the requirement set by the GIS
	 * notification.wsdl file. Note: You cannot modify the signature, otherwise
	 * the notification service will not work.
	 * 
	 * You can modify the code. This example below stores the data received from
	 * GIS into the cache via a hastable. This is only a suggestion of how you
	 * can store the data. Alternatively, you can write code to store
	 * information in a database or file.
	 * 
	 */

	public void notify(String eventType, String[][] keyVal) {

		System.out.println("Hello from gis notification service");
		System.out.println("event type " + eventType);

		for (int i = 0; i < keyVal.length; i++)
			for (int j = 0; j < keyVal[0].length; j++) {
				System.out.println("key val " + keyVal[i][j]);
				if (keyVal[i][j].indexOf("SessionService") != -1) // contains
																	// session
																	// id
					messages.put(keyVal[i][j], keyVal); // store (and overwrite)
														// each session's
														// message using its sid
														// as key value
			}
	}

	/*
	 * This method is NOT part of the GIS notification.wsdl specification. It's
	 * purpose is to demonstrate that you can deploy a user-defined interface in
	 * the *same* notification service to retrieve the data stored by the
	 * notify() method above. This is just one of many ways to retrieve the data
	 * stored. Note: You do not need to deploy a user-service to retrieve stored
	 * data. A desktop client can access a database or flat file. A web client
	 * that cannot or should not access database or file system can benefit from
	 * this solution.
	 * 
	 * In the sample deploy.wsdd file provided, note that the 'allowedMethods'
	 * parameter value is set to '*'. This setting allows any method defined in
	 * this class to be published as an interface. The extra API or interface in
	 * the service is called 'retrieveMessage'. You can see it when you go to
	 * your URL: http://<your_tomcat_hostName>:<your_tomcat_port>/axis/services.
	 * The page lists all the deployed services with the interface exposed.
	 * 
	 */

	public String retrieveMessage(String sid) {
		try {
			// PrintWriter out = new PrintWriter(new
			// FileOutputStream("C:\\<TomcatHome>\\logs\\test.txt"));
			// //debugging only

			System.out.println("sid= " + sid);
			String[][] msgArray = (String[][]) messages.get(sid);
			String msg = new String();

			while (msgArray == null) {
				System.out
						.println("Waiting to receive information for this session id.");
				msgArray = (String[][]) messages.get(sid);
			}

			// flatten the array into a string for ease of demonstration.
			for (int i = 0; i < msgArray.length; i++)
				for (int j = 0; j < msgArray[0].length; j++) {
					if (j % 2 == 1)
						msg = msg + " = " + msgArray[i][j] + "\n";
					else
						msg = msg + msgArray[i][j];
				}
			return msg;
		} catch (Exception e) {
			return null;
		}
	}

}
