/*=====================================================================

Any authorized distribution of any copy of this code (including any related documentation) must reproduce the following restrictions, disclaimer and copyright notice:

The Genesys name, trademarks and/or logo(s) of Genesys shall not be used to name (even as a part of another name), endorse and/or promote products derived from this code without prior written permission from Genesys Telecommunications Laboratories, Inc.

The use, copy, and/or distribution of this code is subject to the terms of the Genesys Developer License Agreement.  This code shall not be used, copied, and/or distributed under any other license agreement.

THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES, INC. (GENESYS) AS IS WITHOUT ANY WARRANTY OF ANY KIND. GENESYS HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS, REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).

Copyright &copy; 2008 Genesys Telecommunications Laboratories, Inc. All rights reserved.

=====================================================================*/

package com.genesyslab.gis.services.statistic;

import com.genesyslab.gis.services.session.ConnectSessionServiceExample;
import com.genesyslab.gis.services.statistic.types.ObjectType;
import com.genesyslab.gis.services.statistic.types.Parameter;
import com.genesyslab.gis.services.statistic.types.ProfileInfo;
import com.genesyslab.gis.services.statistic.types.RetrieveStatisticalProfileResponse;
import com.genesyslab.gis.services.statistic.types.StatisticTypeInfoType;
import com.genesyslab.gis.services.statistic.types.StatisticalProfileType;
import com.genesyslab.gis.services.statistic.types.TimeProfile;
import com.genesyslab.gis.util.PropertiesLoader;


/**
 * This example demonstrates how to retrieve Statistic profiles in Configuration Management
 * The items returned include statistic names, time range, and time profile.
 *
 * Date: June, 2008
 *
 */

public class RetrieveStatisticalProfileExample {

    public RetrieveStatisticalProfileExample() {}


    /*
     * This method uses ConnectToService to login and check out the license to the statistic service.
     * Then it retrieves the statistic profiles as seen under the Option tab,
     * in the stat server application object in Configuration Management.
     *
     * @param targetHost <gis_host>:<gis_port>
     */
    public void execute(String targetHost) throws Exception {

        StatService portStat;
        String statEndPoint = "";
        String[] services = {"GIS_STATSERVICE"};

        ConnectSessionServiceExample cs = new ConnectSessionServiceExample(services);
        cs.execute(targetHost);

        //create a new proxy instance.
        StatServiceServiceLocator service_stat = new StatServiceServiceLocator();
        portStat = service_stat.getStatService();
        statEndPoint = "http://" + targetHost +
"/gis/services/StatService?GISsessionId=" + cs.sid;
//Bind stat address endpoint
        ((StatServiceSoapBindingStub)
portStat)._setProperty(javax.xml.rpc.Stub.ENDPOINT_ADDRESS_PROPERTY,
statEndPoint);


        //---------------------------------------------------------------
        //Retrieve statistical profiles request
        //---------------------------------------------------------------

        RetrieveStatisticalProfileResponse statistic_profile = portStat.retrieveStatisticalProfile("", StatisticalProfileType.statisticalProfile);
        System.out.println("retrieving statistic profiles.....");

 	ProfileInfo info = statistic_profile.getStatisticalProfileInfo();
        StatisticTypeInfoType[] types = info.getStatisticInfos();
        for (int i = 0; i < types.length; i++) {
            StatisticTypeInfoType infoType = types[i];
            System.out.print(infoType.getTypeName() + "( " + infoType.getType().getValue() + ") ->");
            for (int j = 0; j < infoType.getObjectTypes().length; j++) {
                ObjectType type = infoType.getObjectTypes()[j];
                System.out.print(": " + type.getValue());
            }
            System.out.println("\n----");
        }

        //retrieve filter names
        RetrieveStatisticalProfileResponse filterProfile = portStat.retrieveStatisticalProfile("", StatisticalProfileType.filterProfile);
        System.out.println("retrieving filter profiles.....");

	ProfileInfo info1 = filterProfile.getStatisticalProfileInfo();
        Parameter[] filter = info1.getFilters();
        if (filter != null)
          for (int i =0;i<filter.length; i++)
           System.out.println("Key= " + filter[i].getKey() + "  Value= " + filter[i].getValue());

        //retrieve time profile names
        RetrieveStatisticalProfileResponse time_profile = portStat.retrieveStatisticalProfile("", StatisticalProfileType.timeProfile);
        System.out.println("retrieving time profiles.....");

	ProfileInfo info2 = time_profile.getStatisticalProfileInfo();
        TimeProfile[] timeProf = info2.getTimeProfiles();
        if (timeProf != null)
         for (int i =0;i<timeProf.length; i++){
           System.out.print("Key = " + timeProf[i].getKey() + "  Value = " + timeProf[i].getValue());
           System.out.println("  time interval = " + timeProf[i].getIntervalType().getValue());
        }

        //retrieve time range names
        RetrieveStatisticalProfileResponse timeRangeProfile = portStat.retrieveStatisticalProfile("", StatisticalProfileType.timeRangeProfile);
 	System.out.println("retrieving time range profiles.....");

        ProfileInfo info3 = time_profile.getStatisticalProfileInfo();
        Parameter[] timeRange = info3.getTimeRanges();
        if (timeRange != null)
          for (int i =0;i<timeRange.length; i++)
           System.out.println("Key = " + timeRange[i].getKey() + "  Value = " + timeRange[i].getValue());

        System.out.println("logging out of session...");

        //logout request
        cs.port.logout(cs.sid);
    }

    //Standalone option to test run this example. Creates a new instance of this object and starts the process
    public static void main(String[] args) {
    	String gisHost = PropertiesLoader.getOption("gis.host");
		String gisPort = PropertiesLoader.getOption("gis.port");
        try {
            RetrieveStatisticalProfileExample example = new RetrieveStatisticalProfileExample();
            example.execute(gisHost+":"+gisPort);
        } catch (Exception serviceException) {
            System.out.println("error occured: " + serviceException.getMessage());
        }
    }
}