/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.log;

import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.ILoggerFactory;
import com.genesyslab.platform.commons.log.NullLoggerFactoryImpl;
import com.genesyslab.platform.commons.util.PsdkVersionInfo;

public final class Log {
    private static final String LOG_FACTORY_PROPERTY = "com.genesyslab.platform.commons.log.loggerFactory";
    private static final String LOG_FACTORY_DEBUG = "com.genesyslab.platform.commons.log.debug";
    private static ILoggerFactory loggerFactory = null;
    private static boolean areJarsVersionsPrinted;

    private Log() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ILogger getLogger(String name) {
        ILogger log = null;
        ILoggerFactory lFactory = Log.getLoggerFactory();
        try {
            log = lFactory.getLogger(name);
        }
        catch (Throwable e) {
            if (System.getProperty(LOG_FACTORY_DEBUG) != null) {
                System.err.print("Exception creating logger: ");
                System.err.println(e.toString());
            }
        }
        finally {
            if (log == null) {
                log = new NullLoggerFactoryImpl().getLogger(name);
            }
        }
        return log;
    }

    public static ILogger getDataLogger() {
        return Log.getLogger("PSDK.DATA");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ILogger getLogger(Class clazz) {
        ILogger log = null;
        ILoggerFactory lFactory = Log.getLoggerFactory();
        try {
            log = lFactory.getLogger(clazz);
        }
        catch (Throwable e) {
            if (System.getProperty(LOG_FACTORY_DEBUG) != null) {
                System.err.print("Exception creating logger: ");
                System.err.println(e.toString());
            }
        }
        finally {
            if (log == null) {
                log = new NullLoggerFactoryImpl().getLogger(clazz);
            }
        }
        return log;
    }

    public static synchronized void setLoggerFactory(ILoggerFactory factory) {
        if (factory != null) {
            ILogger logger;
            boolean debug;
            ILoggerFactory loggerFactoryOld = loggerFactory;
            boolean bl = debug = System.getProperty(LOG_FACTORY_DEBUG) != null && factory != loggerFactory;
            if (debug && loggerFactoryOld != null) {
                logger = loggerFactoryOld.getLogger(Log.class);
                Log.logCallStack("Changing logger factory to " + factory + " from " + loggerFactoryOld, logger);
            }
            loggerFactory = factory;
            if (debug) {
                logger = factory.getLogger(Log.class);
                Log.logCallStack("Changed logger factory to " + factory + " from " + loggerFactoryOld, logger);
            }
            Log.printPSDKVersions();
        }
    }

    private static void logCallStack(String info, ILogger logger) {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        StringBuilder sb = new StringBuilder(8192);
        sb.append(info);
        sb.append("\n [CALLSTACK]\n");
        int i = 2;
        for (StackTraceElement e : elements) {
            if (i-- > 0) continue;
            sb.append("  ");
            sb.append(e.getFileName());
            sb.append('[');
            sb.append(e.getLineNumber());
            sb.append("] ");
            sb.append(e.getClassName());
            sb.append('.');
            sb.append(e.getMethodName());
            if (e.isNativeMethod()) {
                sb.append(" {native}");
            }
            sb.append('\n');
        }
        logger.info(sb);
    }

    public static String getCallStackInfo() {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        StringBuilder sb = new StringBuilder(8192);
        sb.append("[CALLSTACK]\n");
        int i = 2;
        for (StackTraceElement e : elements) {
            if (i-- > 0) continue;
            sb.append("  ");
            sb.append(e.getFileName());
            sb.append('[');
            sb.append(e.getLineNumber());
            sb.append("] ");
            sb.append(e.getClassName());
            sb.append('.');
            sb.append(e.getMethodName());
            if (e.isNativeMethod()) {
                sb.append(" {native}");
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    private static synchronized ILoggerFactory getLoggerFactory() {
        if (loggerFactory == null) {
            Log.setLoggerFactory(new NullLoggerFactoryImpl());
        }
        return loggerFactory;
    }

    private static void initLoggerFactory() {
        block3: {
            try {
                Object instance;
                String factoryClassName = System.getProperty(LOG_FACTORY_PROPERTY);
                if (factoryClassName != null && (instance = Class.forName(factoryClassName).newInstance()) instanceof ILoggerFactory) {
                    ILoggerFactory loggerFactory = (ILoggerFactory)instance;
                    ILogger logger = loggerFactory.getLogger(Log.class);
                    logger.info("Logger factory is changing according to system property com.genesyslab.platform.commons.log.loggerFactory=" + factoryClassName);
                    Log.setLoggerFactory(loggerFactory);
                }
            }
            catch (Throwable e) {
                if (System.getProperty(LOG_FACTORY_DEBUG) == null) break block3;
                System.err.println("Troubles initializing logger system");
                e.printStackTrace();
            }
        }
    }

    private static void printPSDKVersions() {
        ILogger logger;
        if (!areJarsVersionsPrinted && (logger = Log.getLogger(Log.class)).isInfo()) {
            logger.info("Checking PSDK jars versions:");
            for (String[] version : PsdkVersionInfo.getJarsVersions()) {
                logger.infoFormat("PSDK jar in the classpath: {0} of {1} ({2} by {3})", version);
            }
            areJarsVersionsPrinted = true;
        }
    }

    static {
        try {
            Log.initLoggerFactory();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        areJarsVersionsPrinted = false;
    }
}

