/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.log;

import com.genesyslab.platform.commons.log.AbstractLogger;
import com.genesyslab.platform.commons.log.ILogger;
import java.text.MessageFormat;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Log4JLoggerImpl
extends AbstractLogger {
    private Logger impl;

    public Log4JLoggerImpl(Logger impl) {
        this.impl = impl;
    }

    public boolean isDebug() {
        return this.impl.isDebugEnabled();
    }

    public boolean isInfo() {
        return this.impl.isInfoEnabled();
    }

    public boolean isError() {
        return this.impl.isEnabledFor(Priority.ERROR);
    }

    public boolean isFatalError() {
        return this.impl.isEnabledFor(Priority.FATAL);
    }

    public boolean isWarn() {
        return this.impl.isEnabledFor(Priority.WARN);
    }

    public ILogger createChildLogger(String name) {
        StringBuffer newName = new StringBuffer(this.impl.getName());
        newName.append('.').append(name);
        return new Log4JLoggerImpl(Logger.getLogger((String)newName.toString()));
    }

    protected void log(Object message, Throwable e, AbstractLogger.Level level) {
        Priority priority = Log4JLoggerImpl.getPriority(level);
        this.impl.log(priority, message, e);
    }

    protected void logArgs(String message, Object args, AbstractLogger.Level level) {
        Priority priority = Log4JLoggerImpl.getPriority(level);
        Object[] argsArray = args instanceof Object[] ? (Object[])args : new Object[]{args};
        String formatedMsg = MessageFormat.format(message, argsArray);
        this.impl.log(priority, (Object)formatedMsg);
    }

    private static Priority getPriority(AbstractLogger.Level level) {
        if (level == AbstractLogger.Level.DEBUG) {
            return Priority.DEBUG;
        }
        if (level == AbstractLogger.Level.INFO) {
            return Priority.INFO;
        }
        if (level == AbstractLogger.Level.ERROR) {
            return Priority.ERROR;
        }
        if (level == AbstractLogger.Level.FATAL_ERROR) {
            return Priority.FATAL;
        }
        if (level == AbstractLogger.Level.WARN) {
            return Priority.WARN;
        }
        return Priority.DEBUG;
    }
}

