/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.management;

import com.genesyslab.platform.commons.management.PSDKJMXException;
import com.genesyslab.platform.commons.management.PSDKManagementFactory;

public abstract class PSDKMBeanBase {
    public static final String DOMAIN_GENESYS_PLATFORM_SDK = "com.genesyslab.platform";
    private final String objMBDomain;
    private final String objMBType;
    private final String objMBName;
    private final String objMBextra;
    private volatile Object mbeanNameId = null;
    private volatile Object mbeanId = null;

    protected PSDKMBeanBase(String mbType, String mbName, Integer mbUID) {
        this(DOMAIN_GENESYS_PLATFORM_SDK, mbType, mbName, mbUID != null ? "id=" + mbUID.toString() : null);
    }

    protected PSDKMBeanBase(String mbDomain, String mbType, String mbName, String mbExt) {
        this.objMBDomain = mbDomain;
        this.objMBType = mbType;
        this.objMBName = mbName;
        this.objMBextra = mbExt;
    }

    public final String getMBeanDomain() {
        return this.objMBDomain;
    }

    public final String getMBeanType() {
        return this.objMBType;
    }

    public final String getMBeanName() {
        return this.objMBName;
    }

    public final String getMBeanNameExtraKeys() {
        return this.objMBextra;
    }

    final Object getMBeanNameId() {
        return this.mbeanNameId;
    }

    public void initialize() {
    }

    public void register() {
        this.doRegisterMBean();
    }

    public void unregister() {
        this.doUnregisterMBean();
    }

    protected final synchronized boolean createMBeanNameId() {
        if (this.mbeanNameId == null) {
            this.mbeanNameId = PSDKManagementFactory.createMBeanName(this);
        }
        return this.mbeanNameId != null;
    }

    protected final synchronized boolean doRegisterMBean() {
        if (this.mbeanId != null) {
            throw new PSDKJMXException("Object is already registered");
        }
        if (this.createMBeanNameId()) {
            this.mbeanId = PSDKManagementFactory.registerMBean(this);
        }
        return this.mbeanId != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final synchronized boolean doUnregisterMBean() {
        if (this.mbeanId != null) {
            try {
                boolean bl = PSDKManagementFactory.unregisterMBean(this.mbeanId);
                return bl;
            }
            finally {
                this.mbeanId = null;
            }
        }
        return false;
    }

    public synchronized boolean isRegistered() {
        return this.mbeanId != null;
    }

    public String toString() {
        String value = "PSDKMBean(" + this.getClass().getName() + ")";
        if (this.objMBDomain != null) {
            value = value + this.objMBDomain;
        }
        if (this.objMBType != null) {
            value = value + ",type=" + this.objMBType;
        }
        if (this.objMBName != null && !this.objMBName.equals("")) {
            value = value + ",name=\"" + this.objMBName + "\"";
        }
        if (this.objMBextra != null && !this.objMBextra.equals("")) {
            value = value + "," + this.objMBextra;
        }
        return value;
    }
}

