/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.util;

import java.util.Date;

public class UnixTimeConverter {
    public static Date fromUnixTimeToDateTime(long seconds, long usecs) {
        long time = seconds * 1000L;
        return new Date(time += usecs / 1000L);
    }

    public static Date fromUnixTimeToDateTime(UnixTime unixTime) {
        if (unixTime == null) {
            throw new NullPointerException("null times are not accepted");
        }
        return UnixTimeConverter.fromUnixTimeToDateTime(unixTime.seconds, unixTime.usecs);
    }

    public static UnixTime fromDateTimeToUnixTime(Date date) {
        long millis = date.getTime();
        long seconds = millis / 1000L;
        long usecs = millis % 1000L * 1000L;
        return new UnixTime(seconds, usecs);
    }

    public static class UnixTime {
        private long seconds;
        private long usecs;

        public UnixTime(long secondss, long usecs) {
            this.seconds = secondss;
            this.usecs = usecs;
        }

        public long getSeconds() {
            return this.seconds;
        }

        public long getUsecs() {
            return this.usecs;
        }
    }
}

