/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.collections.runtime.processor;

import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.KeyValuePair;
import com.genesyslab.platform.commons.collections.ValueType;
import com.genesyslab.platform.commons.collections.processor.KeyValueIndenter;
import com.genesyslab.platform.commons.collections.processor.KeyValueOutputFilter;
import com.genesyslab.platform.commons.collections.runtime.processor.CopyOutputFilter;
import com.genesyslab.platform.commons.collections.runtime.processor.HideFirstOutputFilter;
import com.genesyslab.platform.commons.collections.runtime.processor.HideLastOutputFilter;
import com.genesyslab.platform.commons.collections.runtime.processor.HideOutputFilter;
import com.genesyslab.platform.commons.collections.runtime.processor.SkipOutputFilter;
import com.genesyslab.platform.commons.collections.runtime.processor.TKVPrinterContext;
import com.genesyslab.platform.commons.collections.runtime.processor.TruncateOutputFilter;
import com.genesyslab.platform.commons.collections.runtime.processor.UnhideFirstOutputFilter;
import com.genesyslab.platform.commons.collections.runtime.processor.UnhideLastOutputFilter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;

public class KeyValueFilterSet {
    public static KeyValueFilterSet DEFAULT_FILTERS = new KeyValueFilterSet();
    private Map<String, KeyValueOutputFilter> filters = new HashMap<String, KeyValueOutputFilter>();
    private TKVPrinterContext context = new TKVPrinterContext(this);
    private KeyValueOutputFilter copyFilter;
    private KeyValueOutputFilter skipFilter;
    private KeyValueOutputFilter hideFilter;
    private KeyValueOutputFilter truncateFilter;

    private KeyValueFilterSet() {
    }

    public KeyValueFilterSet(KeyValueCollection options, KeyValueCollection data) {
        this.parseOptions(options);
        this.parseData(data);
    }

    private void parseData(KeyValueCollection data) {
        if (data == null) {
            return;
        }
        for (KeyValuePair pair : data) {
            String key = pair.getStringKey();
            Object value = pair.getValue();
            KeyValueOutputFilter impl = null;
            if (value instanceof String) {
                impl = this.createFilter(pair.getStringValue(), null);
            } else if (value instanceof KeyValueCollection) {
                KeyValueCollection kvData = (KeyValueCollection)value;
                impl = kvData.containsKey("filter-name") ? this.createFilter(kvData.getString("filter-name"), kvData) : this.createCustomFilter(kvData);
            }
            if (impl == null) continue;
            this.filters.put(key, impl);
        }
    }

    public void addCustomFilter(String key, KeyValueOutputFilter filter) {
        this.filters.put(key, filter);
    }

    private void parseOptions(KeyValueCollection options) {
        if (options == null) {
            return;
        }
        String defFilterName = options.getString("default-filter-type");
        KeyValueOutputFilter filter = null;
        filter = "custom-filter".equals(defFilterName) ? this.createCustomFilter(options) : this.createFilter(defFilterName, null);
        if (filter != null) {
            this.context.setDefaultFilter(filter);
        }
        this.context.setTruncateThreshold(options.getInt("truncate-threshold"));
        if (options.containsKey("hide-first-count")) {
            this.context.setHideFirstCharactersCount(options.getInt("hide-first-count"));
        }
        if (options.containsKey("hide-last-count")) {
            this.context.setHideLastCharactersCount(options.getInt("hide-last-count"));
        }
        if (options.containsKey("unhide-first-count")) {
            this.context.setUnhideFirstCharactersCount(options.getInt("unhide-first-count"));
        }
        if (options.containsKey("unhide-last-count")) {
            this.context.setUnhideLastCharactersCount(options.getInt("unhide-last-count"));
        }
    }

    private KeyValueOutputFilter createCustomFilter(KeyValueCollection options) {
        if (options == null) {
            return null;
        }
        String filterType = options.getString("custom-filter-type");
        if (filterType == null || filterType.equals("")) {
            throw new RuntimeException("No filter type specified for custom filter");
        }
        Class<?> filterClass = null;
        KeyValueOutputFilter customFilter = null;
        try {
            filterClass = Class.forName(this.getClass().getPackage().getName() + "." + filterType);
        }
        catch (ClassNotFoundException ex) {
            try {
                filterClass = Class.forName(filterType);
            }
            catch (ClassNotFoundException ex2) {
                throw new RuntimeException("Can't find class for custom filter type '" + filterType + "'");
            }
        }
        if (filterClass != null) {
            try {
                customFilter = (KeyValueOutputFilter)filterClass.newInstance();
            }
            catch (Exception ex) {
                throw new RuntimeException("Exception on create custom filter from '" + filterClass.getName() + "'", ex);
            }
        }
        if (customFilter != null) {
            KeyValueCollection filterOptions = options.getList("custom-filter-options");
            customFilter.configure(filterOptions);
        }
        return customFilter;
    }

    private KeyValueOutputFilter createFilter(String filterName, KeyValueCollection config) {
        if (filterName == null) {
            return null;
        }
        if ("copy".equals(filterName)) {
            return this.getCopyFilter();
        }
        if ("truncate".equals(filterName)) {
            return this.getTruncateFilter();
        }
        if ("hide".equals(filterName)) {
            return this.getHideFilter();
        }
        if ("skip".equals(filterName)) {
            return this.getSkipFilter();
        }
        if (filterName.startsWith("hide-first")) {
            return this.getHideFirstFilter(filterName, config);
        }
        if (filterName.startsWith("hide-last")) {
            return this.getHideLastFilter(filterName, config);
        }
        if (filterName.startsWith("unhide-first")) {
            return this.getUnhideFirstFilter(filterName, config);
        }
        if (filterName.startsWith("unhide-last")) {
            return this.getUnhideLastFilter(filterName, config);
        }
        return null;
    }

    private KeyValueOutputFilter getHideFirstFilter(String filterName, KeyValueCollection options) {
        int cnt = -1;
        String[] str = filterName.split("\\s*,\\s*");
        if (str.length >= 2) {
            cnt = Integer.parseInt(str[1]);
        } else if (options != null && options.containsKey("hide-first-count")) {
            cnt = options.getInt("hide-first-count");
        }
        return new HideFirstOutputFilter(cnt);
    }

    private KeyValueOutputFilter getHideLastFilter(String filterName, KeyValueCollection options) {
        int cnt = -1;
        String[] str = filterName.split("\\s*,\\s*");
        if (str.length >= 2) {
            cnt = Integer.parseInt(str[1]);
        } else if (options != null && options.containsKey("hide-last-count")) {
            cnt = options.getInt("hide-last-count");
        }
        return new HideLastOutputFilter(cnt);
    }

    private KeyValueOutputFilter getUnhideFirstFilter(String filterName, KeyValueCollection options) {
        int cnt = -1;
        String[] str = filterName.split("\\s*,\\s*");
        if (str.length >= 2) {
            cnt = Integer.parseInt(str[1]);
        } else if (options != null && options.containsKey("unhide-first-count")) {
            cnt = options.getInt("unhide-first-count");
        }
        return new UnhideFirstOutputFilter(cnt);
    }

    private KeyValueOutputFilter getUnhideLastFilter(String filterName, KeyValueCollection options) {
        int cnt = -1;
        String[] str = filterName.split("\\s*,\\s*");
        if (str.length >= 2) {
            cnt = Integer.parseInt(str[1]);
        } else if (options != null && options.containsKey("unhide-last-count")) {
            cnt = options.getInt("unhide-last-count");
        }
        return new UnhideLastOutputFilter(cnt);
    }

    private KeyValueOutputFilter getCopyFilter() {
        if (this.copyFilter == null) {
            this.copyFilter = new CopyOutputFilter();
        }
        return this.copyFilter;
    }

    private KeyValueOutputFilter getTruncateFilter() {
        if (this.truncateFilter == null) {
            this.truncateFilter = new TruncateOutputFilter();
        }
        return this.truncateFilter;
    }

    private KeyValueOutputFilter getHideFilter() {
        if (this.hideFilter == null) {
            this.hideFilter = new HideOutputFilter();
        }
        return this.hideFilter;
    }

    private KeyValueOutputFilter getSkipFilter() {
        if (this.skipFilter == null) {
            this.skipFilter = new SkipOutputFilter();
        }
        return this.skipFilter;
    }

    public void filterPair(StringBuffer buf, KeyValuePair pair) {
        if (pair.getValueType() == ValueType.WIDE_STRING) {
            this.filterPair(buf, pair.getStringKey(), pair.getStringValue());
        } else {
            this.filterPair(buf, pair.getStringKey(), pair.getValue());
        }
    }

    private KeyValueOutputFilter getFilter(String key) {
        KeyValueOutputFilter filter = this.filters.get(key);
        if (filter == null) {
            filter = this.context.getDefaultFilter();
        }
        return filter;
    }

    public StringBuffer filterList(StringBuffer buff, KeyValueCollection list) {
        return this.filterList(buff, list, 1);
    }

    public StringBuffer filterList(StringBuffer buff, KeyValueCollection list, int indent) {
        StringBuffer buf = buff;
        if (buf == null) {
            buf = new StringBuffer();
        }
        buf.append("KVList: ");
        if (list == null) {
            buf.append("null");
        } else {
            this.processKeyValueTree(buf, list);
        }
        return buf;
    }

    public void filterPair(StringBuffer buf, String key, Object value) {
        this.checkValueType(value);
        KeyValueOutputFilter filter = this.getFilter(key);
        if (!filter.isFilteredOut(key, value, this.context)) {
            String rest = filter.appendKeyValuePair(buf, key, value, this.context);
            if (value instanceof KeyValueCollection) {
                if (this.context.getIndenter() != null) {
                    this.context.getIndenter().increaseIndent();
                }
                this.processKeyValueTree(buf, (KeyValueCollection)value);
                if (this.context.getIndenter() != null) {
                    this.context.getIndenter().decreaseIndent();
                }
            }
            if (rest != null) {
                buf.append(rest);
            }
        }
    }

    private void processKeyValueTree(StringBuffer buf, KeyValueCollection list) {
        if (list != null) {
            Stack<KVTreeOutputState> stack = new Stack<KVTreeOutputState>();
            KVTreeOutputState currentState = new KVTreeOutputState(list.iterator(), null);
            while (currentState != null) {
                KeyValuePair pair = currentState.getNext();
                if (pair == null) {
                    if (currentState.strRest != null) {
                        buf.append(currentState.strRest);
                    }
                    if (stack.empty()) {
                        currentState = null;
                        continue;
                    }
                    currentState = (KVTreeOutputState)stack.pop();
                    if (this.context.getIndenter() == null) continue;
                    this.context.getIndenter().decreaseIndent();
                    continue;
                }
                if (pair.getValue() instanceof KeyValueCollection) {
                    if (pair.getValue() == list) {
                        KeyValueIndenter indenter = this.context.getIndenter();
                        if (indenter != null) {
                            indenter.appendIndent(buf);
                        }
                        buf.append("'");
                        buf.append(pair.getStringKey());
                        buf.append("' [lst] = KVList: (this KeyValueCollection)");
                        continue;
                    }
                    String key = pair.getStringKey();
                    KeyValueCollection value = (KeyValueCollection)pair.getValue();
                    KeyValueOutputFilter filter = this.getFilter(key);
                    if (filter.isFilteredOut(key, value, this.context)) continue;
                    String rest = filter.appendKeyValuePair(buf, key, value, this.context);
                    stack.push(currentState);
                    currentState = new KVTreeOutputState(value.iterator(), rest);
                    if (this.context.getIndenter() == null) continue;
                    this.context.getIndenter().increaseIndent();
                    continue;
                }
                this.filterPair(buf, pair);
            }
        }
    }

    private void checkValueType(Object value) {
        if (value == null || value instanceof String || value instanceof Integer || value instanceof byte[] || value instanceof KeyValueCollection) {
            return;
        }
        throw new IllegalArgumentException("Type " + value.getClass().getName() + " is not supported by KeyValuePrinter");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KVTreeOutputState {
        Iterator<?> iterator;
        String strRest;

        KVTreeOutputState(Iterator<?> iterator, String rest) {
            this.iterator = iterator;
            this.strRest = rest;
        }

        KeyValuePair getNext() {
            if (this.iterator != null && this.iterator.hasNext()) {
                return (KeyValuePair)this.iterator.next();
            }
            return null;
        }
    }
}

