/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.collections.util;

public class Hex {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final int TRUNCATE_BYTES_LEN = 256;

    public static byte[] decodeHex(char[] data) throws RuntimeException {
        int len = data.length;
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = Hex.toDigit(data[j], j) << 4;
            f |= Hex.toDigit(data[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    protected static int toDigit(char ch, int index) throws RuntimeException {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new RuntimeException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }

    public static char[] encodeHex(byte[] data) {
        return Hex.encodeHex(data, 0, data.length);
    }

    public static char[] encodeHex(byte[] data, int offset, int len) {
        int l = len;
        if (l > data.length - offset) {
            l = data.length - offset;
        }
        char[] out = new char[l << 1];
        int endIndex = l + offset;
        int j = 0;
        for (int i = offset; i < endIndex; ++i) {
            out[j++] = DIGITS[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS[0xF & data[i]];
        }
        return out;
    }

    public static void appendBytesStr(StringBuffer buf, byte[] bytes) {
        Hex.appendBytesStr(buf, bytes, false);
    }

    public static void appendBytesStr(StringBuffer buf, byte[] bytes, boolean truncate) {
        Hex.appendBytesStr(buf, bytes, truncate, 256);
    }

    public static void appendBytesStr(StringBuffer buf, byte[] bytes, boolean truncate, int truncateThreshold) {
        char[] hex = truncate && bytes.length > truncateThreshold ? Hex.encodeHex(bytes, 0, truncateThreshold) : Hex.encodeHex(bytes);
        int len = hex.length;
        for (int i = 0; i < len; i += 2) {
            if (i % 20 == 0) {
                buf.append("\n\t  ");
            }
            buf.append(' ').append('0').append('x').append(hex[i]).append(hex[i + 1]);
        }
        if (truncate && bytes.length > truncateThreshold) {
            int remaining = bytes.length - truncateThreshold;
            buf.append("\n\t   ... [output truncated, total ").append(remaining).append(" bytes left]");
        }
    }

    public static void appendBytesStr(StringBuilder buf, byte[] bytes, boolean truncate) {
        Hex.appendBytesStr(buf, bytes, truncate, 256);
    }

    public static void appendBytesStr(StringBuilder buf, byte[] bytes, boolean truncate, int truncateThreshold) {
        char[] hex = truncate && bytes.length > truncateThreshold ? Hex.encodeHex(bytes, 0, truncateThreshold) : Hex.encodeHex(bytes);
        int len = hex.length;
        for (int i = 0; i < len; i += 2) {
            if (i % 20 == 0) {
                buf.append("\n\t  ");
            }
            buf.append(' ').append('0').append('x').append(hex[i]).append(hex[i + 1]);
        }
        if (truncate && bytes.length > truncateThreshold) {
            int remaining = bytes.length - truncateThreshold;
            buf.append("\n\t   ... [output truncated, total ").append(remaining).append(" bytes left]");
        }
    }
}

