/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.management.protocol.localcontrolagentheartbeat.runtime;

public final class ThreadLiveInfo
implements Cloneable {
    private long osID;
    private int threadClass;
    private int heartbeatCounter;
    private int flags;
    private String logicID;

    public ThreadLiveInfo(long threadId, String threadName, int threadClass) {
        this.osID = threadId;
        this.logicID = threadName;
        this.threadClass = threadClass;
        this.heartbeatCounter = (int)(System.currentTimeMillis() / 1000L);
    }

    public void setThreadClass(int threadClass) {
        this.threadClass = threadClass;
    }

    public int getThreadClass() {
        return this.threadClass;
    }

    public long getOsID() {
        return this.osID;
    }

    public void setHeartbeatCounter(int heartbeatCounter) {
        this.heartbeatCounter = heartbeatCounter;
    }

    public int getHeartbeatCounter() {
        return this.heartbeatCounter;
    }

    public void setFlag(int flag) {
        this.flags |= flag;
    }

    public void unsetFlag(int flag) {
        this.flags &= ~flag;
    }

    public boolean checkFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    public void setDeleteCounter(int value) {
        this.flags = value << 4 & 0xF0 | this.flags & 0xFFFFFF0F;
    }

    public int getDeleteCounter() {
        return (this.flags & 0xF0) >> 4;
    }

    public int getFlags() {
        return this.flags;
    }

    public String getLogicID() {
        return this.logicID;
    }

    public ThreadLiveInfo clone() {
        ThreadLiveInfo copy = null;
        try {
            copy = (ThreadLiveInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return copy;
    }

    public String toString() {
        return "ThreadLiveInfo['" + this.logicID + "',id=" + this.osID + ",class=" + this.threadClass + ",flags=" + this.flags + ",cnt=" + this.heartbeatCounter + "]";
    }
}

