/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.management.protocol.messageserver;

import com.genesyslab.platform.commons.protocol.AbstractProtocolFactory;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.ProtocolDescription;
import com.genesyslab.platform.management.protocol.messageserver.events.EventError;
import com.genesyslab.platform.management.protocol.messageserver.events.EventLogMessage;
import com.genesyslab.platform.management.protocol.messageserver.events.EventSubscription;
import com.genesyslab.platform.management.protocol.messageserver.requests.RequestLogMessage;
import com.genesyslab.platform.management.protocol.messageserver.requests.subscription.RequestSubscribeAll;
import com.genesyslab.platform.management.protocol.messageserver.requests.subscription.RequestSubscribeType;
import com.genesyslab.platform.management.protocol.messageserver.requests.subscription.RequestSubscribeTypeKey;
import com.genesyslab.platform.management.protocol.messageserver.requests.subscription.RequestUnsubscribeAll;
import com.genesyslab.platform.management.protocol.messageserver.requests.subscription.RequestUnsubscribeType;
import com.genesyslab.platform.management.protocol.messageserver.requests.subscription.RequestUnsubscribeTypeKey;

public class MessageServerProtocolFactory
extends AbstractProtocolFactory {
    public static final ProtocolDescription PROTOCOL_DESCRIPTION = new ProtocolDescription("Management", "MessageServer");

    public ProtocolDescription getProtocolDescription() {
        return PROTOCOL_DESCRIPTION;
    }

    public String getProtocolVersion() {
        return "7.6.000";
    }

    protected Message createRequest(int id) {
        switch (id) {
            case 201: {
                return RequestSubscribeAll.create();
            }
            case 202: {
                return RequestSubscribeType.create();
            }
            case 203: {
                return RequestSubscribeTypeKey.create();
            }
            case 250: {
                return RequestUnsubscribeAll.create();
            }
            case 251: {
                return RequestUnsubscribeType.create();
            }
            case 252: {
                return RequestUnsubscribeTypeKey.create();
            }
            case 1101: {
                return RequestLogMessage.create();
            }
        }
        return null;
    }

    protected Message createEvent(int id) {
        switch (id) {
            case -1: {
                return EventSubscription.create();
            }
            case 104: {
                return EventError.create();
            }
            case 11101: {
                return EventLogMessage.create();
            }
        }
        return null;
    }

    protected String getEventMessageName(int id) {
        switch (id) {
            case -1: {
                return "EventSubscription";
            }
            case 104: {
                return "EventError";
            }
            case 11101: {
                return "EventLogMessage";
            }
        }
        return "";
    }

    protected String getRequestMessageName(int id) {
        switch (id) {
            case 201: {
                return "RequestSubscribeAll";
            }
            case 202: {
                return "RequestSubscribeType";
            }
            case 203: {
                return "RequestSubscribeTypeKey";
            }
            case 250: {
                return "RequestUnsubscribeAll";
            }
            case 251: {
                return "RequestUnsubscribeType";
            }
            case 252: {
                return "RequestUnsubscribeTypeKey";
            }
            case 1101: {
                return "RequestLogMessage";
            }
        }
        return "";
    }

    public String getMessageName(int id) {
        String name = this.getEventMessageName(id);
        if (name != null && !name.equals("")) {
            return name;
        }
        name = this.getRequestMessageName(id);
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Protocol doesn't support message #" + id);
        }
        return name;
    }

    public Message createMessage(int id) {
        Message message = this.createEvent(id);
        if (message != null) {
            return message;
        }
        message = this.createRequest(id);
        if (message != null) {
            return message;
        }
        throw new IllegalArgumentException("Protocol doesn't support message #" + id);
    }

    public Message createMessage(int id, String name) {
        if (name == null || name.equals("")) {
            return this.createMessage(id);
        }
        Message message = null;
        message = name.startsWith("Event") ? this.createEvent(id) : this.createRequest(id);
        if (message == null) {
            throw new IllegalArgumentException("Protocol doesn't support message #" + id);
        }
        return message;
    }
}

