/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.management.protocol.messageserver.runtime.codec;

import com.genesyslab.platform.commons.PlatformException;
import com.genesyslab.platform.commons.connection.MessageTransport;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.runtime.AttributeDescription;
import com.genesyslab.platform.commons.protocol.runtime.DataSupport;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecException;
import com.genesyslab.platform.commons.protocol.runtime.codec.CustomPackager;
import com.genesyslab.platform.commons.protocol.runtime.codec.CustomTypeCodec;
import com.genesyslab.platform.commons.protocol.runtime.codec.DateCodec;
import com.genesyslab.platform.commons.util.UnixTimeConverter;
import java.util.Date;
import javax.xml.transform.Result;
import javax.xml.transform.Source;

public class UnixTimeCodec
implements CustomTypeCodec,
CustomPackager {
    private static final String USEC_ATTR_ID = "inner.16";
    private static final String TIME_ATTR_ID = "inner.1";
    private static final String TIME_ATTR_NAME = "Time";
    private Message message;
    private long timeSec = -1L;
    private long timeUsec = -1L;
    private final DateCodec dateCodec = new DateCodec();

    public void setProtocolData(Object protocolData) {
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public Object encodeForConnection(Object customTypeObject, String id, MessageTransport transport, Object transportState) throws PlatformException {
        if (customTypeObject instanceof Date) {
            Date date = (Date)customTypeObject;
            UnixTimeConverter.UnixTime unixTime = UnixTimeConverter.fromDateTimeToUnixTime((Date)date);
            transport.onAttribute(transportState, TIME_ATTR_ID, (int)unixTime.getSeconds());
            transport.onAttribute(transportState, USEC_ATTR_ID, (int)unixTime.getUsecs());
        }
        return transportState;
    }

    public String getNS() {
        return null;
    }

    public void encodeToXml(Object customTypeObject, Result attributeElement) throws CodecException {
        this.dateCodec.encodeToXml(customTypeObject, attributeElement);
    }

    public Object decodeFromXml(Source attributeElement, AttributeDescription attributeDescription) throws CodecException {
        return this.dateCodec.decodeFromXml(attributeElement, attributeDescription);
    }

    public String getLogType() {
        return "str";
    }

    public void appendLogValue(StringBuffer buf, Object customTypeObject, boolean truncate, boolean hide) throws CodecException {
        this.dateCodec.appendLogValue(buf, customTypeObject, truncate, hide);
    }

    public void onMessageStart(Message message) {
        this.setMessage(message);
    }

    public void onAttribute(String id, Object value) throws CodecException {
        if (TIME_ATTR_ID.equals(id)) {
            if (value instanceof Long) {
                this.timeSec = (Long)value;
            } else if (value instanceof Integer) {
                this.timeSec = ((Integer)value).longValue();
            }
        } else if (USEC_ATTR_ID.equals(id)) {
            if (value instanceof Long) {
                this.timeUsec = (Long)value;
            } else if (value instanceof Integer) {
                this.timeUsec = ((Integer)value).longValue();
            }
        }
    }

    public void onMessageEnd() throws CodecException {
        if (this.timeSec > 0L) {
            Date date = UnixTimeConverter.fromUnixTimeToDateTime((long)this.timeSec, (long)this.timeUsec);
            ((DataSupport)this.message).attributes().put(TIME_ATTR_NAME, date);
        }
    }
}

