/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.applicationblocks.com.cache;

import com.genesyslab.platform.applicationblocks.com.ICfgObject;
import com.genesyslab.platform.applicationblocks.com.ICfgQuery;
import com.genesyslab.platform.applicationblocks.com.cache.IConfCacheQueryEngine;
import com.genesyslab.platform.configuration.protocol.types.CfgObjectType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompositeConfCacheQueryEngine
implements IConfCacheQueryEngine {
    private final List<IConfCacheQueryEngine> queryEngines = new ArrayList<IConfCacheQueryEngine>();

    @Override
    public boolean canExecute(ICfgQuery query) {
        for (IConfCacheQueryEngine queryEngine : this.queryEngines) {
            if (!queryEngine.canExecute(query)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T extends ICfgObject> T retrieveObject(Class<T> cls, ICfgQuery query) {
        for (IConfCacheQueryEngine queryEngine : this.queryEngines) {
            if (!queryEngine.canExecute(query)) continue;
            return queryEngine.retrieveObject(cls, query);
        }
        throw new IllegalArgumentException("Unsupported query");
    }

    @Override
    public <T extends ICfgObject> Collection<T> retrieveMultipleObjects(Class<T> cls, ICfgQuery query) {
        for (IConfCacheQueryEngine queryEngine : this.queryEngines) {
            if (!queryEngine.canExecute(query)) continue;
            return queryEngine.retrieveMultipleObjects(cls, query);
        }
        throw new IllegalArgumentException("Unsupported query");
    }

    @Override
    public <T extends ICfgObject> T retrieveObject(Class<T> cls, CfgObjectType type, int dbid) {
        T obj = null;
        for (IConfCacheQueryEngine queryEngine : this.queryEngines) {
            try {
                obj = queryEngine.retrieveObject(cls, type, dbid);
            }
            catch (Exception e) {
                continue;
            }
            if (obj == null) continue;
            break;
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(IConfCacheQueryEngine queryEngine) {
        List<IConfCacheQueryEngine> list = this.queryEngines;
        synchronized (list) {
            this.queryEngines.add(queryEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(IConfCacheQueryEngine queryEngine) {
        List<IConfCacheQueryEngine> list = this.queryEngines;
        synchronized (list) {
            this.queryEngines.remove(queryEngine);
        }
    }
}

