/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.applicationblocks.com.cache;

import com.genesyslab.platform.applicationblocks.com.ConfEvent;
import com.genesyslab.platform.applicationblocks.com.ConfServiceFactory;
import com.genesyslab.platform.applicationblocks.com.ConfigException;
import com.genesyslab.platform.applicationblocks.com.ConfigRuntimeException;
import com.genesyslab.platform.applicationblocks.com.ICfgBriefInfo;
import com.genesyslab.platform.applicationblocks.com.ICfgDelta;
import com.genesyslab.platform.applicationblocks.com.ICfgObject;
import com.genesyslab.platform.applicationblocks.com.ICfgQuery;
import com.genesyslab.platform.applicationblocks.com.IConfService;
import com.genesyslab.platform.applicationblocks.com.cache.CacheKey;
import com.genesyslab.platform.applicationblocks.com.cache.ConfCacheEvent;
import com.genesyslab.platform.applicationblocks.com.cache.ConfCacheUpdateType;
import com.genesyslab.platform.applicationblocks.com.cache.DefaultConfCachePolicy;
import com.genesyslab.platform.applicationblocks.com.cache.DefaultConfCacheQueryEngine;
import com.genesyslab.platform.applicationblocks.com.cache.DefaultConfCacheStorage;
import com.genesyslab.platform.applicationblocks.com.cache.IConfCache;
import com.genesyslab.platform.applicationblocks.com.cache.IConfCachePolicy;
import com.genesyslab.platform.applicationblocks.com.cache.IConfCacheQueryEngine;
import com.genesyslab.platform.applicationblocks.com.cache.IConfCacheStorage;
import com.genesyslab.platform.applicationblocks.commons.Action;
import com.genesyslab.platform.applicationblocks.commons.Predicate;
import com.genesyslab.platform.applicationblocks.commons.broker.BrokerService;
import com.genesyslab.platform.applicationblocks.commons.broker.Subscriber;
import com.genesyslab.platform.applicationblocks.commons.broker.SubscriptionService;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.AsyncInvokerSupport;
import com.genesyslab.platform.commons.protocol.Endpoint;
import com.genesyslab.platform.commons.threading.AsyncInvoker;
import com.genesyslab.platform.commons.xmlfactory.XmlFactories;
import com.genesyslab.platform.configuration.protocol.ConfServerProtocol;
import com.genesyslab.platform.configuration.protocol.types.CfgObjectType;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultConfCache
implements IConfCache,
SubscriptionService<ConfCacheEvent>,
AsyncInvokerSupport {
    private IConfCachePolicy policy;
    private IConfCacheQueryEngine queryEngine;
    private IConfCacheStorage storage;
    private List<Endpoint> endpoints = new ArrayList<Endpoint>();
    private BrokerService<ConfCacheEvent> brokerService;
    private AsyncInvoker invoker = null;
    private static DocumentBuilder documentBuilder = null;
    private static Transformer transformer = null;
    private static XPath xpath = null;
    private static final String CONFIG_NS = ConfServerProtocol.PROTOCOL_DESCRIPTION.getNS();
    private static final String CACHE_NS = "http://schemas.genesyslab.com/Protocols/Configuration/COMCache/2009/";
    private static ILogger log = Log.getLogger(DefaultConfCache.class);

    public DefaultConfCache() {
        this(null, null, null);
    }

    public DefaultConfCache(IConfCachePolicy cachePolicy, IConfCacheStorage cacheStorage, IConfCacheQueryEngine cacheQueryEngine) {
        this.queryEngine = cacheQueryEngine;
        this.policy = cachePolicy;
        this.storage = cacheStorage;
        if (this.policy == null) {
            this.policy = new DefaultConfCachePolicy();
        }
        if (this.storage == null) {
            this.storage = new DefaultConfCacheStorage();
        }
        if (this.queryEngine == null) {
            this.queryEngine = new DefaultConfCacheQueryEngine(this.storage);
        }
        this.brokerService = new BrokerService();
    }

    public void setInvoker(AsyncInvoker value) {
        this.invoker = value;
    }

    private void performRefresh() throws ConfigException, InterruptedException {
        for (ICfgObject obj : this.storage.retrieve(ICfgObject.class)) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            obj.refresh();
        }
    }

    private void onObjectUpdated(ConfEvent configEvent) throws ConfigException {
        if (this.queryEngine == null) {
            log.warn((Object)"Unable to update cached objects without QueryEngine initialized");
            return;
        }
        ICfgObject obj = this.queryEngine.retrieveObject(ICfgObject.class, configEvent.getObjectType(), configEvent.getObjectId());
        if (obj != null && this.policy.getTrackUpdates(obj)) {
            try {
                obj.update((ICfgDelta)((Object)configEvent.getCfgObject()));
                if (this.policy.getReturnCopies()) {
                    obj = (ICfgObject)obj.clone();
                }
                this.publish(new ConfCacheEvent(obj, ConfCacheUpdateType.ObjectUpdated));
            }
            catch (Exception ex) {
                log.error((Object)"Exception performing update of cached object", (Throwable)ex);
            }
        }
    }

    private void onObjectDeleted(ConfEvent configEvent) {
        if (!configEvent.isUnsolicited()) {
            return;
        }
        ICfgObject obj = this.retrieve(ICfgObject.class, configEvent.getObjectType(), configEvent.getObjectId());
        if (obj != null && this.policy.getRemoveOnDelete(obj)) {
            this.remove(obj);
        }
    }

    private void onObjectCreated(ConfEvent configEvent) {
        if (configEvent == null || configEvent.getCfgObject() == null) {
            throw new IllegalArgumentException("Expected 'ConfEvent' with CfgObject attached");
        }
        if (configEvent.isUnsolicited() && this.policy.getCacheOnCreate(configEvent.getCfgObject())) {
            this.add(configEvent.getCfgObject());
        }
    }

    private void publish(ConfCacheEvent event) {
        if (this.invoker != null) {
            this.invoker.invoke((Runnable)new AsyncCacheEventPublisher(event));
        } else {
            this.brokerService.publish((Object)event);
        }
    }

    private void validate(ICfgObject obj) {
        if (obj == null) {
            throw new NullPointerException("obj");
        }
        if (obj instanceof ICfgBriefInfo) {
            throw new IllegalArgumentException("BriefInfo structures are not to be stored in cache.");
        }
        if (!this.endpoints.contains(obj.getEndpoint())) {
            throw new IllegalArgumentException("The specified object does not belong to a configuration server supported by this cache.");
        }
    }

    public int getEndpointCount() {
        return this.endpoints.size();
    }

    public void addEndpoint(Endpoint endpoint) {
        Endpoint existing = null;
        for (Endpoint ep : this.endpoints) {
            if (ep == null || !ep.equals((Object)endpoint)) continue;
            existing = ep;
            break;
        }
        if (existing == null) {
            this.endpoints.add(endpoint);
        }
    }

    public boolean removeEndpoint(Endpoint endpoint) {
        Endpoint existing = null;
        for (Endpoint ep : this.endpoints) {
            if (ep == null || !ep.equals((Object)endpoint)) continue;
            existing = ep;
            break;
        }
        if (existing == null) {
            this.endpoints.remove(existing);
            return true;
        }
        return false;
    }

    @Override
    public void add(ICfgObject obj) {
        this.validate(obj);
        this.storage.add(obj);
        this.publish(new ConfCacheEvent(obj, ConfCacheUpdateType.ObjectAdded));
    }

    @Override
    public void update(ICfgObject obj) {
        this.validate(obj);
        this.storage.update(obj);
        this.publish(new ConfCacheEvent(obj, ConfCacheUpdateType.ObjectUpdated));
    }

    @Override
    public void remove(ICfgObject obj) {
        if (obj == null) {
            throw new NullPointerException("obj");
        }
        if (obj instanceof ICfgBriefInfo) {
            throw new IllegalArgumentException("BriefInfo structures are not to be stored in cache.");
        }
        if (this.storage.remove(obj)) {
            this.publish(new ConfCacheEvent(obj, ConfCacheUpdateType.ObjectRemoved));
        }
    }

    @Override
    public void remove(CfgObjectType type, int dbid) {
        for (ICfgObject obj : this.storage.retrieve(ICfgObject.class, new CacheKey(type, dbid))) {
            if (obj.getObjectDbid() != dbid || obj.getObjectType() != type) continue;
            this.remove(obj);
            break;
        }
    }

    @Override
    public <T extends ICfgObject> T retrieve(Class<T> cls, CfgObjectType type, int dbid) {
        if (this.queryEngine == null) {
            throw new IllegalArgumentException("A query engine has not been specified for the cache.");
        }
        T obj = this.queryEngine.retrieveObject(cls, type, dbid);
        if (obj != null && this.policy.getReturnCopies()) {
            return (T)this.createClone((ICfgObject)obj);
        }
        return obj;
    }

    @Override
    public <T extends ICfgObject> T retrieve(Class<T> cls, ICfgQuery query) {
        if (this.queryEngine == null) {
            throw new IllegalArgumentException("A query engine has not been specified for the cache.");
        }
        T obj = this.queryEngine.retrieveObject(cls, query);
        if (obj != null && this.policy.getReturnCopies()) {
            return (T)this.createClone((ICfgObject)obj);
        }
        return obj;
    }

    @Override
    public <T extends ICfgObject> Iterable<T> retrieveMultiple(Class<T> cls, ICfgQuery query) {
        if (this.queryEngine == null) {
            throw new IllegalArgumentException("A query engine has not been specified for the cache.");
        }
        return this.queryEngine.retrieveMultipleObjects(cls, query);
    }

    @Override
    public <T extends ICfgObject> Iterable<T> retrieveMultiple(Class<T> cls) {
        return this.storage.retrieve(cls);
    }

    public void serialize(OutputStream stream) {
        this.serialize(new StreamResult(stream));
    }

    @Override
    public void serialize(Result result) {
        try {
            Document doc = documentBuilder.newDocument();
            Element nodeRoot = doc.createElementNS(CACHE_NS, "Cache");
            Element nodeCacheConf = doc.createElementNS(CACHE_NS, "CacheConfiguration");
            Element nodeCacheData = doc.createElementNS(CONFIG_NS, "ConfData");
            doc.appendChild(nodeRoot);
            nodeRoot.appendChild(nodeCacheConf);
            nodeRoot.appendChild(nodeCacheData);
            this.serializeCacheConfig(nodeCacheConf);
            this.serializeCacheData(nodeCacheData);
            transformer.transform(new DOMSource(nodeRoot), result);
        }
        catch (Exception e) {
            throw new ConfigRuntimeException("Can't serialize cache", e);
        }
    }

    private void serializeCacheConfig(Node container) {
        for (Endpoint ep : this.endpoints) {
            if (ep.getName() == null || ep.getUri() == null) continue;
            Document doc = container.getOwnerDocument();
            Element child = doc.createElementNS(container.getNamespaceURI(), "ConfigurationServer");
            Attr attr = doc.createAttribute("name");
            attr.setValue(ep.getName());
            child.getAttributes().setNamedItem(attr);
            attr = doc.createAttribute("uri");
            attr.setValue(ep.getUri().toString());
            child.getAttributes().setNamedItem(attr);
            container.appendChild(child);
        }
    }

    private void deserializeCacheConfig(NodeList options) throws XPathExpressionException, URISyntaxException {
        if (options != null) {
            for (int i = 0; i < options.getLength(); ++i) {
                Node item = options.item(i);
                if (!item.getNodeName().equals("ConfigurationServer")) continue;
                Node a1 = item.getAttributes().getNamedItem("name");
                Node a2 = item.getAttributes().getNamedItem("uri");
                Endpoint ep = new Endpoint(a1.getNodeValue(), new URI(a2.getNodeValue()));
                this.endpoints.add(ep);
            }
        }
    }

    private void serializeCacheData(Node node) {
        if (this.storage != null) {
            Document doc = node.getOwnerDocument();
            for (ICfgObject obj : this.storage.retrieve(ICfgObject.class)) {
                Node child = doc.adoptNode(obj.toXml());
                if (child == null) continue;
                node.appendChild(child);
            }
        }
    }

    public void deserialize(InputStream stream) {
        this.deserialize(new StreamSource(stream));
    }

    @Override
    public void deserialize(Source source) {
        try {
            if (source instanceof StreamSource) {
                Document doc = documentBuilder.parse(((StreamSource)source).getInputStream());
                this.deserialize(doc);
            } else {
                DOMResult result = new DOMResult(documentBuilder.newDocument());
                transformer.transform(source, result);
                this.deserialize(result.getNode());
            }
        }
        catch (Exception e) {
            throw new ConfigRuntimeException("Can't deserialize cache", e);
        }
    }

    protected void deserialize(Node source) {
        try {
            Endpoint ep;
            IConfService confService = null;
            this.deserializeCacheConfig((NodeList)xpath.evaluate("cache:Cache/cache:CacheConfiguration/*", source, XPathConstants.NODESET));
            Iterator<Endpoint> i$ = this.endpoints.iterator();
            while (i$.hasNext() && (confService = ConfServiceFactory.retrieveConfService(ep = i$.next())) == null) {
            }
            Node data = (Node)xpath.evaluate("cache:Cache/cfg:ConfData", source, XPathConstants.NODE);
            if (data != null && confService != null) {
                for (ICfgObject obj : confService.createMultipleObjectsFromXML(data)) {
                    this.add(obj);
                }
            }
        }
        catch (Exception e) {
            throw new ConfigRuntimeException("Can't deserialize cache", e);
        }
    }

    @Override
    public void clear() {
        this.storage.clear();
    }

    @Override
    public void refresh() throws ConfigException, InterruptedException {
        this.performRefresh();
    }

    @Override
    public Future<IConfCache> beginRefresh(AsyncInvoker asyncInvoker, Action<Future<IConfCache>> finishCallback) {
        if (asyncInvoker == null) {
            throw new NullPointerException("AsyncInvoker");
        }
        AsyncRefresh asyncRefresh = new AsyncRefresh(finishCallback);
        asyncInvoker.invoke((Runnable)asyncRefresh);
        return asyncRefresh;
    }

    @Override
    public void endRefresh(Future<IConfCache> asyncResult) {
        if (!(asyncResult instanceof AsyncRefresh)) {
            throw new IllegalArgumentException("asyncResult");
        }
        try {
            asyncResult.get();
        }
        catch (Exception e) {
            log.error((Object)"Exception waiting for async refresh done");
        }
    }

    @Override
    public IConfCachePolicy getPolicy() {
        return this.policy;
    }

    public void setPolicy(IConfCachePolicy cachePolicy) {
        this.policy = cachePolicy;
    }

    @Override
    public boolean contains(ICfgObject obj) {
        if (obj == null) {
            throw new NullPointerException("obj");
        }
        if (obj instanceof ICfgBriefInfo) {
            throw new IllegalArgumentException("BriefInfo structures are not to be stored in cache.");
        }
        return this.retrieve(ICfgObject.class, obj.getObjectType(), obj.getObjectDbid()) != null;
    }

    public void register(Subscriber<ConfCacheEvent> subscriber) {
        this.brokerService.register(subscriber);
    }

    public void register(Action<ConfCacheEvent> handler, Predicate<ConfCacheEvent> filter) {
        this.brokerService.register(handler, filter);
    }

    public void unregister(Subscriber<ConfCacheEvent> subscriber) {
        this.brokerService.unregister(subscriber);
    }

    public void unregister(Action<ConfCacheEvent> handler) {
        this.brokerService.unregister(handler);
    }

    public Predicate<ConfEvent> getFilter() {
        return null;
    }

    public void handle(ConfEvent configEvent) {
        try {
            if (configEvent.getEventType() == ConfEvent.EventType.ObjectCreated) {
                this.onObjectCreated(configEvent);
            } else if (configEvent.getEventType() == ConfEvent.EventType.ObjectDeleted) {
                this.onObjectDeleted(configEvent);
            } else if (configEvent.getEventType() == ConfEvent.EventType.ObjectUpdated) {
                this.onObjectUpdated(configEvent);
            }
        }
        catch (ConfigException ex) {
            log.error((Object)"Exception handling ConfEvent", (Throwable)ex);
        }
    }

    private ICfgObject createClone(ICfgObject obj) {
        try {
            return (ICfgObject)obj.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new ConfigRuntimeException("Exception clonning object from cache", e);
        }
    }

    static {
        try {
            documentBuilder = XmlFactories.newDocumentBuilderNS();
            transformer = XmlFactories.newTransformer();
            xpath = XmlFactories.newXPath();
            xpath.setNamespaceContext(new NamespaceContext(){

                public String getNamespaceURI(String prefix) {
                    String uri = prefix.equals("cache") || prefix.equals("") ? DefaultConfCache.CACHE_NS : (prefix.equals("cfg") ? CONFIG_NS : null);
                    return uri;
                }

                public Iterator getPrefixes(String val) {
                    return null;
                }

                public String getPrefix(String uri) {
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.error((Object)"Exception initializing XML engine", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AsyncRefresh
    implements Future<IConfCache>,
    Runnable {
        private Action<Future<IConfCache>> callback;
        private boolean done = false;
        private boolean canceled = false;
        private Exception exception = null;
        private final Object syncObj = new Object();

        AsyncRefresh(Action<Future<IConfCache>> finishCallback) {
            this.callback = finishCallback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            Object object = this.syncObj;
            synchronized (object) {
                this.canceled = true;
                return this.canceled;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isCancelled() {
            Object object = this.syncObj;
            synchronized (object) {
                return this.canceled;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isDone() {
            Object object = this.syncObj;
            synchronized (object) {
                return this.done;
            }
        }

        @Override
        public IConfCache get() throws InterruptedException, ExecutionException {
            try {
                return this.get(0L, null);
            }
            catch (TimeoutException e) {
                log.error((Object)"Timeout waiting for sync refresh", (Throwable)e);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IConfCache get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            Object object = this.syncObj;
            synchronized (object) {
                long actTimeout = timeout;
                if (unit != null) {
                    actTimeout = unit.toMillis(timeout);
                }
                if (actTimeout > 0L) {
                    long timeoutMark = System.currentTimeMillis() + actTimeout;
                    long waitTime = actTimeout;
                    while (!this.done) {
                        this.syncObj.wait(waitTime);
                        waitTime = timeoutMark - System.currentTimeMillis();
                        if (waitTime > 0L) continue;
                        break;
                    }
                } else {
                    while (!this.done) {
                        this.syncObj.wait();
                    }
                }
                if (this.done) {
                    if (this.exception == null) {
                        return DefaultConfCache.this;
                    }
                    throw new ExecutionException(this.exception);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                for (ICfgObject obj : DefaultConfCache.this.storage.retrieve(ICfgObject.class)) {
                    if (this.canceled || Thread.currentThread().isInterrupted()) {
                        throw new InterruptedException();
                    }
                    obj.refresh();
                }
            }
            catch (Exception ex) {
                this.exception = ex;
                log.error((Object)"Exception while Cache.refresh()", (Throwable)ex);
            }
            finally {
                Object object = this.syncObj;
                synchronized (object) {
                    this.done = true;
                    if (this.callback != null) {
                        try {
                            this.callback.handle((Object)this);
                        }
                        catch (Exception e) {
                            log.error((Object)"Exception in custom handler", (Throwable)e);
                        }
                    }
                    this.syncObj.notifyAll();
                }
            }
        }
    }

    private class AsyncCacheEventPublisher
    implements Runnable {
        private ConfCacheEvent theEvent;

        AsyncCacheEventPublisher(ConfCacheEvent event) {
            this.theEvent = event;
        }

        public void run() {
            DefaultConfCache.this.brokerService.publish((Object)this.theEvent);
        }
    }

    private static interface SerializationConstants {
        public static final String CACHE_NODE = "Cache";
        public static final String CONFIGURATION_NODE = "CacheConfiguration";
        public static final String CONFIGURATION_SERVER_NODE = "ConfigurationServer";
        public static final String CONFIGURATION_DATA_NODE = "ConfData";
        public static final String NAME_ATTRIBUTE = "name";
        public static final String URI_ATTRIBUTE = "uri";
    }
}

