/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.applicationblocks.com.cache;

import com.genesyslab.platform.applicationblocks.com.ICfgObject;
import com.genesyslab.platform.applicationblocks.com.cache.CacheKey;
import com.genesyslab.platform.applicationblocks.com.cache.IConfCacheStorage;
import com.genesyslab.platform.configuration.protocol.types.CfgObjectType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultConfCacheStorage
implements IConfCacheStorage {
    private Hashtable<CfgObjectType, Hashtable<Integer, ICfgObject>> objects = new Hashtable();
    private ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();

    void enterReadLock() {
        this.rwLock.readLock().lock();
    }

    void enterWriteLock() {
        this.rwLock.writeLock().lock();
    }

    void exitReadLock() {
        this.rwLock.readLock().unlock();
    }

    void exitWriteLock() {
        this.rwLock.writeLock().unlock();
    }

    @Override
    public void add(ICfgObject obj) {
        this.add(obj, false);
    }

    @Override
    public void update(ICfgObject obj) {
        this.add(obj, true);
    }

    private void add(ICfgObject obj, boolean replaceOldCopy) {
        if (obj == null) {
            throw new NullPointerException("obj");
        }
        CfgObjectType type = obj.getObjectType();
        Integer dbid = obj.getObjectDbid();
        if (dbid == 0) {
            throw new IllegalArgumentException("The passed object has not been saved in Configuration Server.");
        }
        this.enterWriteLock();
        Hashtable<Integer, ICfgObject> objList = this.objects.get(type);
        boolean alreadyInList = false;
        if (objList != null) {
            alreadyInList = objList.containsKey(dbid);
        } else {
            objList = new Hashtable();
            this.objects.put(type, objList);
        }
        if (alreadyInList) {
            if (!replaceOldCopy) {
                this.exitWriteLock();
                throw new IllegalArgumentException("Object already in cache.");
            }
            objList.put(dbid, obj);
        } else {
            objList.put(dbid, obj);
        }
        this.exitWriteLock();
    }

    @Override
    public boolean remove(ICfgObject obj) {
        CfgObjectType type = obj.getObjectType();
        Integer dbid = obj.getObjectDbid();
        boolean res = false;
        this.enterWriteLock();
        Hashtable<Integer, ICfgObject> objList = this.objects.get(type);
        if (objList != null) {
            boolean bl = res = objList.remove(dbid) != null;
            if (objList.isEmpty()) {
                this.objects.remove(type);
            }
        }
        this.exitWriteLock();
        return res;
    }

    @Override
    public void clear() {
        this.enterWriteLock();
        this.objects.clear();
        this.exitWriteLock();
    }

    @Override
    public <T extends ICfgObject> Iterable<T> retrieve(Class<T> cls) {
        return new StorageObjectEnumeration<T>(cls, this.objects, null, this);
    }

    @Override
    public <T extends ICfgObject> Iterable<T> retrieve(Class<T> cls, Object helper) {
        return new StorageObjectEnumeration<T>(cls, this.objects, helper, this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StorageObjectEnumeration<T>
    implements Iterable<T> {
        private DefaultConfCacheStorage storage;
        private Hashtable<CfgObjectType, Hashtable<Integer, ICfgObject>> objects;
        private Object helper;
        private Class<T> baseClass;

        StorageObjectEnumeration(Class<T> cls, Hashtable<CfgObjectType, Hashtable<Integer, ICfgObject>> objects, Object helper, DefaultConfCacheStorage storage) {
            if (objects == null) {
                throw new NullPointerException("objects");
            }
            if (storage == null) {
                throw new NullPointerException("storage");
            }
            this.baseClass = cls;
            this.objects = objects;
            this.helper = helper;
            this.storage = storage;
        }

        @Override
        public Iterator<T> iterator() {
            return this.getIteratorInternal();
        }

        private Iterator<T> getIteratorInternal() {
            Collection<T> objectsCol = null;
            if (this.helper == null) {
                objectsCol = this.copyAll();
            } else if (this.helper instanceof CfgObjectType) {
                objectsCol = this.copyByType();
            } else if (this.helper instanceof CacheKey) {
                objectsCol = this.copyByKey();
            }
            if (objectsCol != null) {
                return objectsCol.iterator();
            }
            return null;
        }

        private Collection<T> copyByKey() {
            CacheKey cacheKey = (CacheKey)this.helper;
            ICfgObject obj = null;
            this.storage.enterReadLock();
            Hashtable<Integer, ICfgObject> objs = this.objects.get(cacheKey.getObjectType());
            if (objs != null) {
                obj = objs.get(cacheKey.getObjectDbid());
            }
            this.storage.exitReadLock();
            ArrayList<ICfgObject> objectsCol = new ArrayList<ICfgObject>();
            if (obj != null && this.baseClass.isAssignableFrom(obj.getClass())) {
                objectsCol.add(obj);
            }
            return objectsCol;
        }

        private Collection<T> copyByType() {
            CfgObjectType objType = (CfgObjectType)this.helper;
            ArrayList<ICfgObject> objectsCol = new ArrayList<ICfgObject>();
            this.storage.enterReadLock();
            Hashtable<Integer, ICfgObject> table = this.objects.get(objType);
            if (table != null) {
                for (ICfgObject obj : table.values()) {
                    if (!this.baseClass.isAssignableFrom(obj.getClass())) continue;
                    objectsCol.add(obj);
                }
            }
            this.storage.exitReadLock();
            return objectsCol;
        }

        private Collection<T> copyAll() {
            ArrayList<ICfgObject> objectsCol = new ArrayList<ICfgObject>();
            this.storage.enterReadLock();
            for (Hashtable<Integer, ICfgObject> table : this.objects.values()) {
                if (table == null) continue;
                for (ICfgObject obj : table.values()) {
                    if (!this.baseClass.isAssignableFrom(obj.getClass())) continue;
                    objectsCol.add(obj);
                }
            }
            this.storage.exitReadLock();
            return objectsCol;
        }
    }
}

