/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.applicationblocks.com.capacityrules;

import com.genesyslab.platform.applicationblocks.com.capacityrules.CRAndExprBlock;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRMediaDir;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRMediaMap;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRRuleBlockEntry;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CapacityRuleAbstractElement;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CapacityRuleException;
import com.genesyslab.platform.applicationblocks.com.capacityrules.ICapacityRuleWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CRRuleBody
extends CapacityRuleAbstractElement {
    private CRRuleBlockEntry parent;
    private ArrayList<CRAndExprBlock> list = new ArrayList();

    public CRRuleBody(CRRuleBlockEntry parent) {
        this.parent = parent;
    }

    public CRRuleBody(CRRuleBlockEntry parent, ByteBuffer buf, int positionBase) throws CapacityRuleException {
        this(parent);
        this.read(buf, positionBase);
    }

    ArrayList<CRAndExprBlock> getList() {
        return this.list;
    }

    @Override
    public CRRuleBlockEntry getParent() {
        return this.parent;
    }

    public void add(CRAndExprBlock exprBlock) {
        this.list.add(exprBlock);
    }

    @Override
    public void write(ICapacityRuleWriter writer) {
        int i;
        if (this.list == null) {
            return;
        }
        int count = this.list.size();
        writer.addByte((byte)count);
        int offsetsTable = writer.size();
        for (i = 0; i < count; ++i) {
            writer.addInt(-1);
        }
        for (i = 0; i < count; ++i) {
            CRAndExprBlock elem = this.list.get(i);
            writer.setInt(offsetsTable + i * 4, writer.size());
            if (elem == null) continue;
            elem.write(writer);
        }
    }

    private void read(ByteBuffer buf, int positionBase) throws CapacityRuleException {
        int count = buf.get() & 0xFF;
        for (int index = 0; index < count; ++index) {
            int itemOffset = buf.getInt();
            int posBackup = buf.position();
            try {
                buf.position(positionBase + itemOffset);
            }
            catch (IllegalArgumentException ex) {
                throw new CapacityRuleException("invalid rule body item offset : " + itemOffset + " ( index:" + index + " )");
            }
            CRAndExprBlock item = new CRAndExprBlock(this, buf);
            this.add(item);
            buf.position(posBackup);
        }
    }

    public int hashCode() {
        int hashCode = CRMediaDir.class.hashCode();
        for (CRAndExprBlock entry : this.list) {
            hashCode = hashCode * 31 + entry.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CRRuleBody)) {
            return false;
        }
        CRRuleBody o = (CRRuleBody)obj;
        if (this.list.size() != o.list.size()) {
            return false;
        }
        ArrayList tmp = (ArrayList)o.list.clone();
        block0: for (CRAndExprBlock entry : this.list) {
            int size = tmp.size();
            for (int j = 0; j < size; ++j) {
                CRAndExprBlock entry2 = (CRAndExprBlock)tmp.get(j);
                if (!entry.equals(entry2)) continue;
                tmp.remove(j);
                continue block0;
            }
            return false;
        }
        return true;
    }

    public CRMediaMap getMap() {
        return this.parent == null ? null : this.parent.getMap();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OR");
        sb.append('(');
        for (CRAndExprBlock expr : this.list) {
            sb.append(expr);
            sb.append(',');
        }
        if (!this.list.isEmpty()) {
            sb.setLength(sb.length() - 1);
        }
        sb.append(')');
        return sb.toString();
    }
}

