/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.applicationblocks.com.capacityrules;

import com.genesyslab.platform.applicationblocks.com.capacityrules.CRHeader;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRMediaDir;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRMediaDirEntry;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRMediaMap;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRRuleBlock;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRRuleBlockEntry;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRXmlUtils;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CapacityRuleException;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CapacityRuleInternalFactory;
import com.genesyslab.platform.applicationblocks.com.capacityrules.EnterElementArgs;
import com.genesyslab.platform.applicationblocks.com.capacityrules.ICapacityRuleFactory;
import com.genesyslab.platform.applicationblocks.com.capacityrules.ICapacityRuleProcessElement;
import com.genesyslab.platform.applicationblocks.com.capacityrules.ICapacityRuleReader;
import com.genesyslab.platform.applicationblocks.com.capacityrules.ICapacityRuleWriter;
import com.genesyslab.platform.applicationblocks.com.capacityrules.MediaRule;
import com.genesyslab.platform.applicationblocks.com.capacityrules.OnMediaRuleChanged;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CapacityRule {
    private static final ILogger log = Log.getLogger(CapacityRule.class);
    private ICapacityRuleReader reader;
    private ICapacityRuleWriter writer;
    private Document document;
    private OnMediaRuleChanged onRuleChanged;
    private CRHeader header;
    private byte[] binaryData;

    private CapacityRule(Document document) {
        this.document = document;
    }

    byte[] getBinaryData() {
        return this.binaryData;
    }

    HashMap<String, Integer> getSimpleMediaMap() {
        return this.header == null ? null : this.header.getSimpleMediaMap();
    }

    public static CapacityRule createFromXML(Document document) throws CapacityRuleException {
        return CapacityRule.createFromXML(document, null, null);
    }

    static CapacityRule createFromXML(Document document, ICapacityRuleFactory factory, OnMediaRuleChanged onChanged) throws CapacityRuleException {
        if (factory == null) {
            factory = new CapacityRuleInternalFactory();
        }
        CapacityRule rule = new CapacityRule(document);
        rule.reader = factory.getReader();
        rule.writer = factory.getWriter();
        rule.onRuleChanged = onChanged;
        rule.create();
        return rule;
    }

    private void create() throws CapacityRuleException {
        this.reader.setSource(this.document);
        this.reader.registerProcessElement(new ICapacityRuleProcessElement(){

            public void onProcessElement(Object sender, Object args) throws CapacityRuleException {
                String localName;
                EnterElementArgs eArgs;
                Element elem;
                if (args instanceof EnterElementArgs && (elem = (eArgs = (EnterElementArgs)args).getElement()) != null && (localName = CRXmlUtils.getLocalName(elem)).equalsIgnoreCase("CapacityRule")) {
                    CapacityRule.this.header = new CRHeader((ICapacityRuleReader)sender, CapacityRule.this);
                }
            }
        });
        this.reader.process();
        if (this.header != null && this.writer != null) {
            this.header.write(this.writer);
            this.binaryData = this.writer.getBuffer();
        }
    }

    public String toString() {
        return this.header != null ? this.header.toString() : "";
    }

    OnMediaRuleChanged getOnRuleChanged() {
        return this.onRuleChanged;
    }

    public boolean validate() {
        if (this.header == null) {
            log.error((Object)"No header");
            return false;
        }
        CRMediaMap mediaMap = this.header.getMediaMap();
        if (mediaMap == null) {
            log.error((Object)"No mediamap");
            return false;
        }
        CRMediaDir mediaDir = this.header.getMediaDir();
        if (mediaDir == null) {
            log.warn((Object)"No mediaDir");
            return false;
        }
        List<CRMediaDirEntry> mediaDirEntries = mediaDir.getEntries();
        if (mediaDirEntries == null) {
            log.error((Object)"Error in media dir entry");
            return false;
        }
        for (CRMediaDirEntry entry : mediaDirEntries) {
            CRRuleBlock ruleBlock = entry.getRuleBlock();
            if (ruleBlock == null) {
                log.errorFormat("Error in rule block: {1}", (Object)entry);
                return false;
            }
            List<CRRuleBlockEntry> ruleBlockRntries = ruleBlock.getEntries();
            if (ruleBlockRntries == null) {
                log.errorFormat("Error in rule block entry: {1}", (Object)ruleBlock);
                return false;
            }
            for (CRRuleBlockEntry blockEntry : ruleBlockRntries) {
                MediaRule mediaRule = blockEntry.getMediaRule();
                if (mediaRule == null) {
                    log.errorFormat("Error in media rule: {1}", (Object)ruleBlock);
                    return false;
                }
                if (log.isDebug()) {
                    log.debugFormat("checking rule {1}", (Object)mediaRule);
                }
                if (mediaRule.validateRule(mediaMap)) continue;
                return false;
            }
        }
        return true;
    }
}

