/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.applicationblocks.com.capacityrules;

import com.genesyslab.platform.applicationblocks.com.ConfigException;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRHeader;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CapacityRule;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CapacityRuleException;
import com.genesyslab.platform.applicationblocks.com.capacityrules.ValidationResult;
import com.genesyslab.platform.applicationblocks.com.objects.CfgScript;
import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.xmlfactory.XmlFactories;
import com.genesyslab.platform.configuration.protocol.types.CfgScriptType;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class CapacityRuleHelper {
    static final String WizardKey = "_WIZARD_";
    static final String MediaRulesKey = "_CRWizardMediaCapacityList_";
    static final String GuiPresentationKey = "_CRWizardGUIPresentation_";
    static final String BinaryPresentationKey = "_CRWizardBinaryPresentation_";
    private Document document;
    private byte[] bytesData;
    private CfgScript script;
    private final Object lockObject = new Object();
    private boolean enabledValidation;
    private ValidationResult validationResult = ValidationResult.Unknown;

    private CapacityRuleHelper(CfgScript cfgScript, Document doc, byte[] binaryPresentation) {
        this.script = cfgScript;
        this.document = doc;
        this.bytesData = binaryPresentation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.lockObject;
        synchronized (object) {
            return this.document == null || this.bytesData == null || this.bytesData.length == 0;
        }
    }

    public boolean isEnabledValidation() {
        return this.enabledValidation;
    }

    public void setEnabledValidation(boolean enabledValidation) {
        this.enabledValidation = enabledValidation;
    }

    public ValidationResult getValidationResult() {
        return this.validationResult;
    }

    public static boolean matchBinaries(byte[] capacityRulesBinary1, byte[] capacityRulesBinary2) throws CapacityRuleException {
        if (capacityRulesBinary1 == null) {
            throw new IllegalArgumentException("capacityRulesBinary1 is null");
        }
        if (capacityRulesBinary2 == null) {
            throw new IllegalArgumentException("capacityRulesBinary2 is null");
        }
        CRHeader h1 = new CRHeader(capacityRulesBinary1);
        CRHeader h2 = new CRHeader(capacityRulesBinary2);
        return h1.match(h2);
    }

    public boolean matchBinaries(byte[] capacityRulesBinary) throws CapacityRuleException {
        if (this.bytesData == null) {
            throw new IllegalStateException("internal binary capacity rule presentation is null");
        }
        if (capacityRulesBinary == null) {
            throw new IllegalArgumentException("capacityRulesBinary is null");
        }
        CRHeader h1 = new CRHeader(this.bytesData);
        CRHeader h2 = new CRHeader(capacityRulesBinary);
        return h1.match(h2);
    }

    public static boolean equalsBinaries(byte[] capacityRulesBinary1, byte[] capacityRulesBinary2) throws CapacityRuleException {
        if (capacityRulesBinary1 == null) {
            throw new IllegalArgumentException("capacityRulesBinary1 is null");
        }
        if (capacityRulesBinary2 == null) {
            throw new IllegalArgumentException("capacityRulesBinary2 is null");
        }
        CRHeader h1 = new CRHeader(capacityRulesBinary1);
        CRHeader h2 = new CRHeader(capacityRulesBinary2);
        return h1.equals(h2);
    }

    public boolean equalsBinaries(byte[] capacityRulesBinary) throws CapacityRuleException {
        if (this.bytesData == null) {
            throw new IllegalStateException("internal binary capacity rule presentation is null");
        }
        if (capacityRulesBinary == null) {
            throw new IllegalArgumentException("capacityRulesBinary is null");
        }
        CRHeader h1 = new CRHeader(this.bytesData);
        CRHeader h2 = new CRHeader(capacityRulesBinary);
        return h1.equals(h2);
    }

    public static byte[] getBinaryFromXML(Document doc) throws CapacityRuleException {
        CapacityRule cr = CapacityRule.createFromXML(doc);
        return cr.getBinaryData();
    }

    public static byte[] getBinaryFromXML(String xml) throws CapacityRuleException {
        Document doc;
        try {
            doc = XmlFactories.newDocumentBuilderNS().parse(new ByteArrayInputStream(xml.getBytes("UTF-8")));
        }
        catch (Exception e) {
            throw new CapacityRuleException("Problem parsing xml", e);
        }
        return CapacityRuleHelper.getBinaryFromXML(doc);
    }

    public static CapacityRuleHelper create(CfgScript script) throws ConfigException {
        KeyValueCollection wizardData;
        if (script == null) {
            throw new IllegalArgumentException("null argument");
        }
        CfgScriptType type = script.getType();
        if (type != CfgScriptType.CFGCapacityRule) {
            throw new IllegalArgumentException("invalid script type: " + (type == null ? "null" : type.name()));
        }
        Document doc = null;
        byte[] binaryPresentation = null;
        KeyValueCollection userProperties = script.getUserProperties();
        if (userProperties != null && (wizardData = userProperties.getList(WizardKey)) != null) {
            binaryPresentation = wizardData.getBinary(BinaryPresentationKey);
            byte[] guiPresentation = wizardData.getBinary(GuiPresentationKey);
            if (guiPresentation != null) {
                DocumentBuilder db;
                String xmlData;
                try {
                    xmlData = new String(guiPresentation, 0, guiPresentation.length - 1, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new ConfigException("CfgScript conatins _CRWizardGUIPresentation_ not in UTF-8 format", e);
                }
                try {
                    db = XmlFactories.newDocumentBuilderNS();
                }
                catch (ParserConfigurationException e) {
                    throw new RuntimeException(e);
                }
                try {
                    doc = db.parse(new ByteArrayInputStream(xmlData.getBytes("UTF-8")));
                }
                catch (Exception e) {
                    throw new ConfigException("CfgScript contains broken _CRWizardGUIPresentation_", e);
                }
            }
        }
        return new CapacityRuleHelper(script, doc, binaryPresentation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getXMLPresentation() {
        Object object = this.lockObject;
        synchronized (object) {
            return this.document == null ? null : (Document)this.document.cloneNode(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setXMLPresentation(Document doc) throws CapacityRuleException {
        Object object = this.lockObject;
        synchronized (object) {
            if (doc == null) {
                this.bytesData = null;
                this.document = null;
                this.validationResult = ValidationResult.Unknown;
                KeyValueCollection userProperties = this.script.getUserProperties();
                if (userProperties != null) {
                    userProperties.remove(MediaRulesKey);
                    KeyValueCollection wizardData = userProperties.getList(WizardKey);
                    if (wizardData != null) {
                        wizardData.remove(GuiPresentationKey);
                        wizardData.remove(BinaryPresentationKey);
                    }
                }
            } else {
                KeyValueCollection wizardData;
                CapacityRule rule = CapacityRule.createFromXML(doc);
                this.validationResult = this.enabledValidation ? (rule.validate() ? ValidationResult.Success : ValidationResult.Failed) : ValidationResult.Unknown;
                this.bytesData = rule.getBinaryData();
                this.document = doc;
                KeyValueCollection userProperties = this.script.getUserProperties();
                if (userProperties == null) {
                    userProperties = new KeyValueCollection();
                    this.script.setUserProperties(userProperties);
                }
                if ((wizardData = userProperties.getList(WizardKey)) == null) {
                    wizardData = new KeyValueCollection();
                    userProperties.remove(WizardKey);
                    userProperties.addList(WizardKey, wizardData);
                }
                wizardData.remove(GuiPresentationKey);
                wizardData.remove(BinaryPresentationKey);
                if (!this.isEmpty()) {
                    HashMap<String, Integer> map;
                    String xml = this.getXMLStringData() + "\u0000";
                    try {
                        wizardData.addBinary(GuiPresentationKey, xml.getBytes("UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                    if (this.bytesData != null) {
                        wizardData.addBinary(BinaryPresentationKey, this.bytesData);
                    }
                    if ((map = rule.getSimpleMediaMap()) != null) {
                        KeyValueCollection mapValues = new KeyValueCollection();
                        for (Map.Entry<String, Integer> entry : map.entrySet()) {
                            mapValues.addInt(entry.getKey(), entry.getValue());
                        }
                        userProperties.remove(MediaRulesKey);
                        userProperties.addList(MediaRulesKey, mapValues);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXMLStringData() {
        try {
            if (this.document == null) {
                return null;
            }
            StringWriter sw = new StringWriter();
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            Object object = this.lockObject;
            synchronized (object) {
                if (this.document == null) {
                    return null;
                }
                transformer.transform(new DOMSource(this.document), new StreamResult(sw));
            }
            return sw.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBinaryPresentation() {
        Object object = this.lockObject;
        synchronized (object) {
            return this.bytesData;
        }
    }

    public CfgScript getCfgScript() {
        return this.script;
    }
}

