/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.applicationblocks.com.capacityrules;

import com.genesyslab.platform.applicationblocks.com.capacityrules.ICapacityRuleWriter;

class CapacityRuleWriter
implements ICapacityRuleWriter {
    private byte[] buffer = new byte[1024];
    private int size;

    private void ensureCapacity(int capacity) {
        if (this.size + capacity < this.buffer.length) {
            return;
        }
        int newSize = this.size * 2;
        byte[] newBuffer = new byte[newSize];
        System.arraycopy(this.buffer, 0, newBuffer, 0, this.size);
        this.buffer = newBuffer;
    }

    public void addByte(byte value) {
        this.ensureCapacity(1);
        this.buffer[this.size++] = value;
    }

    public void setByte(int offset, byte value) {
        this.buffer[offset] = value;
    }

    public void addInt(int value) {
        this.ensureCapacity(4);
        this.buffer[this.size++] = (byte)value;
        this.buffer[this.size++] = (byte)(value >>> 8);
        this.buffer[this.size++] = (byte)(value >>> 16);
        this.buffer[this.size++] = (byte)(value >>> 24);
    }

    public void setInt(int offset, int value) {
        this.buffer[offset++] = (byte)value;
        this.buffer[offset++] = (byte)(value >>> 8);
        this.buffer[offset++] = (byte)(value >>> 16);
        this.buffer[offset] = (byte)(value >>> 24);
    }

    public byte[] getBuffer() {
        byte[] newBuffer = new byte[this.size];
        System.arraycopy(this.buffer, 0, newBuffer, 0, this.size);
        return newBuffer;
    }

    public int size() {
        return this.size;
    }

    public void reset() {
        this.size = 0;
    }
}

