/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.applicationblocks.com.capacityrules;

import com.genesyslab.platform.applicationblocks.com.capacityrules.AbstractRule;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRMediaMap;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRMediaMapEntry;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRRuleBlockEntry;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRRuleBody;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CapacityRuleException;
import com.genesyslab.platform.applicationblocks.com.capacityrules.ComplexCondition;
import org.w3c.dom.Element;

class ElementaryRule
extends AbstractRule {
    private static final int CAPACITY_MIN = 1;
    private static final int CAPACITY_MAX = 255;
    private static final String ATTR_MEDIA = "media";
    private static final String ATTR_CAPACITY = "capacity";
    private String MediaName;
    private int MediaType = -1;
    private int Capacity;

    public ElementaryRule(AbstractRule parent, String mediaName, int mediaType, int capacity) throws CapacityRuleException {
        super(parent);
        if (mediaType < 0 || mediaType > 255) {
            throw new CapacityRuleException("invalid mediaType (0..255) : " + mediaType);
        }
        if (mediaName == null) {
            throw new CapacityRuleException("null media name");
        }
        if (capacity < 1 || capacity > 255) {
            throw new CapacityRuleException("invalid capacity (1..255) : " + capacity);
        }
        this.MediaName = mediaName;
        this.MediaType = mediaType;
        this.Capacity = capacity;
    }

    public ElementaryRule(AbstractRule parent, Element elem) throws CapacityRuleException {
        super(parent);
        this.MediaName = elem.getAttribute(ATTR_MEDIA);
        if (this.MediaName == null) {
            throw new CapacityRuleException("no media name");
        }
        String sCapacity = elem.getAttribute(ATTR_CAPACITY);
        if (sCapacity == null) {
            this.throwInvalidCapacity(sCapacity);
        }
        try {
            int capacity = Integer.parseInt(sCapacity);
            if (capacity < 1 || capacity > 255) {
                this.throwInvalidCapacity(sCapacity);
            }
            this.Capacity = capacity;
        }
        catch (NumberFormatException e) {
            this.throwInvalidCapacity(sCapacity);
        }
    }

    private void throwInvalidCapacity(String val) throws CapacityRuleException {
        throw new CapacityRuleException("Capacity rule XML contains invalid attribute value. Attribute 'capacity', media name ='" + this.MediaName + "' value = '" + val + "'");
    }

    public int getCapacity() {
        return this.Capacity;
    }

    public int getMediaType() {
        return this.MediaType;
    }

    public void assignMediaTypes(CRMediaMap map) throws CapacityRuleException {
        if (this.MediaName == null) {
            this.MediaName = map.getEntries().get(this.MediaType).getMediaName();
            return;
        }
        for (CRMediaMapEntry entry : map.getEntries()) {
            if (!entry.getMediaName().equalsIgnoreCase(this.MediaName)) continue;
            this.MediaType = entry.getMediaType();
            if (this.Capacity > entry.MaxCapacity) {
                entry.MaxCapacity = this.Capacity;
            }
            return;
        }
        if (this.MediaName.equals("")) {
            return;
        }
        throw new CapacityRuleException("CapacityRule process error: Unknown media name: '" + this.MediaName + "'");
    }

    public void expandAny(CRMediaMap map) throws CapacityRuleException {
        if (!this.MediaName.equals("")) {
            return;
        }
        this.invokeOnExpandAnyHandlers(this, map, this.Capacity);
    }

    public boolean calculate(byte[] values) {
        return (values[this.MediaType] & 0xFF) >= this.Capacity;
    }

    public CRRuleBody createBinaryStructure(CRRuleBlockEntry parent) throws CapacityRuleException {
        ComplexCondition compexCond = new ComplexCondition(null, ComplexCondition.ConditionType.OR);
        compexCond.addRule(this);
        return compexCond.createBinaryStructure(parent);
    }

    protected Object clone() throws CloneNotSupportedException {
        ElementaryRule o = (ElementaryRule)super.clone();
        return o;
    }

    public String toString() {
        return this.MediaName + ':' + this.Capacity;
    }

    public static ElementaryRule castOrNull(AbstractRule abstractRule) {
        return abstractRule instanceof ElementaryRule ? (ElementaryRule)abstractRule : null;
    }
}

