/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.applicationblocks.com.runtime;

import com.genesyslab.platform.applicationblocks.com.CfgBase;
import com.genesyslab.platform.applicationblocks.com.runtime.ICollectionsBroker;
import com.genesyslab.platform.applicationblocks.com.runtime.XmlPropertiesHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CfgLinksBroker<T>
implements List<T>,
ICollectionsBroker {
    private boolean initialized = false;
    private String propertyName;
    private List<T> baseCollection = null;
    private CfgBase cfgBase;
    private final Object lockObject = new Object();

    public CfgLinksBroker(CfgBase initCfgBase, String initPropertyName) {
        this.cfgBase = initCfgBase;
        this.propertyName = initPropertyName;
    }

    private void initialize() {
        if (!this.initialized) {
            ArrayList collectionTemp = null;
            try {
                collectionTemp = XmlPropertiesHelper.createLinksList(this.propertyName, this.cfgBase.getMetaData(), this.cfgBase.getConfigurationService(), this.cfgBase.getData());
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
            if (collectionTemp == null) {
                collectionTemp = new ArrayList();
            }
            this.baseCollection = collectionTemp;
            this.initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        Object object = this.lockObject;
        synchronized (object) {
            if (!this.initialized) {
                return;
            }
            this.baseCollection = XmlPropertiesHelper.createLinksList(this.propertyName, this.cfgBase.getMetaData(), this.cfgBase.getConfigurationService(), this.cfgBase.getData());
        }
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        Collection<Integer> linkDBIDs = this.cfgBase.getLinkListCollection(this.propertyName);
        output.append("A collection of DBIDs = ");
        if (linkDBIDs != null) {
            output.append("list of ").append(linkDBIDs.size()).append(" item(s) {\n");
            for (Integer linkDBID : linkDBIDs) {
                output.append("    ").append(linkDBID).append("\n");
            }
            output.append("}");
        } else {
            output.append("NULL");
        }
        return output.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T remove(int index) {
        Object object = this.lockObject;
        synchronized (object) {
            if (!this.initialized) {
                this.initialize();
            }
            T ret = this.baseCollection.remove(index);
            this.cfgBase.setProperty(this.propertyName, this.baseCollection);
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(Object o) {
        Object object = this.lockObject;
        synchronized (object) {
            if (!this.initialized) {
                this.initialize();
            }
            return this.baseCollection.indexOf(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lastIndexOf(Object o) {
        Object object = this.lockObject;
        synchronized (object) {
            if (!this.initialized) {
                this.initialize();
            }
            return this.baseCollection.lastIndexOf(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIterator<T> listIterator() {
        Object object = this.lockObject;
        synchronized (object) {
            if (!this.initialized) {
                this.initialize();
            }
            return this.baseCollection.listIterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIterator<T> listIterator(int index) {
        Object object = this.lockObject;
        synchronized (object) {
            if (!this.initialized) {
                this.initialize();
            }
            return this.baseCollection.listIterator(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        Object object = this.lockObject;
        synchronized (object) {
            if (!this.initialized) {
                this.initialize();
            }
            return this.baseCollection.subList(fromIndex, toIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(T item) {
        Object object = this.lockObject;
        synchronized (object) {
            if (!this.initialized) {
                this.initialize();
            }
            boolean ret = this.baseCollection.add(item);
            this.cfgBase.setProperty(this.propertyName, this.baseCollection);
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> c) {
        Object object = this.lockObject;
        synchronized (object) {
            if (!this.initialized) {
                this.initialize();
            }
            return this.baseCollection.containsAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends T> c) {
        Object object = this.lockObject;
        synchronized (object) {
            if (!this.initialized) {
                this.initialize();
            }
            boolean ret = this.baseCollection.addAll(c);
            this.cfgBase.setProperty(this.propertyName, this.baseCollection);
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        Object object = this.lockObject;
        synchronized (object) {
            if (!this.initialized) {
                this.initialize();
            }
            boolean ret = this.baseCollection.addAll(index, c);
            this.cfgBase.setProperty(this.propertyName, this.baseCollection);
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        Object object = this.lockObject;
        synchronized (object) {
            if (!this.initialized) {
                this.initialize();
            }
            boolean ret = this.baseCollection.removeAll(c);
            this.cfgBase.setProperty(this.propertyName, this.baseCollection);
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        Object object = this.lockObject;
        synchronized (object) {
            if (!this.initialized) {
                this.initialize();
            }
            boolean ret = this.baseCollection.retainAll(c);
            this.cfgBase.setProperty(this.propertyName, this.baseCollection);
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object item) {
        Object object = this.lockObject;
        synchronized (object) {
            if (!this.initialized) {
                this.initialize();
            }
            boolean res = this.baseCollection.remove(item);
            this.cfgBase.setProperty(this.propertyName, this.baseCollection);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.lockObject;
        synchronized (object) {
            if (!this.initialized) {
                this.initialize();
            }
            return this.baseCollection.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        Object object = this.lockObject;
        synchronized (object) {
            if (!this.initialized) {
                this.initialize();
            }
            return this.baseCollection.contains(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lockObject;
        synchronized (object) {
            if (!this.initialized) {
                this.initialize();
            }
            this.baseCollection.clear();
            this.cfgBase.setProperty(this.propertyName, this.baseCollection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(int index) {
        Object object = this.lockObject;
        synchronized (object) {
            if (!this.initialized) {
                this.initialize();
            }
            return this.baseCollection.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T set(int index, T element) {
        Object object = this.lockObject;
        synchronized (object) {
            if (!this.initialized) {
                this.initialize();
            }
            T ret = this.baseCollection.set(index, element);
            this.cfgBase.setProperty(this.propertyName, this.baseCollection);
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, T element) {
        Object object = this.lockObject;
        synchronized (object) {
            if (!this.initialized) {
                this.initialize();
            }
            this.baseCollection.add(index, element);
            this.cfgBase.setProperty(this.propertyName, this.baseCollection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.lockObject;
        synchronized (object) {
            if (!this.initialized) {
                this.initialize();
            }
            return this.baseCollection.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<T> iterator() {
        Object object = this.lockObject;
        synchronized (object) {
            if (!this.initialized) {
                this.initialize();
            }
            return this.baseCollection.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Object object = this.lockObject;
        synchronized (object) {
            if (!this.initialized) {
                this.initialize();
            }
            return this.baseCollection.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        Object object = this.lockObject;
        synchronized (object) {
            if (!this.initialized) {
                this.initialize();
            }
            return this.baseCollection.toArray(a);
        }
    }
}

