/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.applicationblocks.com.runtime;

import com.genesyslab.platform.applicationblocks.com.ConfService;
import com.genesyslab.platform.applicationblocks.com.PermissionDescriptor;
import com.genesyslab.platform.applicationblocks.com.runtime.PermissionDescriptorImpl;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.xmlfactory.XmlFactories;
import com.genesyslab.platform.configuration.protocol.ConfServerProtocol;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlPermissionsHelper {
    private static String cfgns;
    private static XPath xpath;
    private static DocumentBuilder documentBuilder;
    private static ILogger log;

    private XmlPermissionsHelper() {
    }

    protected static Element createPermissionElement(Document xmlDoc, String name, int dbid, int type) {
        Element xmlObject = xmlDoc.createElementNS(cfgns, name);
        Element xmlCsidElement = xmlDoc.createElementNS(cfgns, "CSID");
        xmlCsidElement.setAttribute("value", "0");
        Element xmlDbidElement = xmlDoc.createElementNS(cfgns, "DBID");
        xmlDbidElement.setAttribute("value", Integer.toString(dbid));
        Element xmlTypeElement = xmlDoc.createElementNS(cfgns, "type");
        xmlTypeElement.setAttribute("value", Integer.toString(type));
        xmlObject.appendChild(xmlCsidElement);
        xmlObject.appendChild(xmlDbidElement);
        xmlObject.appendChild(xmlTypeElement);
        return xmlObject;
    }

    protected static Document createPermissionsObjectXml(int dbid, int type) {
        Document xmlObjectDocument = documentBuilder.newDocument();
        xmlObjectDocument.setXmlVersion("1.0");
        Element xmlElement = xmlObjectDocument.createElementNS(cfgns, "ConfData");
        xmlObjectDocument.appendChild(xmlElement);
        Element xmlObject = XmlPermissionsHelper.createPermissionElement(xmlObjectDocument, "CfgID", dbid, type);
        xmlObjectDocument.getDocumentElement().appendChild(xmlObject);
        return xmlObjectDocument;
    }

    public static List<PermissionDescriptor> extractPermissionsList(Document doc) {
        ArrayList<PermissionDescriptor> resultList = new ArrayList<PermissionDescriptor>();
        NodeList nodes = null;
        try {
            nodes = (NodeList)xpath.evaluate("cfg:ConfData/cfg:CfgACL/cfg:ACEs/cfg:CfgACE", doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            log.error((Object)"Internal exception", (Throwable)e);
        }
        if (nodes != null) {
            int len = nodes.getLength();
            for (int i = 0; i < len; ++i) {
                try {
                    Node node = nodes.item(i);
                    int dbid = Integer.parseInt(xpath.evaluate("cfg:CfgACEID/cfg:DBID/@value", node));
                    int type = Integer.parseInt(xpath.evaluate("cfg:CfgACEID/cfg:type/@value", node));
                    int accessMask = Integer.parseInt(xpath.evaluate("cfg:accessMask/@value", node));
                    PermissionDescriptorImpl permission = new PermissionDescriptorImpl(dbid, type, accessMask);
                    resultList.add(permission);
                    continue;
                }
                catch (XPathExpressionException e) {
                    log.error((Object)"Internal exception", (Throwable)e);
                }
            }
        }
        return resultList;
    }

    static Document createUpdateXml(Document oldDoc, int accountDbid, int accountType, int newMask) {
        String path = "cfg:ConfData/cfg:CfgACL/cfg:ACEs/cfg:CfgACE[cfg:CfgACEID/cfg:DBID/@value = " + accountDbid + " and cfg:CfgACEID/cfg:type/@value = '" + accountType + "']/cfg:accessMask";
        Node accessMaskNode = null;
        try {
            accessMaskNode = (Node)xpath.evaluate(path, oldDoc, XPathConstants.NODE);
        }
        catch (XPathExpressionException ex) {
            log.error((Object)"Internal exception", (Throwable)ex);
        }
        if (accessMaskNode != null) {
            ((Attr)accessMaskNode.getAttributes().getNamedItem("value")).setValue(Integer.toString(newMask));
        } else {
            path = "cfg:ConfData/cfg:CfgACL/cfg:ACEs";
            Node newEntryNode = null;
            try {
                newEntryNode = (Node)xpath.evaluate(path, oldDoc, XPathConstants.NODE);
            }
            catch (XPathExpressionException ex) {
                log.error((Object)"Internal exception", (Throwable)ex);
            }
            if (newEntryNode == null) {
                log.debug((Object)"This is some kind of mistake. The xml file that we get does not contain required entries.");
                return null;
            }
            Element newNode = oldDoc.createElementNS(cfgns, "CfgACE");
            Element newNode1 = XmlPermissionsHelper.createPermissionElement(oldDoc, "CfgACEID", accountDbid, accountType);
            newNode.appendChild(newNode1);
            Element newNodeAccMask = oldDoc.createElementNS(cfgns, "accessMask");
            newNodeAccMask.setAttribute("value", Integer.toString(newMask));
            newNode.appendChild(newNodeAccMask);
            newEntryNode.appendChild(newNode);
            path = "cfg:ConfData/cfg:CfgACL/cfg:count";
            Element countNode = null;
            try {
                countNode = (Element)xpath.evaluate(path, oldDoc, XPathConstants.NODE);
            }
            catch (XPathExpressionException ex) {
                log.error((Object)"Internal exception", (Throwable)ex);
            }
            if (countNode != null) {
                countNode.setAttribute("value", Integer.toString(Integer.parseInt(countNode.getAttribute("value")) + 1));
            }
        }
        return oldDoc;
    }

    static Document removeAccountFromPermissionsXml(Document oldPermissionsDoc, int accountDbid, int accountType) {
        if (oldPermissionsDoc == null) {
            throw new NullPointerException("oldPermissionsDoc");
        }
        Document doc = documentBuilder.newDocument();
        doc.appendChild(doc.importNode(oldPermissionsDoc.getDocumentElement(), true));
        String path = "cfg:ConfData/cfg:CfgACL/cfg:ACEs/cfg:CfgACE[cfg:CfgACEID/cfg:DBID/@value='" + accountDbid + "' and cfg:CfgACEID/cfg:type/@value = '" + accountType + "']";
        Element aceNode = null;
        try {
            aceNode = (Element)xpath.evaluate(path, doc, XPathConstants.NODE);
        }
        catch (XPathExpressionException ex) {
            log.error((Object)"Internal exception", (Throwable)ex);
        }
        if (aceNode != null) {
            aceNode.getParentNode().removeChild(aceNode);
            path = "cfg:ConfData/cfg:CfgACL/cfg:count";
            Element countNode = null;
            try {
                countNode = (Element)xpath.evaluate(path, doc, XPathConstants.NODE);
            }
            catch (XPathExpressionException ex) {
                log.error((Object)"Internal exception", (Throwable)ex);
            }
            if (countNode != null) {
                countNode.setAttribute("value", Integer.toString(Integer.parseInt(countNode.getAttribute("value")) - 1));
            }
        }
        return doc;
    }

    static {
        documentBuilder = null;
        log = Log.getLogger(ConfService.class);
        cfgns = ConfServerProtocol.PROTOCOL_DESCRIPTION.getNS();
        xpath = XmlFactories.newXPath();
        xpath.setNamespaceContext(new NamespaceContext(){

            public String getNamespaceURI(String prefix) {
                String uri = prefix.equals("cfg") || prefix.equals("") ? cfgns : null;
                return uri;
            }

            public Iterator getPrefixes(String val) {
                return null;
            }

            public String getPrefix(String uri) {
                return null;
            }
        });
        try {
            documentBuilder = XmlFactories.newDocumentBuilderNS();
        }
        catch (ParserConfigurationException e) {
            log.fatalError((Object)"XML engine initialization is failed", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

