/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.applicationblocks.com.runtime;

import com.genesyslab.platform.applicationblocks.com.CfgBase;
import com.genesyslab.platform.applicationblocks.com.CfgDelta;
import com.genesyslab.platform.applicationblocks.com.CfgObject;
import com.genesyslab.platform.applicationblocks.com.CfgStructure;
import com.genesyslab.platform.applicationblocks.com.ConfService;
import com.genesyslab.platform.applicationblocks.com.ConfigException;
import com.genesyslab.platform.applicationblocks.com.ConfigRuntimeException;
import com.genesyslab.platform.applicationblocks.com.ICfgDelta;
import com.genesyslab.platform.applicationblocks.com.ICfgObject;
import com.genesyslab.platform.applicationblocks.com.IConfService;
import com.genesyslab.platform.applicationblocks.com.runtime.CfgLinksBroker;
import com.genesyslab.platform.applicationblocks.com.runtime.CfgObjectActivator;
import com.genesyslab.platform.applicationblocks.com.runtime.Utils;
import com.genesyslab.platform.commons.GEnum;
import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.KeyValuePair;
import com.genesyslab.platform.commons.collections.ValueType;
import com.genesyslab.platform.commons.collections.util.Hex;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.configuration.protocol.ConfServerProtocol;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttribute;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeReference;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeReferenceClass;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeReferenceClassList;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeReferenceLink;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionClass;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionObject;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionStructure;
import com.genesyslab.platform.configuration.protocol.metadata.CfgTypeMask;
import com.genesyslab.platform.configuration.protocol.metadata.ICfgAttributeOperationalInfo;
import com.genesyslab.platform.configuration.protocol.metadata.ICfgClassOperationalInfo;
import com.genesyslab.platform.configuration.protocol.types.CfgObjectType;
import com.genesyslab.platform.configuration.protocol.utilities.Linq;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlPropertiesHelper {
    private static final String CFG_NS;
    private static final ILogger log;

    private XmlPropertiesHelper() {
    }

    public static Object getSimpleProperty(String propertyName, Class retClass, CfgDescriptionAttribute info, Node xmlData) {
        Node rootNode = XmlPropertiesHelper.getSubNode(xmlData, info.getName());
        Attr attr = null;
        if (rootNode != null) {
            attr = (Attr)rootNode.getAttributes().getNamedItem("value");
        }
        String myValue = null;
        if (attr != null) {
            myValue = attr.getValue();
        }
        if (info.isCfgType(CfgTypeMask.Time)) {
            if (myValue == null || myValue.equals("")) {
                return null;
            }
            return Utils.UnixTimeToWindowsTime(Integer.parseInt(myValue));
        }
        if (info.isCfgType(CfgTypeMask.Integer) || info.isCfgType(CfgTypeMask.Enum)) {
            if (retClass != null && GEnum.class.isAssignableFrom(retClass)) {
                if (myValue != null && !myValue.equals("")) {
                    int retVal = Integer.parseInt(myValue);
                    return GEnum.getValue((Class)retClass, (int)retVal);
                }
                return null;
            }
            if (myValue == null || myValue.equals("")) {
                return null;
            }
            return Integer.parseInt(myValue);
        }
        if (info.isCfgType(CfgTypeMask.String)) {
            return myValue;
        }
        throw new IllegalArgumentException("GetSimpleProperty(\"" + propertyName + "\"): Unsupported object type!");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setSimpleProperty(CfgDescriptionAttribute info, Node xmlData, Object propertyValue) {
        Node myNode = XmlPropertiesHelper.getSubNode(xmlData, info.getName());
        if (myNode == null) {
            Element newNode = xmlData.getOwnerDocument().createElementNS(CFG_NS, info.getName());
            Attr valueAttr = xmlData.getOwnerDocument().createAttribute("value");
            newNode.getAttributes().setNamedItem(valueAttr);
            myNode = xmlData.appendChild(newNode);
        }
        if (info.isCfgType(CfgTypeMask.Time)) {
            if (!(propertyValue instanceof Calendar)) {
                throw new IllegalArgumentException("The new value is not an DateTime type");
            }
            Calendar winTime = (Calendar)propertyValue;
            long unixTime = Utils.WindowsTimeToUnixTime(winTime);
            ((Attr)myNode.getAttributes().getNamedItem("value")).setValue(Long.toString(unixTime));
            return;
        } else if (info.isCfgType(CfgTypeMask.Integer) || info.isCfgType(CfgTypeMask.Enum)) {
            if (propertyValue instanceof GEnum) {
                ((Attr)myNode.getAttributes().getNamedItem("value")).setValue(Integer.toString(((GEnum)propertyValue).ordinal()));
                return;
            } else if (propertyValue instanceof Integer) {
                ((Attr)myNode.getAttributes().getNamedItem("value")).setValue(propertyValue.toString());
                return;
            } else {
                if (!(propertyValue instanceof Long)) throw new IllegalArgumentException("The new value is not an int type");
                ((Attr)myNode.getAttributes().getNamedItem("value")).setValue(propertyValue.toString());
            }
            return;
        } else {
            if (!info.isCfgType(CfgTypeMask.String)) throw new IllegalArgumentException("setSimpleProperty: Unsupported object type of " + info.getName());
            ((Attr)myNode.getAttributes().getNamedItem("value")).setValue(propertyValue.toString());
        }
    }

    public static void setKvListProperty(CfgDescriptionAttribute info, Node xmlData, Object propertyValue) {
        Node myNode = XmlPropertiesHelper.getSubNode(xmlData, info.getName());
        if (myNode == null) {
            Element newNode = xmlData.getOwnerDocument().createElementNS(CFG_NS, info.getName());
            myNode = xmlData.appendChild(newNode);
        }
        if (!(propertyValue instanceof KeyValueCollection)) {
            throw new IllegalArgumentException("The new value is not a KeyValueCollection");
        }
        KeyValueCollection newValue = (KeyValueCollection)propertyValue;
        while (myNode.hasChildNodes()) {
            myNode.removeChild(myNode.getFirstChild());
        }
        while (myNode.hasAttributes()) {
            myNode.getAttributes().removeNamedItem(myNode.getAttributes().item(0).getNodeName());
        }
        XmlPropertiesHelper.buildXmlFromKvList(xmlData, newValue, myNode);
    }

    private static void buildXmlFromKvList(Node xmlData, KeyValueCollection newValue, Node myNode) {
        if (newValue == null || myNode == null) {
            return;
        }
        for (KeyValuePair pair : newValue) {
            Attr optionValueAttr;
            Element newOptionNode;
            Attr optionNameAttr;
            if (ValueType.TKV_LIST.equals((Object)pair.getValueType())) {
                Element nestedSectionNode = xmlData.getOwnerDocument().createElementNS(CFG_NS, "list_pair");
                optionNameAttr = xmlData.getOwnerDocument().createAttribute("key");
                optionNameAttr.setValue(pair.getStringKey());
                nestedSectionNode.getAttributes().setNamedItem(optionNameAttr);
                XmlPropertiesHelper.buildXmlFromKvList(xmlData, (KeyValueCollection)pair.getValue(), nestedSectionNode);
                myNode.appendChild(nestedSectionNode);
                continue;
            }
            if (ValueType.INT.equals((Object)pair.getValueType())) {
                newOptionNode = xmlData.getOwnerDocument().createElementNS(CFG_NS, "int_pair");
                optionNameAttr = xmlData.getOwnerDocument().createAttribute("key");
                optionNameAttr.setValue(pair.getStringKey());
                optionValueAttr = xmlData.getOwnerDocument().createAttribute("value");
                optionValueAttr.setValue(pair.getValue().toString());
                newOptionNode.getAttributes().setNamedItem(optionNameAttr);
                newOptionNode.getAttributes().setNamedItem(optionValueAttr);
                myNode.appendChild(newOptionNode);
                continue;
            }
            if (ValueType.BINARY.equals((Object)pair.getValueType())) {
                newOptionNode = xmlData.getOwnerDocument().createElementNS(CFG_NS, "bin_pair");
                optionNameAttr = xmlData.getOwnerDocument().createAttribute("key");
                optionNameAttr.setValue(pair.getStringKey());
                optionValueAttr = xmlData.getOwnerDocument().createAttribute("value");
                String strEnc = new String(Hex.encodeHex((byte[])pair.getBinaryValue()));
                optionValueAttr.setValue(strEnc);
                newOptionNode.getAttributes().setNamedItem(optionNameAttr);
                newOptionNode.getAttributes().setNamedItem(optionValueAttr);
                myNode.appendChild(newOptionNode);
                continue;
            }
            newOptionNode = xmlData.getOwnerDocument().createElementNS(CFG_NS, "str_pair");
            optionNameAttr = xmlData.getOwnerDocument().createAttribute("key");
            optionNameAttr.setValue(pair.getStringKey());
            optionValueAttr = xmlData.getOwnerDocument().createAttribute("value");
            optionValueAttr.setValue(pair.getValue().toString());
            newOptionNode.getAttributes().setNamedItem(optionNameAttr);
            newOptionNode.getAttributes().setNamedItem(optionValueAttr);
            myNode.appendChild(newOptionNode);
        }
    }

    public static void setStructureProperty(Object propertyValue, Node xmlData) {
        CfgBase newStruct = (CfgBase)propertyValue;
        Node newStructureNode = xmlData.getOwnerDocument().importNode(newStruct.getData(), true);
        Node oldStructureNode = XmlPropertiesHelper.getSubNode(xmlData, newStructureNode.getNodeName());
        if (oldStructureNode == null) {
            xmlData.appendChild(newStructureNode);
        } else {
            xmlData.replaceChild(newStructureNode, oldStructureNode);
        }
    }

    public static void setStructureCollectionProperty(Object propertyValue, CfgDescriptionAttribute info, Node xmlData) {
        if (!(propertyValue instanceof List)) {
            throw new IllegalArgumentException("The new value is not the right type. It should be IList");
        }
        List structures = (List)propertyValue;
        Node myNode = XmlPropertiesHelper.getSubNode(xmlData, info.getName());
        if (myNode == null) {
            Element newNode = xmlData.getOwnerDocument().createElementNS(CFG_NS, info.getName());
            myNode = xmlData.appendChild(newNode);
        } else {
            while (myNode.hasChildNodes()) {
                myNode.removeChild(myNode.getFirstChild());
            }
            while (myNode.hasAttributes()) {
                myNode.getAttributes().removeNamedItem(myNode.getAttributes().item(0).getNodeName());
            }
        }
        for (Object elem : structures) {
            if (!(elem instanceof CfgStructure)) {
                throw new IllegalArgumentException("The new value is not the right type. It should be IConfigurationData");
            }
            CfgStructure newStruct = (CfgStructure)elem;
            if (!newStruct.isStructure()) {
                throw new IllegalArgumentException("The new value is not the right type. It should be a structure.");
            }
            Node newStructureNode = xmlData.getOwnerDocument().importNode(newStruct.getData(), true);
            myNode.appendChild(newStructureNode);
        }
    }

    public static void setLinkProperty(Object propertyValue, CfgDescriptionAttribute info, Node xmlData) {
        int id = 0;
        if (propertyValue instanceof Integer) {
            id = (Integer)propertyValue;
        } else if (propertyValue instanceof CfgObject) {
            CfgObject cfgObject = (CfgObject)propertyValue;
            if (!cfgObject.isSaved()) {
                throw new IllegalArgumentException("Cannot assign a link because the object has not been saved yet.");
            }
            id = cfgObject.getObjectDbid();
            if (id == 0) {
                throw new IllegalArgumentException("Cannot assign a link - no positive dbid (object has not been saved)");
            }
        } else {
            throw new IllegalArgumentException("The new value is not the right type. It should be CfgObject or int. We have: " + propertyValue.getClass().getName());
        }
        Node myNode = XmlPropertiesHelper.getSubNode(xmlData, info.getName());
        if (myNode == null) {
            Element newNode = xmlData.getOwnerDocument().createElementNS(CFG_NS, info.getName());
            myNode = xmlData.appendChild(newNode);
        }
        Attr valueAttr = xmlData.getOwnerDocument().createAttribute("value");
        valueAttr.setValue(Integer.toString(id));
        myNode.getAttributes().setNamedItem(valueAttr);
    }

    public static void setLinkColProperty(Object propertyValue, CfgDescriptionAttribute info, Node xmlData) {
        if (!(propertyValue instanceof List)) {
            throw new IllegalArgumentException("The new value is not the right type. It should be List");
        }
        Node myNode = XmlPropertiesHelper.getSubNode(xmlData, info.getName());
        Element newNode = xmlData.getOwnerDocument().createElementNS(CFG_NS, info.getName());
        if (myNode == null) {
            myNode = xmlData.appendChild(newNode);
        } else {
            myNode.getParentNode().replaceChild(newNode, myNode);
            myNode = newNode;
        }
        for (Object elem : (Collection)propertyValue) {
            int id;
            if (elem instanceof Integer) {
                id = (Integer)elem;
            } else if (elem instanceof CfgObject) {
                CfgObject newObject = (CfgObject)elem;
                if (!newObject.isSaved()) {
                    throw new IllegalArgumentException("Cannot assign a link because the object has not been saved yet.");
                }
                id = newObject.getObjectDbid();
                if (id == 0) {
                    throw new IllegalArgumentException("Cannot assign a link - no positive dbid (object has not been saved)");
                }
            } else {
                throw new IllegalArgumentException("The new value is not the right type. It should be CfgObject or integer");
            }
            newNode = xmlData.getOwnerDocument().createElementNS(CFG_NS, "DBID");
            Attr valueAttr = xmlData.getOwnerDocument().createAttribute("value");
            valueAttr.setNodeValue(Integer.toString(id));
            newNode.getAttributes().setNamedItem(valueAttr);
            myNode.appendChild(newNode);
        }
    }

    public static ICfgObject createLinkObject(CfgDescriptionAttribute info, IConfService confService, Node xmlData) throws ConfigException {
        if (!info.isCfgType(CfgTypeMask.Link) || info.isCfgType(CfgTypeMask.List)) {
            throw new IllegalArgumentException("The property " + info.getName() + " is not a link type.");
        }
        Node rootNode = XmlPropertiesHelper.getSubNode(xmlData, info.getSchemaName());
        if (rootNode == null) {
            return null;
        }
        Node valueNode = rootNode.getAttributes().getNamedItem("value");
        if (valueNode == null) {
            return null;
        }
        String myValue = valueNode.getNodeValue();
        if (myValue == null || myValue.equals("") || myValue.equals("0")) {
            return null;
        }
        CfgDescriptionObject linkClass = (CfgDescriptionObject)((CfgDescriptionAttributeReferenceLink)info).getCfgClass();
        if (linkClass == null) {
            throw new RuntimeException("The link description is invalid in metadata for " + info.getParent().getName() + "." + info.getName());
        }
        CfgObjectType objectType = linkClass.getCfgEnum();
        return XmlPropertiesHelper.resolveLink(confService, objectType, Integer.parseInt(myValue));
    }

    public static ICfgObject resolveLink(IConfService confService, CfgObjectType objectType, int dbid) throws ConfigException {
        ICfgObject obj = null;
        if (confService.getPolicy().getAttemptLinkResolutionThroughCache(objectType)) {
            if (log.isDebug()) {
                log.debugFormat("Resolving link through cache... [{0}], dbid: [{1}]", (Object)new Object[]{objectType, dbid});
            }
            obj = confService.getCache().retrieve(ICfgObject.class, objectType, dbid);
        }
        if (obj == null) {
            if (log.isDebug()) {
                log.debugFormat("Resolving link through configuration server... [{0}], dbid: [{1}]", (Object)new Object[]{objectType, dbid});
            }
            try {
                obj = confService.retrieveObject(objectType, dbid);
            }
            catch (ConfigException ex) {
                if (log.isError()) {
                    log.error((Object)"Exception on linked object retrieve", (Throwable)ex);
                }
                throw new ConfigRuntimeException("Exception on linked object retrieve", ex);
            }
        }
        return obj;
    }

    public static Integer getLinkValue(String propertyName, CfgDescriptionClass dataClass, Node xmlData) {
        CfgDescriptionAttribute info = dataClass.getAttributeByName(propertyName);
        if (info == null) {
            return null;
        }
        if (!info.isCfgType(CfgTypeMask.Link) || info.isCfgType(CfgTypeMask.List)) {
            throw new IllegalArgumentException("The property " + propertyName + " is not a link type.");
        }
        Node rootNode = XmlPropertiesHelper.getSubNode(xmlData, info.getName());
        if (rootNode == null) {
            return null;
        }
        Attr linkAttr = (Attr)rootNode.getAttributes().getNamedItem("value");
        String linkValue = null;
        if (linkAttr != null) {
            linkValue = linkAttr.getValue();
        }
        if (linkValue == null || linkValue.equals("")) {
            return null;
        }
        return Integer.parseInt(linkValue);
    }

    public static List createLinksList(String propertyName, CfgDescriptionClass metadata, IConfService confService, Node xmlData) {
        CfgDescriptionAttribute info = XmlPropertiesHelper.getAttributeInfo(metadata, propertyName);
        ArrayList<ICfgObject> links = null;
        if (info == null) {
            throw new IllegalArgumentException("There is no property " + propertyName + " in this class.");
        }
        if (!info.isCfgType(CfgTypeMask.List) || !info.isCfgType(CfgTypeMask.Link)) {
            throw new IllegalArgumentException("The property " + propertyName + " is not a link list type.");
        }
        Node rootNode = XmlPropertiesHelper.getSubNode(xmlData, info.getName());
        if (rootNode == null) {
            return links;
        }
        CfgObjectType objectType = ((CfgDescriptionObject)((CfgDescriptionAttributeReference)info).getCfgClass()).getCfgEnum();
        links = new ArrayList<ICfgObject>();
        NodeList linksNodes = rootNode.getChildNodes();
        if (linksNodes == null) {
            return links;
        }
        for (int i = 0; i < linksNodes.getLength(); ++i) {
            Node linkNode = linksNodes.item(i);
            if (linkNode.getAttributes().getNamedItem("value") == null) continue;
            String myValue = ((Attr)linkNode.getAttributes().getNamedItem("value")).getValue();
            try {
                ICfgObject obj = XmlPropertiesHelper.resolveLink(confService, objectType, Integer.parseInt(myValue));
                if (obj == null) continue;
                links.add(obj);
                continue;
            }
            catch (ConfigException e) {
                log.error((Object)"Exception getting linked object", (Throwable)e);
                throw new ConfigRuntimeException("Exception getting linked object", e);
            }
        }
        return links;
    }

    public static Collection<Integer> getLinkListCollection(String propertyName, CfgDescriptionClass dataClass, Node xmlData) {
        CfgDescriptionAttribute info = XmlPropertiesHelper.getAttributeInfo(dataClass, propertyName);
        if (info == null) {
            return null;
        }
        if (!info.isCfgType(CfgTypeMask.List) || !info.isCfgType(CfgTypeMask.Link)) {
            throw new IllegalArgumentException("The property " + propertyName + " is not a link list type.");
        }
        Node rootNode = XmlPropertiesHelper.getSubNode(xmlData, info.getName());
        if (rootNode == null) {
            return null;
        }
        NodeList linksNodes = rootNode.getChildNodes();
        if (linksNodes.getLength() == 0) {
            return null;
        }
        ArrayList<Integer> lst = new ArrayList<Integer>(linksNodes.getLength());
        for (int i = 0; i < linksNodes.getLength(); ++i) {
            Node attr;
            Node linkNode = linksNodes.item(i);
            if (linkNode == null || linkNode.getAttributes() == null || (attr = linkNode.getAttributes().getNamedItem("value")) == null) continue;
            lst.add(Integer.parseInt(attr.getNodeValue()));
        }
        return lst;
    }

    @Deprecated
    public static Integer[] getLinkListValue(String propertyName, CfgDescriptionClass dataClass, Node xmlData) {
        Collection<Integer> collection = XmlPropertiesHelper.getLinkListCollection(propertyName, dataClass, xmlData);
        if (collection != null) {
            return collection.toArray(new Integer[collection.size()]);
        }
        return null;
    }

    public static List<CfgStructure> createDeltaStructureList(String propertyName, Object classRef, CfgDescriptionClass dataClass, IConfService confService, Node xmlData) {
        CfgDescriptionAttribute key;
        Document doc = xmlData.getOwnerDocument();
        ICfgAttributeOperationalInfo info = null;
        if (dataClass.getAttributeByName(propertyName) instanceof ICfgAttributeOperationalInfo) {
            info = (ICfgAttributeOperationalInfo)dataClass.getAttributeByName(propertyName);
        }
        if (info == null) {
            throw new IllegalArgumentException("There is no property " + propertyName + " in this class.");
        }
        CfgDescriptionAttributeReference infoRef = null;
        if (info instanceof CfgDescriptionAttributeReference) {
            infoRef = (CfgDescriptionAttributeReference)info;
        }
        CfgDescriptionAttributeReferenceClassList attrClass = null;
        if (info.getSubjectAttributeDescription() instanceof CfgDescriptionAttributeReferenceClassList) {
            attrClass = (CfgDescriptionAttributeReferenceClassList)info.getSubjectAttributeDescription();
        }
        if (attrClass == null) {
            throw new IllegalArgumentException("Invalid class information provided");
        }
        CfgDescriptionStructure descStructure = (CfgDescriptionStructure)attrClass.getCfgClass();
        if (descStructure == null) {
            throw new IllegalArgumentException("Provided metadata does not contain valid information");
        }
        Element root = null;
        Element property = null;
        ArrayList<CfgStructure> structures = null;
        Element rootNode = (Element)XmlPropertiesHelper.getSubNode(xmlData, infoRef.getName());
        if (rootNode == null) {
            return structures;
        }
        if (descStructure.getAliasName() == null || descStructure.getKeys() == null || (key = (CfgDescriptionAttribute)Linq.firstOrDefault((Collection)descStructure.getKeys(), null)) == null) {
            return structures;
        }
        structures = new ArrayList<CfgStructure>();
        Node element = rootNode.getFirstChild();
        while (element != null) {
            if (element instanceof Text || element.getAttributes() == null) {
                element = element.getNextSibling();
                continue;
            }
            root = doc.createElementNS(CFG_NS, descStructure.getAliasName());
            property = doc.createElementNS(CFG_NS, key.getName());
            Node attr = element.getAttributes().getNamedItem("value");
            if (attr != null) {
                property.setAttribute("value", attr.getNodeValue());
            }
            root.appendChild(property);
            CfgStructure newStructure = (CfgStructure)CfgObjectActivator.createInstance(infoRef.getCfgClass().getName(), confService, root, new Object[]{classRef});
            structures.add(newStructure);
            element = element.getNextSibling();
        }
        return structures;
    }

    public static <T extends ICfgObject> Collection<T> createLinksListBroker(IConfService confService, CfgBase obj, CfgBase parent, CfgDescriptionClass metadata, CfgDescriptionAttribute info) {
        if (info == null) {
            throw new IllegalArgumentException("There is no property information specified ('info' parameter).");
        }
        if (!info.isCfgType(CfgTypeMask.Link) || !info.isCfgType(CfgTypeMask.List)) {
            throw new IllegalArgumentException("The property '" + info.getSchemaName() + "' is not a link list type.");
        }
        if (XmlPropertiesHelper.getSubNode(obj.getData(), info.getSchemaName()) == null && (metadata.isCfgType(CfgTypeMask.Delta) || parent != null && parent.getMetaData().isCfgType(CfgTypeMask.Delta) || obj instanceof ICfgDelta)) {
            return null;
        }
        return new CfgLinksBroker(obj, info.getSchemaName());
    }

    public static List<CfgStructure> createStructureList(String propertyName, Object classRef, CfgDescriptionClass dataClass, IConfService confService, Node xmlData) {
        CfgDescriptionAttribute info = dataClass.getAttributeByName(propertyName);
        if (info == null) {
            throw new IllegalArgumentException("There is no property " + propertyName + " in this class.");
        }
        if (!info.isCfgType(CfgTypeMask.Structure) || !info.isCfgType(CfgTypeMask.List)) {
            throw new IllegalArgumentException("The property " + propertyName + " is not a structure list type.");
        }
        try {
            String structureClassName = ((CfgDescriptionAttributeReference)info).getCfgClass().getName();
            ArrayList<CfgStructure> structures = new ArrayList<CfgStructure>();
            Node rootNode = XmlPropertiesHelper.getSubNode(xmlData, info.getName());
            if (rootNode == null) {
                if (dataClass.isCfgType(CfgTypeMask.Delta) || classRef instanceof CfgDelta) {
                    return null;
                }
                return structures;
            }
            NodeList structureNodes = rootNode.getChildNodes();
            for (int i = 0; i < structureNodes.getLength(); ++i) {
                Node item = structureNodes.item(i);
                if (!(item instanceof Element)) continue;
                CfgStructure newStructure = (CfgStructure)CfgObjectActivator.createInstance(structureClassName, confService, item, new Object[]{classRef});
                structures.add(newStructure);
            }
            return structures;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Object createStructureClass(String propertyName, Object classRef, CfgDescriptionClass dataClass, IConfService confService, Node xmlData) {
        CfgDescriptionAttributeReferenceClass propertyInfo = (CfgDescriptionAttributeReferenceClass)dataClass.getAttribute(propertyName);
        if (propertyInfo == null) {
            throw new IllegalArgumentException("There is no propertyInfo provided.");
        }
        if (!propertyInfo.isCfgType(CfgTypeMask.Structure) || propertyInfo.isCfgType(CfgTypeMask.List)) {
            throw new IllegalArgumentException("The property " + propertyInfo.getName() + " is not a structure type.");
        }
        Node rootNode = XmlPropertiesHelper.getSubNode(xmlData, propertyInfo.getName());
        if (rootNode == null) {
            return null;
        }
        try {
            return CfgObjectActivator.createInstance(propertyInfo.getCfgClass().getName(), confService, rootNode, new Object[]{classRef});
        }
        catch (Exception ex) {
            throw new ConfigRuntimeException("Exception creating structure class", ex);
        }
    }

    @Deprecated
    public static KeyValueCollection createKvList(String propertyName, CfgDescriptionClass dataClass, Node xmlData) {
        return XmlPropertiesHelper.createKvList(propertyName, null, dataClass, xmlData);
    }

    public static KeyValueCollection createKvList(String propertyName, Object objectRef, CfgDescriptionClass dataClass, Node xmlData) {
        CfgDescriptionAttribute info = dataClass.getAttributeByName(propertyName);
        if (info == null) {
            throw new IllegalArgumentException("There is no property " + propertyName + " in this class.");
        }
        if (!info.isCfgType(CfgTypeMask.KvList)) {
            throw new IllegalArgumentException("The property " + propertyName + " is not a kv-list type.");
        }
        Node rootNode = XmlPropertiesHelper.getSubNode(xmlData, info.getName());
        if (rootNode == null) {
            if (dataClass.isCfgType(CfgTypeMask.Delta) || objectRef instanceof ICfgDelta) {
                return null;
            }
            return new KeyValueCollection();
        }
        return XmlPropertiesHelper.buildKvList(rootNode.getChildNodes());
    }

    protected static KeyValueCollection buildKvList(NodeList childrenList) {
        KeyValueCollection result = null;
        if (childrenList != null) {
            result = new KeyValueCollection();
            for (int i = 0; i < childrenList.getLength(); ++i) {
                Attr xmlValue;
                String strKey;
                Attr xmlOptsKey;
                Node child = childrenList.item(i);
                if (child == null || child.getAttributes() == null || child.getNodeName() == null || (xmlOptsKey = (Attr)child.getAttributes().getNamedItem("key")) == null || (strKey = xmlOptsKey.getValue()) == null) continue;
                Object objValue = null;
                if (child.getNodeName().equals("list_pair")) {
                    objValue = XmlPropertiesHelper.buildKvList(child.getChildNodes());
                } else if (child.getNodeName().equals("str_pair")) {
                    xmlValue = (Attr)child.getAttributes().getNamedItem("value");
                    objValue = xmlValue != null ? xmlValue.getValue() : "";
                } else if (child.getNodeName().equals("int_pair")) {
                    xmlValue = (Attr)child.getAttributes().getNamedItem("value");
                    if (xmlValue != null && xmlValue.getValue() != null) {
                        objValue = Integer.parseInt(xmlValue.getValue());
                    }
                } else if (child.getNodeName().equals("bin_pair") && (xmlValue = (Attr)child.getAttributes().getNamedItem("value")) != null && xmlValue.getValue() != null) {
                    objValue = Hex.decodeHex((char[])xmlValue.getValue().toCharArray());
                }
                if (objValue == null) continue;
                result.addObject(strKey, objValue);
            }
        }
        return result;
    }

    private static boolean isDelta(Node node) {
        return node.getNodeName().contains("Delta");
    }

    private static CfgDescriptionAttribute getAttributeInfo(CfgDescriptionClass dataClass, String propertyName) {
        CfgDescriptionAttribute info = dataClass.getAttribute(propertyName);
        if (info == null && dataClass instanceof ICfgClassOperationalInfo) {
            ICfgClassOperationalInfo delta = (ICfgClassOperationalInfo)dataClass;
            info = delta.getSubjectClassDescription().getAttribute(propertyName);
        }
        return info;
    }

    private static Node getSubNode(Node node, String strName) {
        Node tempNode;
        for (tempNode = node.getFirstChild(); tempNode != null && !tempNode.getNodeName().equals(strName); tempNode = tempNode.getNextSibling()) {
        }
        if (tempNode == null && XmlPropertiesHelper.isDelta(node)) {
            String deltaName = node.getNodeName();
            String noDeltaName = deltaName.replaceFirst("Delta", "");
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node childI = children.item(i);
                if (!childI.getNodeName().equals(noDeltaName)) continue;
                tempNode = childI;
                break;
            }
            if (tempNode != null) {
                tempNode = XmlPropertiesHelper.getSubNode(tempNode, strName);
            }
        }
        return tempNode;
    }

    static {
        log = Log.getLogger(ConfService.class);
        CFG_NS = ConfServerProtocol.PROTOCOL_DESCRIPTION.getNS();
    }
}

