/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.threading;

import com.genesyslab.platform.commons.management.HeartbeatCounterException;
import com.genesyslab.platform.commons.management.PSDKMBeanBase;
import com.genesyslab.platform.commons.threading.ThreadHeartbeatCounterMBean;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public final class ThreadHeartbeatCounter
extends PSDKMBeanBase
implements ThreadHeartbeatCounterMBean {
    private long threadOSID = -1L;
    private int threadClass;
    private boolean active = false;
    private int heartbeatCounter;
    private static final Random random = new Random();
    private static final AtomicInteger uniqIDGen = new AtomicInteger(0);

    private ThreadHeartbeatCounter(String threadLogicalName, int threadClass) {
        super("ThreadHeartbeatMonitor", threadLogicalName, uniqIDGen.incrementAndGet());
        if (threadLogicalName == null || threadLogicalName.equals("")) {
            throw new IllegalArgumentException("ThreadLogicName can't be empty");
        }
        this.heartbeatCounter = Math.abs(random.nextInt());
        this.setThreadClass(threadClass);
        this.doRegisterMBean();
    }

    public static ThreadHeartbeatCounter createThreadHeartbeatCounter(String threadLogicalName, int threadClass) {
        return new ThreadHeartbeatCounter(threadLogicalName, threadClass);
    }

    public synchronized void initialize() {
        if (this.threadOSID >= 0L) {
            throw new HeartbeatCounterException("Thread has already been initialized for heartbeat");
        }
        this.threadOSID = Thread.currentThread().getId();
        this.setActive(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unregister() {
        if (this.threadOSID < 0L) {
            throw new HeartbeatCounterException("Thread is not registered for heartbeat");
        }
        try {
            super.unregister();
        }
        finally {
            this.setActive(false);
            this.threadOSID = -1L;
        }
    }

    public long getThreadSystemId() {
        return this.threadOSID;
    }

    public String getLogicalName() {
        return this.getMBeanName();
    }

    public int getThreadClass() {
        return this.threadClass;
    }

    public synchronized void setThreadClass(int newThreadClass) {
        this.threadClass = newThreadClass;
    }

    public int getHeartbeatCounter() {
        return this.heartbeatCounter;
    }

    public synchronized void setActive(boolean isActive) {
        if (isActive && this.threadOSID < 0L) {
            throw new HeartbeatCounterException("Thread os id has not been initialized");
        }
        this.active = isActive;
    }

    public boolean isActive() {
        return this.active;
    }

    public synchronized void alive() {
        if (this.threadOSID < 0L) {
            throw new HeartbeatCounterException("Thread has not been initialized for heartbeat");
        }
        if (this.threadOSID != Thread.currentThread().getId()) {
            throw new IllegalAccessError("Thread alive call must be done by monitored thread by itself");
        }
        ++this.heartbeatCounter;
    }
}

