/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateTimeConverter {
    private static final String DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String LOCAL_DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss";
    private static final TimeZone GMT_TIMEZONE = TimeZone.getTimeZone("GMT");
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final SimpleDateFormat localDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final String DATE_WITH_MILLISECONDS_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final SimpleDateFormat dateFormatWithMilliseconds = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    public static synchronized Date parse(String dateStr) throws ParseException {
        try {
            return dateFormat.parse(dateStr);
        }
        catch (ParseException ex) {
            return dateFormatWithMilliseconds.parse(dateStr);
        }
    }

    public static synchronized String toString(Date value) {
        return dateFormat.format(value);
    }

    public static synchronized String toLocalString(Date value) {
        return localDateFormat.format(value);
    }

    static {
        dateFormat.setTimeZone(GMT_TIMEZONE);
        dateFormatWithMilliseconds.setTimeZone(GMT_TIMEZONE);
    }
}

