/*
 * Decompiled with CFR 0.152.
 */
package sample;

import com.genesyslab.platform.commons.protocol.ChannelClosedEvent;
import com.genesyslab.platform.commons.protocol.ChannelErrorEvent;
import com.genesyslab.platform.commons.protocol.ChannelListener;
import com.genesyslab.platform.commons.protocol.ChannelState;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.MessageHandler;
import com.genesyslab.platform.commons.protocol.ProtocolException;
import com.genesyslab.platform.commons.protocol.Referenceable;
import com.genesyslab.platform.commons.threading.AsyncInvoker;
import com.genesyslab.platform.commons.threading.SingleThreadInvoker;
import com.genesyslab.platform.commons.timer.TimerAction;
import com.genesyslab.platform.commons.timer.TimerActionTicket;
import com.genesyslab.platform.commons.timer.TimerFactory;
import com.genesyslab.platform.management.protocol.ApplicationExecutionMode;
import com.genesyslab.platform.management.protocol.ApplicationStatus;
import com.genesyslab.platform.management.protocol.LocalControlAgentProtocol;
import com.genesyslab.platform.management.protocol.localcontrolagent.events.EventChangeExecutionMode;
import com.genesyslab.platform.management.protocol.localcontrolagent.events.EventHostUnderControl;
import com.genesyslab.platform.management.protocol.localcontrolagent.events.EventNoControllingSCS;
import com.genesyslab.platform.management.protocol.localcontrolagent.requests.RequestSCSConnectionStatus;
import com.genesyslab.platform.management.protocol.localcontrolagent.requests.RequestUpdateStatus;
import com.genesyslab.platform.management.protocol.localcontrolagent.responses.ResponseExecutionModeChanged;
import java.util.EventObject;

public abstract class AbstractServerApp {
    private LocalControlAgentProtocol lcaProtocol = null;
    private TimerActionTicket lcaReopenTicket = null;

    protected void openLCA(int lcaPortNum, int clientType, String clientName, Integer clientId) throws ProtocolException {
        if (this.lcaProtocol != null) {
            throw new ProtocolException("The protocol is already created");
        }
        this.lcaProtocol = new LocalControlAgentProtocol(lcaPortNum);
        this.lcaProtocol.setApplicationType(Integer.valueOf(clientType));
        if (clientName != null) {
            this.lcaProtocol.setClientName(clientName);
        }
        if (clientId != null) {
            this.lcaProtocol.setClientId(clientId.intValue());
        }
        this.lcaProtocol.addChannelListener((ChannelListener)new LCAChannelListener());
        this.lcaProtocol.setMessageHandler((MessageHandler)new LCAMessageHandler());
        this.lcaProtocol.setInvoker((AsyncInvoker)new SingleThreadInvoker("LCA"));
        this.lcaProtocol.beginOpen();
    }

    protected void closeLCA() throws ProtocolException, InterruptedException {
        if (this.lcaProtocol != null) {
            try {
                this.lcaProtocol.close();
            }
            finally {
                this.lcaProtocol = null;
            }
        }
    }

    public boolean isLCAConnected() {
        if (this.lcaProtocol != null) {
            return this.lcaProtocol.getState() == ChannelState.Opened;
        }
        return false;
    }

    public ApplicationExecutionMode getExecutionMode() {
        if (this.lcaProtocol != null) {
            return this.lcaProtocol.getExecutionMode();
        }
        return null;
    }

    public Integer getControlStatus() {
        if (this.lcaProtocol != null) {
            return this.lcaProtocol.getControlStatus();
        }
        return null;
    }

    private void doResponseExecutionModeChanged(Integer referenceId) {
        ResponseExecutionModeChanged theResponse = ResponseExecutionModeChanged.create();
        if (referenceId != null) {
            theResponse.setReferenceId(referenceId);
        }
        if (this.lcaProtocol.getProcessId() > 0) {
            theResponse.setProcessId(this.lcaProtocol.getProcessId());
        }
        theResponse.setExecutionMode(this.lcaProtocol.getExecutionMode());
        try {
            this.lcaProtocol.send((Message)theResponse);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void doUpdateStatus(ApplicationExecutionMode execMode, ApplicationStatus controlStatus) {
        if (controlStatus == null) {
            throw new NullPointerException("controlStatus");
        }
        RequestUpdateStatus theRequest = RequestUpdateStatus.create();
        theRequest.setReferenceId(0);
        if (this.lcaProtocol.getClientName() != null) {
            theRequest.setApplicationName(this.lcaProtocol.getClientName());
        }
        if (this.lcaProtocol.getClientId() != 0) {
            theRequest.setControlObjectId(this.lcaProtocol.getClientId());
        }
        if (execMode != null) {
            theRequest.setExecutionMode(execMode);
        }
        theRequest.setControlStatus(controlStatus.ordinal());
        if (this.lcaProtocol.getProcessId() != -1) {
            theRequest.setProcessId(this.lcaProtocol.getProcessId());
        }
        try {
            this.lcaProtocol.setControlStatus(Integer.valueOf(controlStatus.ordinal()));
            if (execMode != null) {
                this.lcaProtocol.setExecutionMode(execMode);
            }
            this.lcaProtocol.send((Message)theRequest);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void doRequestSCSConnectionStatus() {
        try {
            this.lcaProtocol.send((Message)RequestSCSConnectionStatus.create());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected abstract void onLCAConnectionOpened();

    protected abstract void onLCAConnectionLost(ChannelClosedEvent var1);

    protected abstract void onHostUnderSCSControl(EventHostUnderControl var1);

    protected abstract void onHostOffSCSControl(EventNoControllingSCS var1);

    protected abstract boolean onChangeExecutionMode(ApplicationExecutionMode var1);

    protected abstract void onSuspendApplication();

    protected void onLCAConnectionError(ChannelErrorEvent event) {
    }

    private class LCAChannelListener
    implements ChannelListener {
        private LCAChannelListener() {
        }

        public void onChannelOpened(EventObject event) {
            AbstractServerApp.this.onLCAConnectionOpened();
        }

        public void onChannelClosed(ChannelClosedEvent event) {
            AbstractServerApp.this.onLCAConnectionLost(event);
            if (event != null && event.getCause() != null && AbstractServerApp.this.getExecutionMode() != ApplicationExecutionMode.Exiting && AbstractServerApp.this.lcaReopenTicket == null) {
                AbstractServerApp.this.lcaReopenTicket = TimerFactory.getTimer().schedule(30000L, (TimerAction)new LCAReopenTask());
            }
        }

        public void onChannelError(ChannelErrorEvent event) {
            AbstractServerApp.this.onLCAConnectionError(event);
        }
    }

    private class LCAMessageHandler
    implements MessageHandler {
        private LCAMessageHandler() {
        }

        public void onMessage(Message message) {
            if (message != null) {
                try {
                    Integer referenceId = null;
                    if (message instanceof Referenceable) {
                        referenceId = (Integer)((Referenceable)message).retreiveReference();
                    }
                    switch (message.messageId()) {
                        case 12: {
                            ApplicationExecutionMode newMode = ((EventChangeExecutionMode)message).getExecutionMode();
                            try {
                                if (AbstractServerApp.this.onChangeExecutionMode(newMode)) {
                                    AbstractServerApp.this.lcaProtocol.setExecutionMode(newMode);
                                }
                                break;
                            }
                            finally {
                                AbstractServerApp.this.doResponseExecutionModeChanged(referenceId);
                            }
                        }
                        case 32: {
                            AbstractServerApp.this.onSuspendApplication();
                            AbstractServerApp.this.doUpdateStatus(AbstractServerApp.this.getExecutionMode(), ApplicationStatus.Suspended);
                            break;
                        }
                        case 41: {
                            AbstractServerApp.this.onHostUnderSCSControl((EventHostUnderControl)message);
                            break;
                        }
                        case 42: {
                            AbstractServerApp.this.onHostOffSCSControl((EventNoControllingSCS)message);
                            break;
                        }
                        case 40: {
                            break;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private class LCAReopenTask
    implements TimerAction {
        private LCAReopenTask() {
        }

        public void onTimer() {
            if (AbstractServerApp.this.lcaReopenTicket != null) {
                AbstractServerApp.this.lcaReopenTicket.cancel();
                AbstractServerApp.this.lcaReopenTicket = null;
            }
            if (AbstractServerApp.this.lcaProtocol != null && AbstractServerApp.this.lcaProtocol.getState() != ChannelState.Opened && AbstractServerApp.this.getExecutionMode() != ApplicationExecutionMode.Exiting) {
                try {
                    AbstractServerApp.this.lcaProtocol.beginOpen();
                }
                catch (ProtocolException protocolException) {
                    // empty catch block
                }
            }
        }
    }
}

