/*
 * Decompiled with CFR 0.152.
 */
package sample;

import com.genesyslab.platform.applicationblocks.com.objects.CfgApplication;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.ChannelClosedEvent;
import com.genesyslab.platform.management.protocol.ApplicationExecutionMode;
import com.genesyslab.platform.management.protocol.ApplicationStatus;
import com.genesyslab.platform.management.protocol.localcontrolagent.events.EventHostUnderControl;
import com.genesyslab.platform.management.protocol.localcontrolagent.events.EventNoControllingSCS;
import java.io.FileInputStream;
import java.util.PropertyResourceBundle;
import sample.AbstractServerApp;
import sample.ConfigurationAccessor;

public class SampleServerApp
extends AbstractServerApp {
    private static ILogger logger;
    private int lcaPort;
    private String clientName;
    private String cfgHost;
    private int cfgPort;
    private String cfgUserName;
    private String cfgUserPwd;
    private CfgApplication cfgApp;

    protected static void log(String msg) {
        if (logger == null) {
            logger = Log.getLogger("SampleServerApp");
        }
        logger.info(msg);
    }

    public static void main(String[] args) throws Exception {
        try {
            SampleServerApp theApp = new SampleServerApp();
            theApp.Init();
            theApp.Execute();
        }
        catch (Exception e) {
            SampleServerApp.log(e.toString());
        }
    }

    public void Execute() throws Exception {
        this.openLCA(this.lcaPort, this.cfgApp.getType().ordinal(), this.cfgApp.getName(), this.cfgApp.getDBID());
        SampleServerApp.log("LCA connection opened");
        Thread.sleep(1500L);
        SampleServerApp.log("Application started");
        this.doUpdateStatus(this.getExecutionMode(), ApplicationStatus.Running);
        SampleServerApp.log("Application is \"running\"");
        while (this.getExecutionMode() != ApplicationExecutionMode.Exiting) {
            Thread.sleep(500L);
        }
        SampleServerApp.log("Application is stopping");
        this.doUpdateStatus(this.getExecutionMode(), ApplicationStatus.Stopped);
        this.closeLCA();
        SampleServerApp.log("LCA closed");
    }

    public void Init() throws Exception {
        SampleServerApp.log("Reading application properties...");
        PropertyResourceBundle properties = new PropertyResourceBundle(new FileInputStream("SampleServerApp.properties"));
        StringBuilder sb = new StringBuilder();
        for (String key : properties.keySet()) {
            sb.append(key).append("=").append(properties.getString(key)).append("\n");
        }
        SampleServerApp.log("\n" + sb.toString());
        this.clientName = properties.getString("ClientName");
        try {
            this.lcaPort = Integer.parseInt(properties.getString("LCAPort"));
        }
        catch (Exception e) {
            throw new Exception("Invalid LCA port");
        }
        this.cfgHost = properties.getString("ConfigServerHost");
        try {
            this.cfgPort = Integer.parseInt(properties.getString("ConfigServerPort"));
        }
        catch (Exception e) {
            throw new Exception("Invalid Configuration Server port");
        }
        this.cfgUserName = properties.getString("UserName");
        this.cfgUserPwd = properties.getString("Password");
        this.cfgApp = this.RetrieveApplicationConfiguration(this.cfgHost, this.cfgPort, this.cfgUserName, this.cfgUserPwd, this.clientName);
    }

    private CfgApplication RetrieveApplicationConfiguration(String host, int port, String UserName, String UserPwd, String appName) throws Exception {
        ConfigurationAccessor accessor = new ConfigurationAccessor();
        accessor.Initialize(host, port, UserName, UserPwd, appName);
        CfgApplication application = null;
        try {
            accessor.Connect();
            application = accessor.RetrieveApplication(appName);
            if (application == null) {
                throw new Exception("Specified application not found!");
            }
        }
        finally {
            accessor.Disconnect();
        }
        SampleServerApp.log(String.format("Got application setting from config server: \n Name=%s, \n DBID=%s", application.getName(), application.getDBID()));
        return application;
    }

    protected boolean onChangeExecutionMode(ApplicationExecutionMode execMode) {
        SampleServerApp.log("Changing execution mode to " + execMode + "...");
        return true;
    }

    protected void onSuspendApplication() {
        SampleServerApp.log("Do application suspend...");
    }

    protected void onLCAConnectionOpened() {
        SampleServerApp.log("LCA connected");
    }

    protected void onLCAConnectionLost(ChannelClosedEvent event) {
        SampleServerApp.log("LCA lost");
    }

    protected void onHostUnderSCSControl(EventHostUnderControl event) {
        SampleServerApp.log("Under SCS control (" + event.getSCSApplicationName() + ")");
    }

    protected void onHostOffSCSControl(EventNoControllingSCS event) {
        SampleServerApp.log("No SCS control");
    }
}

