/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.configuration.protocol;

import com.genesyslab.platform.commons.GEnum;
import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.connection.configuration.ServerContext;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.ChannelNotOpenedException;
import com.genesyslab.platform.commons.protocol.ChannelState;
import com.genesyslab.platform.commons.protocol.IllegalAttributeValueException;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.ProtocolException;
import com.genesyslab.platform.commons.protocol.runtime.DataSupport;
import com.genesyslab.platform.commons.util.ResourcesUtil;
import com.genesyslab.platform.commons.xml.XmlUtil;
import com.genesyslab.platform.commons.xmlfactory.XmlFactories;
import com.genesyslab.platform.configuration.protocol.ConfServerProtocol;
import com.genesyslab.platform.configuration.protocol.confserver.requests.objects.RequestReadObjects2;
import com.genesyslab.platform.configuration.protocol.confserver.runtime.channel.EventSchemaFile;
import com.genesyslab.platform.configuration.protocol.confserver.runtime.channel.EventSchemaInfoRead;
import com.genesyslab.platform.configuration.protocol.confserver.runtime.channel.RequestReadSchemaInfo;
import com.genesyslab.platform.configuration.protocol.confserver.runtime.channel.RequestSchemaFile;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttribute;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionObject;
import com.genesyslab.platform.configuration.protocol.metadata.CfgMetadata;
import com.genesyslab.platform.configuration.protocol.types.CfgObjectType;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConfServerContext
implements ServerContext {
    private final ILogger log = Log.getLogger(ConfServerContext.class);
    static final String PROTOCOL_PREFIX = "CfgProtocol 5.1.";
    static final String CLIENT_PROTOCOL_VERSION = "CfgProtocol 5.1.3.80";
    static final int AES_SUPPORT_PROTOCOL_ID = 365;
    static final String CFG_LIB_XSL = "resources/confschema.xsl";
    static final String SERVER_OPTIONS_SCHEMA_FILE_NAME = "cfgservermetadata.xml";
    public static final String SCHEMA_FILE_NAME = "resources/cfglibschema.xml";
    public static final String SERVER_SCHEMA_FILE_NAME = "cfglibschema.xml";
    private ConfServerProtocol channel;
    private String serverProtocolVersion;
    private String serverVersion;
    private String localeVersion;
    private String boundProtocolVersion = "CfgProtocol 5.1.3.80";
    private String description = null;
    private Document serverOptionsDescription = null;
    private CfgMetadata metadata;
    private KeyValueCollection lastLoginInfo;
    private Document cfgLastLogin;
    private byte[] configSchemaBytes;
    private Integer externalAuthentication = null;
    private Integer serverEncoding = null;
    private int sessionId = 0;
    private int lastUpdateId;
    private boolean isSessionRestored = false;
    private int dbid;
    private int backupDbid;

    ConfServerContext(ConfServerProtocol clientChannel) {
        this.channel = clientChannel;
        this.serverProtocolVersion = null;
    }

    public String getServerVersion() {
        try {
            RequestReadSchemaInfo readSchemaInfoRequest;
            EventSchemaInfoRead eventSchemaInfoRead;
            Document xmlDoc;
            Element cfgLibSchema;
            Element cfgServerVersion;
            Element szVersion;
            if (this.serverVersion == null && this.channel.getState() == ChannelState.Opened && (szVersion = XmlUtil.getFirstChild((Element)(cfgServerVersion = XmlUtil.getFirstChild((Element)(cfgLibSchema = XmlUtil.getFirstChild((Element)(xmlDoc = (eventSchemaInfoRead = (EventSchemaInfoRead)this.channel.request(readSchemaInfoRequest = RequestReadSchemaInfo.create())).getSchemaInfo()).getDocumentElement())), (String)"CfgServerVersion")), (String)"szVersion")) != null) {
                this.serverVersion = szVersion.getAttributes().getNamedItem("value").getNodeValue();
            }
        }
        catch (ProtocolException e) {
            this.log.debug((Object)"Failed to request server version", (Throwable)e);
        }
        catch (Exception e) {
            this.log.debug((Object)"Failed to retreive server version from response", (Throwable)e);
        }
        return this.serverVersion;
    }

    public String getProtocolVersion() {
        return this.boundProtocolVersion;
    }

    void setProtocolVersion(String value) {
        this.boundProtocolVersion = value;
    }

    public String getServerProtocolVersion() {
        return this.serverProtocolVersion;
    }

    void setServerProtocolVersion(String value) {
        this.serverProtocolVersion = value;
    }

    public String getLocaleVersion() {
        return this.localeVersion;
    }

    void setLocaleVersion(String value) {
        this.localeVersion = value;
    }

    public String getDescription() {
        return this.description;
    }

    void setDescription(String description) {
        this.description = description;
    }

    public CfgMetadata getMetadata() {
        if (this.metadata == null) {
            try {
                this.metadata = new CfgMetadata();
            }
            catch (ProtocolException e) {
                this.log.error((Object)"Exception loading configuration metadata", (Throwable)e);
            }
        }
        return this.metadata;
    }

    public KeyValueCollection getLastLoginInfo() {
        return this.lastLoginInfo;
    }

    void setLastLoginInfo(KeyValueCollection value) {
        this.lastLoginInfo = value;
    }

    public Document getCfgLastLogin() {
        if (this.cfgLastLogin != null) {
            return this.cfgLastLogin;
        }
        if (this.lastLoginInfo == null) {
            return null;
        }
        String ns = ConfServerProtocol.PROTOCOL_DESCRIPTION.getNS();
        try {
            this.cfgLastLogin = XmlFactories.newDocumentBuilder((boolean)CfgMetadata.useConfDataNs).newDocument();
            this.cfgLastLogin.setXmlVersion("1.0");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Element xRootElement = this.cfgLastLogin.createElementNS(ns, "ConfData");
        this.cfgLastLogin.appendChild(xRootElement);
        CfgDescriptionObject cfgPersonLastLogin = this.metadata.getCfgClass(CfgDescriptionObject.class, CfgObjectType.CFGPersonLastLogin);
        Element xObject = this.cfgLastLogin.createElementNS(ns, cfgPersonLastLogin.getName());
        for (CfgDescriptionAttribute attr : cfgPersonLastLogin.getAttributes()) {
            Integer iv;
            String val;
            if (!attr.getName().equals("personDBID") && !attr.getName().equals("lastLoginTime")) continue;
            Element attrXElement = this.cfgLastLogin.createElementNS(ns, attr.getName());
            if (attr.getName().equals("personDBID")) {
                val = this.lastLoginInfo.getString("LAST_LOGIN_PERSON");
                if (val == null && (iv = this.lastLoginInfo.getInt("LAST_LOGIN_PERSON")) != null) {
                    val = iv.toString();
                }
                attrXElement.setAttribute("value", val);
            } else if (attr.getName().equals("lastLoginTime")) {
                val = this.lastLoginInfo.getString("LAST_LOGIN_TIME");
                if (val == null && (iv = this.lastLoginInfo.getInt("LAST_LOGIN_TIME")) != null) {
                    val = iv.toString();
                }
                attrXElement.setAttribute("value", val);
            }
            xObject.appendChild(attrXElement);
        }
        xRootElement.appendChild(xObject);
        return this.cfgLastLogin;
    }

    byte[] getConfigSchemaBytes() {
        return this.configSchemaBytes;
    }

    void setConfigSchemaBytes(byte[] value) {
        this.configSchemaBytes = value;
    }

    public Integer getServerEncoding() {
        return this.serverEncoding;
    }

    void setServerEncoding(Integer serverEncoding) {
        this.serverEncoding = serverEncoding;
    }

    public Integer getExternalAuthentication() {
        return this.externalAuthentication;
    }

    void setExternalAuthentication(Integer extAuthentication) {
        this.externalAuthentication = extAuthentication;
    }

    public boolean isSessionRestored() {
        return this.isSessionRestored;
    }

    void setIsSessionRestored(boolean value) {
        this.isSessionRestored = value;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    void setSessionId(int value) {
        this.sessionId = value;
    }

    public int getLastUpdateId() {
        return this.lastUpdateId;
    }

    void setLastUpdateId(int value) {
        this.lastUpdateId = value;
    }

    public void getSchema(Result result) throws TransformerException {
        Element schemaElem = null;
        if (this.getMetadata() != null) {
            schemaElem = this.getMetadata().getObjectSchema();
        }
        if (schemaElem == null) {
            throw new ChannelNotOpenedException("Schema is unavailable. Open the channel first");
        }
        InputStream xslStream = ResourcesUtil.getResourceAsStream((String)CFG_LIB_XSL, this.getClass());
        Transformer transformer = XmlFactories.newTransformer((Source)new StreamSource(xslStream));
        transformer.setOutputProperty("indent", "yes");
        transformer.setParameter("protocolVersion", this.boundProtocolVersion);
        transformer.setParameter("protocolId", String.valueOf(this.getProtocolId(this.boundProtocolVersion)));
        transformer.setParameter("useNs", CfgMetadata.useConfDataNs);
        transformer.transform(new DOMSource(schemaElem.getOwnerDocument()), result);
    }

    void onChannelOpened() {
    }

    void onChannelClosed() {
        this.serverVersion = null;
        this.configSchemaBytes = null;
        this.metadata = null;
        this.serverProtocolVersion = null;
        this.boundProtocolVersion = CLIENT_PROTOCOL_VERSION;
        this.isSessionRestored = false;
        this.description = null;
        this.serverOptionsDescription = null;
        this.dbid = 0;
        this.backupDbid = 0;
        this.lastLoginInfo = null;
        this.cfgLastLogin = null;
        this.externalAuthentication = null;
        this.serverEncoding = null;
        this.localeVersion = null;
    }

    void onSend(Message message) throws ProtocolException {
        Integer objectType = null;
        Integer xpathQType = null;
        switch (message.messageId()) {
            case 83: {
                int pos;
                String xpath = ((RequestReadObjects2)message).getXPathExpression();
                if (xpath == null) {
                    throw new IllegalAttributeValueException("Required attribute is missing", "RequestReadObjects2", "XPathExpression");
                }
                if ((xpath = xpath.trim()).equals("")) {
                    throw new IllegalAttributeValueException("Required attribute value is empty string", "RequestReadObjects2", "XPathExpression");
                }
                if (xpath.startsWith("Cfg") && (pos = xpath.indexOf(91)) > 0) {
                    try {
                        CfgObjectType objType = (CfgObjectType)GEnum.getValue(CfgObjectType.class, (String)("CFG" + xpath.substring(3, pos)));
                        if (objType != null) {
                            xpathQType = objType.ordinal();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 28: {
                try {
                    Object val = ((DataSupport)message).attributes().get("ObjectType");
                    if (val instanceof Integer) {
                        objectType = (Integer)val;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (objectType == null) {
                    throw new IllegalAttributeValueException("Required attribute is missing", message.messageName(), "ObjectType");
                }
                if (objectType > 0) break;
                throw new IllegalAttributeValueException("Illegal object type value - must be positive number", message.messageName(), "ObjectType");
            }
        }
        if (xpathQType != null && objectType != null && !xpathQType.equals(objectType)) {
            throw new IllegalAttributeValueException("Conflicting request attributes values", message.messageName(), "XPathExpression and ObjectType");
        }
        if (this.getMetadata().getProtocolVersion() < 373 && objectType != null && objectType >= CfgObjectType.CFGRole.ordinal()) {
            String objType;
            try {
                objType = GEnum.getValue(CfgObjectType.class, (Integer)objectType).name() + "(" + objectType + ")";
            }
            catch (Exception e) {
                objType = Integer.toString(objectType);
            }
            throw new ProtocolException("Object type " + objType + " is not supported by the Configuration Server, protocol version '" + this.getMetadata().getProtocolVersion() + "'");
        }
    }

    int getProtocolId(String protocolVersion) {
        int protocolId = 0;
        if (protocolVersion.startsWith(PROTOCOL_PREFIX)) {
            StringBuffer buf = new StringBuffer(protocolVersion.substring(PROTOCOL_PREFIX.length()));
            protocolId = Integer.parseInt(buf.deleteCharAt(1).toString());
        }
        return protocolId;
    }

    public int getDbid() {
        return this.dbid;
    }

    void setDbid(int dbid) {
        this.dbid = dbid;
    }

    public int getBackupDbid() {
        return this.backupDbid;
    }

    void setBackupDbid(int backupDbid) {
        this.backupDbid = backupDbid;
    }

    public Document getServerOptionsDescription() throws ProtocolException, ParserConfigurationException, TransformerException {
        EventSchemaFile eventSchemaFile;
        RequestSchemaFile requestSchemaFile;
        Message eventMessage;
        if (this.serverOptionsDescription == null && this.channel.getState() == ChannelState.Opened && (eventMessage = this.channel.request(requestSchemaFile = RequestSchemaFile.create(SERVER_OPTIONS_SCHEMA_FILE_NAME))) instanceof EventSchemaFile && (eventSchemaFile = (EventSchemaFile)eventMessage).getSchemaFileContent() != null) {
            Document resDoc = XmlUtil.createDocument();
            Transformer transformer = XmlFactories.newTransformer();
            transformer.transform(new StreamSource(new StringReader(eventSchemaFile.getSchemaFileContent())), new DOMResult(resDoc));
            this.serverOptionsDescription = resDoc;
        }
        return this.serverOptionsDescription;
    }
}

