/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.configuration.protocol;

import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.processor.KeyValuePrinter;
import com.genesyslab.platform.commons.connection.ConnectionClosedEvent;
import com.genesyslab.platform.commons.connection.configuration.ConnectionConfiguration;
import com.genesyslab.platform.commons.connection.interceptor.AddpInterceptor;
import com.genesyslab.platform.commons.connection.interceptor.Interceptor;
import com.genesyslab.platform.commons.connection.tls.SSLExtendedOptions;
import com.genesyslab.platform.commons.connection.tls.TLSConfiguration;
import com.genesyslab.platform.commons.connection.tls.TLSConfigurationParser;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.ChannelNotClosedException;
import com.genesyslab.platform.commons.protocol.ChannelState;
import com.genesyslab.platform.commons.protocol.ClientChannel;
import com.genesyslab.platform.commons.protocol.Endpoint;
import com.genesyslab.platform.commons.protocol.IntReferenceBuilder;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.ProtocolDescription;
import com.genesyslab.platform.commons.protocol.ProtocolException;
import com.genesyslab.platform.commons.protocol.ProtocolFactory;
import com.genesyslab.platform.commons.protocol.ReferenceBuilder;
import com.genesyslab.platform.commons.protocol.RegistrationException;
import com.genesyslab.platform.commons.protocol.auth.AuthTicket;
import com.genesyslab.platform.commons.protocol.auth.AuthTicketAcquirer;
import com.genesyslab.platform.commons.protocol.auth.AuthTicketAcquirerException;
import com.genesyslab.platform.commons.protocol.auth.DefaultAuthTicketAcquirer;
import com.genesyslab.platform.commons.protocol.runtime.DataSupport;
import com.genesyslab.platform.commons.protocol.runtime.codec.TKVCodec;
import com.genesyslab.platform.commons.util.ResourcesUtil;
import com.genesyslab.platform.configuration.protocol.ConfServerContext;
import com.genesyslab.platform.configuration.protocol.ConfServerProtocolHandshakeOptions;
import com.genesyslab.platform.configuration.protocol.confserver.ConfServerProtocolFactory;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventError;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventLocaleRead;
import com.genesyslab.platform.configuration.protocol.confserver.requests.connectivity.RequestHistoryLog;
import com.genesyslab.platform.configuration.protocol.confserver.requests.locale.RequestReadLocale;
import com.genesyslab.platform.configuration.protocol.confserver.runtime.ConfServerInternalProtocolFactory;
import com.genesyslab.platform.configuration.protocol.confserver.runtime.channel.EventClientRegistered;
import com.genesyslab.platform.configuration.protocol.confserver.runtime.channel.EventProtocolVersion;
import com.genesyslab.platform.configuration.protocol.confserver.runtime.channel.EventSchemaFile;
import com.genesyslab.platform.configuration.protocol.confserver.runtime.channel.RequestProtocolVersion;
import com.genesyslab.platform.configuration.protocol.confserver.runtime.channel.RequestRegisterClient;
import com.genesyslab.platform.configuration.protocol.confserver.runtime.channel.RequestRegisterClient2;
import com.genesyslab.platform.configuration.protocol.confserver.runtime.channel.RequestRestoreSession;
import com.genesyslab.platform.configuration.protocol.confserver.runtime.channel.RequestSchemaFile;
import com.genesyslab.platform.configuration.protocol.exceptions.ChangePasswordException;
import com.genesyslab.platform.configuration.protocol.metadata.CfgMetadata;
import com.genesyslab.platform.configuration.protocol.runtime.channel.AesUtil;
import com.genesyslab.platform.configuration.protocol.runtime.channel.ObjectSerializerV6;
import com.genesyslab.platform.configuration.protocol.runtime.channel.ObjectSerializerV7;
import com.genesyslab.platform.configuration.protocol.runtime.channel.Serializer;
import com.genesyslab.platform.configuration.protocol.runtime.codec.AesCodec;
import com.genesyslab.platform.configuration.protocol.runtime.codec.XmlDocumentCodecV6;
import com.genesyslab.platform.configuration.protocol.runtime.codec.XmlDocumentCodecV7;
import com.genesyslab.platform.configuration.protocol.types.CfgErrorType;
import com.genesyslab.platform.configuration.protocol.utilities.CfgUtilities;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.net.ssl.SSLContext;
import org.w3c.dom.Document;

@ProtocolDescription.Tag(sdkName="Configuration", protocolName="ConfServer")
public final class ConfServerProtocol
extends ClientChannel
implements ConfServerProtocolHandshakeOptions {
    public static final String CONF_OBJECTS_NAMESPACE = "com.genesyslab.platform.configuration.protocol.useConfDataNs";
    private static final int KERBEROS_SUPPORT_VERSION = 379;
    private static final int GSS_SUPPORT_VERSION = 380;
    private static final ILogger log = Log.getLogger(ConfServerProtocol.class);
    private ConfProtoData protocolData = new ConfProtoData();
    private final ConfServerContext context;
    private int clientType;
    private String clientName;
    private String userName;
    private String userPassword;
    private AuthTicketAcquirer ticketAcquirer;
    private boolean forwardCompatible = false;
    private boolean useSession = false;
    private volatile boolean useDeltaOptimization = true;
    private String newUserPassword;
    private Serializer serializer = ConfServerProtocol.getSerializer();
    public static final ProtocolDescription PROTOCOL_DESCRIPTION = ConfServerProtocolFactory.PROTOCOL_DESCRIPTION;

    public ConfServerProtocol(Endpoint endpoint) {
        this(endpoint, true);
    }

    public ConfServerProtocol(Endpoint endpoint, boolean initCrypto) {
        this(endpoint, 30000L, initCrypto);
    }

    public ConfServerProtocol(Endpoint endpoint, long timeout, boolean initCrypto) {
        super(endpoint, (ProtocolFactory)new ConfServerInternalProtocolFactory(), (ReferenceBuilder)new IntReferenceBuilder(), timeout);
        if (initCrypto) {
            ConfServerProtocol.initCrypto();
        }
        this.initSystemProperties();
        this.clientType = 0;
        this.clientName = endpoint.getName();
        this.context = new ConfServerContext(this);
        this.setServerContext(this.context);
    }

    public void useChangePasswordRegistration(String newUserPassword) {
        this.throwNotClosed();
        this.newUserPassword = newUserPassword;
    }

    public ConfServerContext getServerContext() {
        return this.context;
    }

    public static void initCrypto() {
        try {
            Cipher.getInstance("AES/ECB/PKCS5Padding");
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
    }

    public boolean getUseConfDataNs() {
        return CfgMetadata.useConfDataNs;
    }

    public void setUseConfDataNs(boolean useConfDataNs) {
        if (this.getState() != ChannelState.Closed) {
            throw new ChannelNotClosedException("Namespace usage cannot be changed when protocol connection is not closed");
        }
        CfgMetadata.useConfDataNs = useConfDataNs;
        this.context.getMetadata().setObjectSchema(this.context.getMetadata().getObjectSchema());
    }

    public int getClientApplicationType() {
        return this.clientType;
    }

    public void setClientApplicationType(int clientType) {
        this.clientType = clientType;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public void setUserPassword(String userPassword) {
        this.userPassword = userPassword;
    }

    @Deprecated
    public boolean getUseForwardCompatibility() {
        return this.forwardCompatible;
    }

    @Deprecated
    public void setUseForwardCompatibility(boolean value) {
        this.forwardCompatible = false;
    }

    @Deprecated
    public boolean getUseDeltaOptimization() {
        return this.useDeltaOptimization;
    }

    @Deprecated
    public void setUseDeltaOptimization(boolean value) {
        this.useDeltaOptimization = value;
    }

    public boolean getUseSession() {
        return this.useSession;
    }

    public void setUseSession(boolean useSession) {
        this.useSession = useSession;
    }

    public boolean useLocalization() {
        return CfgMetadata.useLocalization;
    }

    public void setUseLocalization(boolean value) {
        if (this.getState() != ChannelState.Closed) {
            throw new ChannelNotClosedException("Localization usage cannot be changed when protocol connection is not closed");
        }
        CfgMetadata.useLocalization = value;
    }

    public void setTKVPrinter(KeyValuePrinter printer) {
        this.protocolData.setPrinter(printer);
        this.setProtocolData(this.protocolData);
    }

    protected void onOpen() throws ProtocolException {
        this.context.onChannelOpened();
        this.setRegistrationHandler(new ConfServerRegistrationHandler());
        super.onOpen();
        if (this.useSession && this.context.isSessionRestored()) {
            RequestHistoryLog requestHistoryLog = RequestHistoryLog.create(0, this.context.getLastUpdateId());
            this.send(requestHistoryLog);
        }
    }

    protected void onClose(ConnectionClosedEvent event) {
        this.context.onChannelClosed();
        super.onClose(event);
    }

    protected void onReceiveMessage(Message message) {
        Integer lastId = (Integer)message.getMessageAttribute("UnsolisitedEventNumber");
        if (lastId != null) {
            this.context.setLastUpdateId(lastId);
        }
        if (message.messageId() == 4) {
            log.info((Object)"EventError2 received.");
        }
        super.onReceiveMessage(message);
    }

    protected void onSend(Message message) throws ProtocolException {
        this.context.onSend(message);
        if (this.serializer == null) {
            throw new ProtocolException("No serializer for message");
        }
        this.serializer.serialize1(message);
        super.onSend(message);
    }

    private void initSystemProperties() {
        try {
            String confDataNS = System.getProperty(CONF_OBJECTS_NAMESPACE);
            if (confDataNS != null) {
                this.setUseConfDataNs(Boolean.parseBoolean(confDataNS));
            }
        }
        catch (Exception e) {
            log.debug((Object)"parsing system properties error", (Throwable)e);
        }
    }

    void setProtocolDataPhase1() {
        this.protocolData.setConfAesUtility(new AesUtil());
        this.setProtocolData(this.protocolData);
    }

    void setProtocolDataPhase2() {
        ObjectSerializerV6 serializerV6 = new ObjectSerializerV6(this.context.getMetadata(), this.protocolData.getConfAesUtility(), this.useDeltaOptimization);
        ObjectSerializerV7 serializerV7 = new ObjectSerializerV7(this.context.getMetadata(), this.protocolData.getConfAesUtility(), this.useDeltaOptimization);
        this.protocolData.setSerializerV6(serializerV6);
        this.protocolData.setSerializerV7(serializerV7);
        this.setObjectSerializerEncoding();
        if (this.context.getProtocolId(this.context.getProtocolVersion()) < 365) {
            this.setProtocolData(this.protocolData);
        }
    }

    private void setObjectSerializerEncoding() {
        if (this.protocolData != null) {
            ObjectSerializerV6 srl6 = this.protocolData.getSerializerV6();
            ObjectSerializerV7 srl7 = this.protocolData.getSerializerV7();
            if (srl6 != null || srl7 != null) {
                String strEncoding = null;
                Endpoint ep = this.getEndpoint();
                ConnectionConfiguration conf = ep.getConfiguration();
                if (conf != null) {
                    strEncoding = conf.getOption("string-attributes-encoding");
                }
                if (srl6 != null) {
                    srl6.setStringAttributesEncoding(strEncoding);
                }
                if (srl7 != null) {
                    srl7.setStringAttributesEncoding(strEncoding);
                }
            }
        }
    }

    private static Serializer getSerializer() {
        Serializer serializer = null;
        try {
            InputStream stream = ResourcesUtil.getResourceAsStream((String)"resources/serializer.ser", ConfServerProtocol.class);
            if (stream != null) {
                ObjectInputStream objStream = new ObjectInputStream(stream);
                Object obj = objStream.readObject();
                if (obj instanceof Serializer) {
                    return (Serializer)obj;
                }
                log.debug((Object)"Loaded object is not Serializer");
            }
            log.debug((Object)"No Serializer found");
        }
        catch (Exception e) {
            log.debug((Object)"Failed to load Serializer", (Throwable)e);
        }
        return serializer;
    }

    public AuthTicketAcquirer getTicketAcquirer() {
        return this.ticketAcquirer;
    }

    public void setTicketAcquirer(AuthTicketAcquirer ticketAcquirer) {
        this.ticketAcquirer = ticketAcquirer;
    }

    private static class RegistrationStep {
        private Message requestMessage;
        private int responseMessageId;

        public RegistrationStep(Message request, int responseId) {
            this.requestMessage = request;
            this.responseMessageId = responseId;
        }

        public Message getRequestMessage() {
            return this.requestMessage;
        }

        public int getResponseMessageId() {
            return this.responseMessageId;
        }
    }

    private static class TicketHexData {
        String hex;
        boolean gss;

        public TicketHexData(String hex, boolean gss) {
            this.hex = hex;
            this.gss = gss;
        }
    }

    private class ConfServerRegistrationHandler
    implements ClientChannel.RegistrationHandler {
        public static final int ENCODING_ASC = 0;
        public static final int ENCODING_MULTILINGUAL = 1;
        public static final int STEP_REG = 1;
        private ConfServerProtocol channel;
        private boolean registrationComplete;
        private List<RegistrationStep> registrationExchanges;
        private int registrationStep;
        private boolean runtimeUseSession;
        private boolean runtimeSessionRestored;
        private volatile boolean isMetadataLoaded;

        ConfServerRegistrationHandler() throws ProtocolException {
            this.channel = ConfServerProtocol.this;
            this.registrationComplete = false;
            this.registrationExchanges = new ArrayList<RegistrationStep>(4);
            this.registrationStep = 0;
            this.runtimeUseSession = false;
            this.runtimeSessionRestored = false;
            this.isMetadataLoaded = false;
            this.reset();
        }

        public void reset() throws ProtocolException {
            this.registrationStep = 0;
            this.setRegistrationComplete(false);
            this.isMetadataLoaded = false;
            this.runtimeUseSession = this.channel.getUseSession();
            if (this.registrationExchanges.size() > 0) {
                this.registrationExchanges.clear();
            }
            RequestProtocolVersion requestProtocol = RequestProtocolVersion.create();
            requestProtocol.setSecureLibrary(1);
            requestProtocol.setClientName(this.channel.getClientName());
            requestProtocol.setProtocolVersion(this.channel.context.getProtocolVersion());
            this.registrationExchanges.add(new RegistrationStep(requestProtocol, 50));
            Message requestRegister = this.createRequestRegister();
            this.registrationExchanges.add(new RegistrationStep(requestRegister, 19));
            RequestSchemaFile requestSchema = RequestSchemaFile.create("cfglibschema.xml");
            this.registrationExchanges.add(new RegistrationStep(requestSchema, 72));
            if (this.channel.useLocalization()) {
                RequestReadLocale requestLocale = RequestReadLocale.create(0);
                this.registrationExchanges.add(new RegistrationStep(requestLocale, 59));
            }
        }

        public Message getRegistrationMessage() {
            Interceptor in;
            Message request = this.registrationExchanges.get(this.registrationStep).getRequestMessage();
            ConfServerProtocol channel = ConfServerProtocol.this;
            ((DataSupport)request).attributes().put("ReferenceId", channel.getReferenceBuilder().createReference());
            if (request instanceof RequestProtocolVersion && (in = ConfServerProtocol.this.getInterceptor()) instanceof AddpInterceptor) {
                log.debug((Object)"Pausing ADDP to prevent interference.");
                ((AddpInterceptor)in).setSuppressed(true);
            }
            if (request instanceof RequestRegisterClient) {
                this.setAuthorizationData(request);
            }
            this.logRequest(request);
            return request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean handleResponse(Message response) throws ProtocolException {
            boolean accepted = false;
            RegistrationException abortReason = null;
            try {
                accepted = this.isResponseAccepted(response);
            }
            catch (RegistrationException e) {
                abortReason = e;
            }
            finally {
                if (!accepted) {
                    this.setRegistrationComplete(false);
                    if (response == null) {
                        throw new ProtocolException("Registration stopped (timeout reached or server response lost)");
                    }
                    if (log.isDebug()) {
                        log.debug((Object)"Response is not accepted, registration failed, closing channel");
                    }
                    this.throwAbortReason(abortReason);
                }
            }
            if (response.messageId() == 50) {
                this.handleEventProtocolVersion((EventProtocolVersion)response);
            } else if (response.messageId() == 19) {
                this.handleEventClientRegistered((EventClientRegistered)response);
            } else if (response.messageId() == 72) {
                this.handleEventSchemaFile((EventSchemaFile)response);
            } else if (response.messageId() == 59) {
                this.handleEventLocaleRead((EventLocaleRead)response);
            }
            if (this.isMetadataLoaded) {
                this.channel.setProtocolDataPhase2();
            }
            return accepted;
        }

        public boolean isRegistrationComplete() {
            return this.registrationComplete;
        }

        private boolean isResponseAccepted(Message response) throws RegistrationException {
            RegistrationStep step = this.registrationExchanges.get(this.registrationStep);
            if (response.messageId() == step.getResponseMessageId()) {
                if (++this.registrationStep == this.registrationExchanges.size()) {
                    this.setRegistrationComplete(true);
                }
                return true;
            }
            if (response instanceof EventError) {
                EventError eventError = (EventError)response;
                if (this.handleEventError(eventError)) {
                    return true;
                }
                String errMessage = "Error registering. Code: " + eventError.getErrorCode() + "; " + eventError.getDescription();
                if (CfgUtilities.getErrorType(eventError.getErrorCode()) == CfgErrorType.CFGUserMustChangePassword) {
                    throw new ChangePasswordException(errMessage, eventError);
                }
                throw new RegistrationException(errMessage, response);
            }
            if (log.isWarn()) {
                log.warn((Object)("Unexpected message registering client: " + response));
            }
            return false;
        }

        private void throwAbortReason(RegistrationException abortReason) throws RegistrationException {
            if (abortReason != null) {
                throw abortReason;
            }
            throw new RegistrationException("Client registration failed");
        }

        private void updateConnectionEncodingToUTF8() {
            ConnectionConfiguration config = this.channel.getEndpoint().getConfiguration();
            if (config != null) {
                config.setOption("string-attributes-encoding", "UTF-8");
            }
        }

        private void handleEventProtocolVersion(EventProtocolVersion response) throws ProtocolException {
            int serverProtocolId;
            int boundProtocolId;
            Interceptor in;
            if (response.getErrorCode() != null && response.getErrorCode().intValue() == CfgErrorType.CFGUnsecureConnectionDenied.ordinal()) {
                String secParams;
                if (log.isInfo()) {
                    log.info((Object)"Unsecure connection denied, trying to upgrade connection to TLS...");
                }
                if (null == (secParams = response.getSecurityParams()) || 0 == secParams.length()) {
                    log.warn((Object)"Empty TLS parameters received from Config Server.");
                    if (null == ConfServerProtocol.this.connectionContext().getAttribute("com.genesyslab.platform.commons.connection.SSLContext")) {
                        log.warn((Object)"SSLContext is not configured for the protocol, will use TLS compatibility mode.");
                    }
                } else {
                    log.info((Object)"Trying to configure TLS with parameters received from Config Server...");
                    try {
                        TLSConfiguration tlsConf = TLSConfigurationParser.parseClientTlsConfiguration((String)response.getSecurityParams());
                        if (tlsConf.isTargetNameCheckEnabled() && (null == tlsConf.getExpectedHostname() || 0 == tlsConf.getExpectedHostname().length())) {
                            tlsConf.setExpectedHostname(ConfServerProtocol.this.getEndpoint().getHost());
                        }
                        SSLContext sslContext = tlsConf.createSslContext();
                        SSLExtendedOptions sslOptions = tlsConf.createSslExtendedOptions();
                        ConfServerProtocol.this.connectionContext().setAttribute("tls", (Object)tlsConf.isTlsEnabled());
                        ConfServerProtocol.this.connectionContext().setAttribute("com.genesyslab.platform.commons.connection.SSLContext", (Object)sslContext);
                        ConfServerProtocol.this.connectionContext().setAttribute("com.genesyslab.platform.commons.connection.SSLExtendedOptions", (Object)sslOptions);
                    }
                    catch (Exception e) {
                        throw new ProtocolException("Could not configure TLS", (Throwable)e);
                    }
                }
                if (this.channel.upgradeConnection()) {
                    if (log.isInfo()) {
                        log.info((Object)"Connection upgraded to TLS.");
                    }
                } else if (log.isWarn()) {
                    log.warn((Object)"Unsecure connection denied, failed TLS initialization or existing implementation does not allow automatic connection upgrade.");
                }
            }
            if ((in = ConfServerProtocol.this.getInterceptor()) instanceof AddpInterceptor) {
                log.debug((Object)"Re-enabling ADDP.");
                ((AddpInterceptor)in).setSuppressed(false);
            }
            ConfServerProtocol.this.context.setServerProtocolVersion(response.getOldProtocolVersion());
            Integer integerServerEncoding = response.getServerEncoding();
            if (integerServerEncoding != null) {
                Message msg = this.registrationExchanges.get(1).getRequestMessage();
                if (msg.messageId() == 3) {
                    ((RequestRegisterClient)msg).setClientEncoding(integerServerEncoding);
                } else if (msg.messageId() == 103) {
                    ((RequestRegisterClient2)msg).setClientEncoding(integerServerEncoding);
                }
                if (!integerServerEncoding.equals(ConfServerProtocol.this.context.getServerEncoding())) {
                    this.setServerEncoding(integerServerEncoding);
                }
            }
            if ((boundProtocolId = ConfServerProtocol.this.context.getProtocolId(ConfServerProtocol.this.context.getProtocolVersion())) > (serverProtocolId = ConfServerProtocol.this.context.getProtocolId(ConfServerProtocol.this.context.getServerProtocolVersion())) || ConfServerProtocol.this.forwardCompatible) {
                ConfServerProtocol.this.context.setProtocolVersion(ConfServerProtocol.this.context.getServerProtocolVersion());
                Message reqRegister = this.registrationExchanges.get(1).getRequestMessage();
                if (reqRegister.messageId() == 3) {
                    ((RequestRegisterClient)reqRegister).setProtocolVersion(ConfServerProtocol.this.context.getProtocolVersion());
                } else if (reqRegister.messageId() == 103) {
                    ((RequestRegisterClient2)reqRegister).setProtocolVersion(ConfServerProtocol.this.context.getProtocolVersion());
                } else if (reqRegister.messageId() == 40) {
                    ((RequestRestoreSession)reqRegister).setProtocolVersion(ConfServerProtocol.this.context.getProtocolVersion());
                }
            }
            log.infoFormat("Server Protocol version <{0}> is obtained.", (Object)ConfServerProtocol.this.context.getServerProtocolVersion());
            this.channel.setProtocolDataPhase1();
            if (log.isInfo()) {
                log.info((Object)"Aes Codec is activated.");
            }
        }

        private void handleEventClientRegistered(EventClientRegistered eventClientRegistered) throws RegistrationException {
            this.setSessionId(eventClientRegistered.getSessionId());
            this.setExternalAuthentication(eventClientRegistered.getExternalAuthentication());
            if (!this.isMetadataLoaded) {
                this.setProtocolVersion(eventClientRegistered.getProtocolVersion());
            }
            this.setServerEncoding(eventClientRegistered.getServerEncoding());
            this.setLocaleVersion(eventClientRegistered.getLocaleVersion());
            this.setLastUpdateId(eventClientRegistered.getUnsolisitedEventNumber());
            this.setDescription(eventClientRegistered.getDescription());
            this.setDbid(eventClientRegistered.getServerDbid());
            this.setBackupDbid(eventClientRegistered.getBackupServerDbid());
            if (this.channel.newUserPassword != null) {
                this.channel.setUserPassword(this.channel.newUserPassword);
                this.channel.newUserPassword = null;
            }
            if (ConfServerProtocol.this.context.getProtocolId("CfgProtocol 5.1.3.80") >= ConfServerProtocol.this.context.getProtocolId(ConfServerProtocol.this.context.getProtocolVersion())) {
                if (!this.isMetadataLoaded) {
                    this.bindSchemaProtocol();
                }
                if (this.channel.useLocalization()) {
                    ++this.registrationStep;
                } else {
                    this.setRegistrationComplete(true);
                }
            } else if (log.isInfo()) {
                log.info((Object)"Requesting the Schema from the Server...");
            }
            this.setLastLoginInfo(eventClientRegistered.getParameters2());
        }

        private void handleEventSchemaFile(EventSchemaFile eventSchemaFile) throws RegistrationException {
            this.loadServerSchema(eventSchemaFile.getSchemaFileContent());
            this.bindSchemaProtocol();
            if (log.isInfo()) {
                log.infoFormat("Metadata data is obtained.", (Object)ConfServerProtocol.this.context.getServerProtocolVersion());
            }
        }

        private void handleEventLocaleRead(EventLocaleRead eventLocaleRead) throws RegistrationException {
            Document localesSchema = eventLocaleRead.getSchemaInfo();
            ConfServerProtocol.this.context.getMetadata().setLocalesSchema(CfgUtilities.findChildElement(localesSchema.getDocumentElement().getFirstChild(), "enumTable"));
            if (log.isInfo()) {
                log.infoFormat("Localization data is obtained.", (Object)ConfServerProtocol.this.context.getServerProtocolVersion());
            }
            try {
                ConfServerProtocol.this.context.getMetadata().loadLocales();
            }
            catch (Exception ex) {
                log.warn((Object)"Exception loading locales", (Throwable)ex);
                throw new RegistrationException("Exception loading locales", (Throwable)ex);
            }
            this.setRegistrationComplete(true);
        }

        private boolean handleEventError(EventError eventError) throws RegistrationException {
            boolean handled = false;
            if (this.registrationStep == 0) {
                if (eventError.getErrorCode().intValue() == CfgErrorType.CFGUnknownMessage.ordinal()) {
                    log.warn((Object)"RequestProtocolVersion failed");
                    ++this.registrationStep;
                    handled = true;
                }
            } else if (this.registrationStep == 1) {
                Message request = this.registrationExchanges.get(this.registrationStep).getRequestMessage();
                if (request.messageId() == 40) {
                    this.runtimeSessionRestored = false;
                    log.warn((Object)"RequestRestoreSession failed.");
                    RequestRegisterClient requestRegister = RequestRegisterClient.create(ConfServerProtocol.this.getClientApplicationType(), ConfServerProtocol.this.clientName, ConfServerProtocol.this.userName, ConfServerProtocol.this.userPassword, ConfServerProtocol.this.context.getProtocolVersion());
                    this.registrationExchanges.set(this.registrationStep, new RegistrationStep(requestRegister, 19));
                    handled = true;
                } else if (request.messageId() == 3 && CfgUtilities.getErrorType(eventError.getErrorCode()) == CfgErrorType.CFGUserMustChangePassword && ConfServerProtocol.this.newUserPassword != null) {
                    if (ConfServerProtocol.this.context.getProtocolId(ConfServerProtocol.this.context.getProtocolVersion()) < 377) {
                        throw new RegistrationException("Opening channel with a new user password is not supported by the protocol versions earlier then 377");
                    }
                    if (log.isInfo()) {
                        log.info((Object)"The channel will be open with a new user password");
                    }
                    RequestRegisterClient2 requestRegister2 = RequestRegisterClient2.create(ConfServerProtocol.this.getClientApplicationType(), ConfServerProtocol.this.clientName, ConfServerProtocol.this.userName, ConfServerProtocol.this.userPassword, ConfServerProtocol.this.context.getProtocolVersion(), ConfServerProtocol.this.newUserPassword);
                    this.registrationExchanges.set(this.registrationStep, new RegistrationStep(requestRegister2, 19));
                    handled = true;
                }
            }
            return handled;
        }

        private void setSessionId(Integer sessId) {
            if (sessId == null) {
                return;
            }
            if (this.runtimeSessionRestored) {
                log.infoFormat("Session {0} is restored.", (Object)ConfServerProtocol.this.context.getSessionId());
            }
            ConfServerProtocol.this.context.setSessionId(sessId);
            if (this.runtimeSessionRestored) {
                if (log.isInfo()) {
                    log.infoFormat("New sessionId: ''{0}''.", (Object)ConfServerProtocol.this.context.getSessionId());
                }
            } else if (log.isInfo()) {
                log.infoFormat("Client is registered, sessionId: ''{0}''.", (Object)ConfServerProtocol.this.context.getSessionId());
            }
        }

        private void setProtocolVersion(String protocolVersion) {
            if (ConfServerProtocol.this.context.getServerProtocolVersion() != null) {
                return;
            }
            ConfServerProtocol.this.context.setServerProtocolVersion(protocolVersion);
            ConfServerProtocol.this.context.setProtocolVersion(protocolVersion);
        }

        private void bindSchemaProtocol() throws RegistrationException {
            ConfServerProtocol.this.context.getMetadata().update(ConfServerProtocol.this.context.getProtocolId(ConfServerProtocol.this.context.getProtocolVersion()));
            this.isMetadataLoaded = true;
            if (log.isInfo()) {
                log.info((Object)"Client protocol version: CfgProtocol 5.1.3.80");
                log.info((Object)("Server protocol version: " + ConfServerProtocol.this.context.getServerProtocolVersion()));
                log.info((Object)("Bound  protocol version: " + ConfServerProtocol.this.context.getProtocolVersion()));
            }
        }

        private void setDbid(Integer dbid) {
            if (dbid != null) {
                ConfServerProtocol.this.context.setDbid(dbid);
            }
        }

        private void setBackupDbid(Integer dbid) {
            if (dbid != null) {
                ConfServerProtocol.this.context.setBackupDbid(dbid);
            }
        }

        private void setExternalAuthentication(Integer extAuthentification) {
            if (extAuthentification != null) {
                if (extAuthentification != 0) {
                    log.infoFormat("Got valuable ExternalAuthentification: {0}", (Object)extAuthentification);
                }
                this.channel.context.setExternalAuthentication(extAuthentification);
            }
        }

        private void setServerEncoding(Integer serverEncoding) {
            this.channel.context.setServerEncoding(serverEncoding);
            if (serverEncoding != null && serverEncoding == 1) {
                this.updateConnectionEncodingToUTF8();
            }
        }

        private void setLocaleVersion(String localeVersion) {
            ConfServerProtocol.this.context.setLocaleVersion(localeVersion);
        }

        private void setLastLoginInfo(KeyValueCollection parameters) {
            if (this.channel.context.getMetadata().getProtocolVersion() < 375) {
                return;
            }
            if (parameters == null) {
                return;
            }
            this.channel.context.setLastLoginInfo(parameters);
        }

        private void setLastUpdateId(Integer lastUpdateId) {
            if (lastUpdateId == null || lastUpdateId <= 0) {
                return;
            }
            if (log.isInfo()) {
                log.infoFormat("LastUpdateId ({0}) is set.", (Object)lastUpdateId);
            }
            ConfServerProtocol.this.context.setLastUpdateId(lastUpdateId);
        }

        private void setDescription(String description) {
            ConfServerProtocol.this.context.setDescription(description);
        }

        private void loadServerSchema(String schemaFileContent) {
            if (log.isDebug()) {
                log.debug((Object)"Loading Server's Schema ...");
            }
            ConfServerProtocol.this.context.getMetadata().parseObjectSchema(schemaFileContent);
            if (log.isDebug()) {
                log.debug((Object)"Schema loading done.");
            }
        }

        private void logRequest(Message message) {
            if (!log.isInfo()) {
                return;
            }
            switch (message.messageId()) {
                case 49: {
                    log.info((Object)"Trying obtain server protocol version...");
                    break;
                }
                case 40: {
                    log.infoFormat("Trying to restore session, sessionId: {0} ...", (Object)((RequestRestoreSession)message).getSessionId());
                    break;
                }
                case 3: {
                    log.info((Object)"Trying to register client...");
                    break;
                }
                case 103: {
                    log.info((Object)"Trying to register client with new password set...");
                    break;
                }
                case 71: {
                    log.info((Object)"Trying to obtain the schema from server...");
                    break;
                }
                case 58: {
                    log.info((Object)"Trying to obtain the localization data from server...");
                }
            }
        }

        private Message createRequestRegister() throws ProtocolException {
            Message requestRegister = null;
            if (this.runtimeUseSession && ConfServerProtocol.this.context.getSessionId() > 0) {
                RequestRestoreSession message = RequestRestoreSession.create();
                message.setClientType(ConfServerProtocol.this.getClientApplicationType());
                message.setClientName(ConfServerProtocol.this.clientName);
                message.setProtocolVersion(ConfServerProtocol.this.context.getProtocolVersion());
                message.setSessionId(ConfServerProtocol.this.context.getSessionId());
                if (ConfServerProtocol.this.ticketAcquirer == null) {
                    message.setUserName(ConfServerProtocol.this.userName);
                    message.setUserPassword(ConfServerProtocol.this.userPassword);
                }
                requestRegister = message;
                this.runtimeSessionRestored = true;
                if (log.isInfo()) {
                    log.info((Object)("Session usage is enforced, sessionId: " + ConfServerProtocol.this.context.getSessionId()));
                }
            }
            if (requestRegister == null && this.channel.newUserPassword != null) {
                if (ConfServerProtocol.this.ticketAcquirer == null) {
                    if (this.channel.context.getProtocolId(this.channel.context.getProtocolVersion()) < 377) {
                        throw new RegistrationException("Opening channel with a new user password is not supported by the protocol versions earlier then 377");
                    }
                    if (log.isInfo()) {
                        log.info((Object)"The channel will be open with a new user password");
                    }
                    requestRegister = RequestRegisterClient2.create(this.channel.getClientApplicationType(), this.channel.getClientName(), this.channel.getUserName(), this.channel.getUserPassword(), this.channel.context.getProtocolVersion(), this.channel.newUserPassword);
                } else {
                    log.warn((Object)"Change password isn't suported when Kerberos is used");
                }
            }
            if (requestRegister == null) {
                if (log.isInfo()) {
                    if (!this.runtimeUseSession) {
                        log.info((Object)"Session usage is not enforced.");
                    } else if (ConfServerProtocol.this.context.getSessionId() > 0) {
                        log.info((Object)("Session usage is enforced, sessionId: " + ConfServerProtocol.this.context.getSessionId()));
                    } else {
                        log.infoFormat("Session usage is enforced, but SessionId ({0}) is invalid.", (Object)ConfServerProtocol.this.context.getSessionId());
                    }
                }
                requestRegister = RequestRegisterClient.create(ConfServerProtocol.this.getClientApplicationType(), ConfServerProtocol.this.clientName, null, null, ConfServerProtocol.this.context.getProtocolVersion());
            }
            return requestRegister;
        }

        private void setRegistrationComplete(boolean registered) {
            this.registrationComplete = registered;
            if (!registered) {
                this.runtimeSessionRestored = false;
            }
            ConfServerProtocol.this.context.setIsSessionRestored(this.runtimeSessionRestored);
        }

        private void setAuthorizationData(Message request) {
            if (ConfServerProtocol.this.ticketAcquirer != null && (ConfServerProtocol.this.userName != null || ConfServerProtocol.this.userPassword != null)) {
                log.warn((Object)"A user name and a user password aren't needed when Kerberos is used");
            }
            TicketHexData ticketData = this.getKerberosTicket();
            if (request instanceof RequestRegisterClient) {
                RequestRegisterClient requestRegisterClient = (RequestRegisterClient)request;
                if (ticketData != null) {
                    if (ticketData.gss) {
                        requestRegisterClient.setGSSToken(ticketData.hex);
                    } else {
                        requestRegisterClient.setKerberosTicket(ticketData.hex);
                    }
                } else {
                    requestRegisterClient.setUserName(ConfServerProtocol.this.userName);
                    requestRegisterClient.setUserPassword(ConfServerProtocol.this.userPassword);
                }
            }
        }

        private TicketHexData getKerberosTicket() {
            if (ConfServerProtocol.this.context == null) {
                return null;
            }
            int versionNum = ConfServerProtocol.this.context.getProtocolId(ConfServerProtocol.this.context.getServerProtocolVersion());
            if (versionNum < 379) {
                log.debug((Object)("Server protocol version (" + versionNum + ") does not support Kerberos, " + "falling back to username/password login."));
                return null;
            }
            log.debug((Object)("Server protocol version (" + versionNum + ") supports Kerberos"));
            AuthTicketAcquirer ticketAcquirer = ConfServerProtocol.this.getTicketAcquirer();
            Endpoint endpoint = ConfServerProtocol.this.getEndpoint();
            String spn = endpoint.getSPN();
            if (spn == null && ticketAcquirer == null) {
                return null;
            }
            if (ticketAcquirer == null) {
                log.debug((Object)"Getting default authentication ticket acquirer...");
                ticketAcquirer = DefaultAuthTicketAcquirer.getInstance();
                if (null == ticketAcquirer) {
                    throw new AuthTicketAcquirerException("Error getting default ticket acquierer");
                }
            }
            log.debug((Object)"Getting authentication ticket ...");
            AuthTicket ticket = ticketAcquirer.acquireTicket(spn);
            if (null == ticket) {
                throw new AuthTicketAcquirerException("Could not get authentication ticket");
            }
            log.debug((Object)"Getting authentication ticket data...");
            String hexTicketData = ticket.getTicketHex();
            if (null == hexTicketData || 0 == hexTicketData.length()) {
                throw new AuthTicketAcquirerException("Authentication ticket data is empty");
            }
            if (ticket.getUseGSS() && versionNum < 380) {
                log.debug((Object)("Server protocol version (" + versionNum + ") does not support GSS token, " + "falling back to username/password login."));
                return null;
            }
            return new TicketHexData(hexTicketData, ticket.getUseGSS());
        }
    }

    private static class ConfProtoData
    implements TKVCodec.PrinterStorage,
    XmlDocumentCodecV6.ObjectSerializerStorageV6,
    XmlDocumentCodecV7.ObjectSerializerStorageV7,
    AesCodec.AesUtilityStorage {
        private KeyValuePrinter printer;
        private ObjectSerializerV6 serializerV6;
        private ObjectSerializerV7 serializerV7;
        private AesUtil aes;

        private ConfProtoData() {
        }

        public KeyValuePrinter getPrinter() {
            return this.printer;
        }

        public void setPrinter(KeyValuePrinter printer) {
            this.printer = printer;
        }

        public ObjectSerializerV6 getSerializerV6() {
            return this.serializerV6;
        }

        public void setSerializerV6(ObjectSerializerV6 serializer) {
            this.serializerV6 = serializer;
        }

        public ObjectSerializerV7 getSerializerV7() {
            return this.serializerV7;
        }

        public void setSerializerV7(ObjectSerializerV7 serializer) {
            this.serializerV7 = serializer;
        }

        public AesUtil getConfAesUtility() {
            return this.aes;
        }

        public void setConfAesUtility(AesUtil aes) {
            this.aes = aes;
        }
    }
}

