/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.configuration.protocol.metadata;

import com.genesyslab.platform.configuration.protocol.metadata.CfgComparer;
import com.genesyslab.platform.configuration.protocol.metadata.CfgMetadata;
import com.genesyslab.platform.configuration.protocol.metadata.CfgNameComparer;
import com.genesyslab.platform.configuration.protocol.metadata.CfgTypeMask;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CfgDescription {
    private String name;
    private int index;
    private String localizedName;
    private int protocolVersion;
    protected CfgComparer baseComparer;
    private int typeBitMask = 0;
    private EnumSet<CfgTypeMask> typeMask = EnumSet.noneOf(CfgTypeMask.class);

    CfgDescription(String name, int index, int protocolVersion) {
        this.name = name;
        this.index = index;
        this.protocolVersion = protocolVersion < 360 ? 360 : protocolVersion;
        this.setTypeMask();
        this.setComparer();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getLocalizedName() {
        return this.localizedName;
    }

    public void setLocalizedName(String localizedName) {
        this.localizedName = localizedName;
    }

    public static CfgNameComparer getNameComparer() {
        return CfgMetadata.getNameComparer();
    }

    public CfgComparer getComparer() {
        return this.baseComparer;
    }

    protected void setComparer(CfgComparer value) {
        this.baseComparer = value;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    void setProtocolVersion(int protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public boolean isCfgType(CfgTypeMask value) {
        return (this.typeBitMask & value.getCfgType()) != 0;
    }

    @Deprecated
    public boolean isCfgType(EnumSet<CfgTypeMask> value) {
        int bitMask = 0;
        if (value != null) {
            for (CfgTypeMask mask : value) {
                bitMask |= mask.getCfgType();
            }
        }
        return this.isCfgType(bitMask);
    }

    public boolean isCfgType(int value) {
        return (this.typeBitMask & value) == value;
    }

    protected abstract void setTypeMask();

    protected abstract void setComparer();

    @Deprecated
    public EnumSet<CfgTypeMask> getTypeMask() {
        return this.typeMask;
    }

    public String getTypeMaskString() {
        return this.typeMask.toString();
    }

    protected void addTypeToMask(CfgTypeMask value) {
        this.typeBitMask |= value.getCfgType();
        this.typeMask.add(value);
    }

    public int getTypeBitMask() {
        return this.typeBitMask;
    }
}

