/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.configuration.protocol.metadata;

import com.genesyslab.platform.commons.GEnum;
import com.genesyslab.platform.configuration.protocol.metadata.CfgBaseComparer;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescription;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeEnumItem;
import com.genesyslab.platform.configuration.protocol.metadata.CfgTypeMask;
import com.genesyslab.platform.configuration.protocol.metadata.ICfgEnum;
import com.genesyslab.platform.configuration.protocol.types.CfgEnumType;
import com.genesyslab.platform.configuration.protocol.utilities.CfgUtilities;
import com.genesyslab.platform.configuration.protocol.utilities.Linq;
import com.genesyslab.platform.configuration.protocol.utilities.LinqConditions;
import com.genesyslab.platform.configuration.protocol.utilities.LinqConditionsAdaptor;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CfgDescriptionEnum<E extends GEnum>
extends CfgDescription
implements ICfgEnum<CfgEnumType> {
    private static final String WRONG_TYPE_STRING = "Enum item should be of type 'CfgDescriptionAttributeEnumItem'";
    static final String CFG_ENUM_NS = CfgEnumType.class.getPackage().getName();
    static final Class<?> ENUM_ITEM_TYPE = CfgDescriptionAttributeEnumItem.class;
    static final Class<?> ENUM_TYPE = CfgDescriptionEnum.class;
    private CfgEnumType enumType;
    private Class<E> enumClass;
    private final List<CfgDescriptionAttributeEnumItem<E>> items;
    private Hashtable<String, CfgDescriptionAttributeEnumItem<E>> itemByName;

    CfgDescriptionEnum(String name, CfgEnumType enumType, int protocolVersion) {
        super(name, enumType.ordinal(), protocolVersion);
        this.enumType = enumType;
        this.items = new LinkedList<CfgDescriptionAttributeEnumItem<E>>();
        this.itemByName = new Hashtable();
        this.initEnumClass();
    }

    CfgDescriptionEnum() {
        this(null, CfgEnumType.CfgMaxEnumType, 360);
    }

    private void initEnumClass() {
        this.enumClass = null;
        String name = this.getName();
        if (name != null) {
            try {
                this.enumClass = Class.forName(CFG_ENUM_NS + '.' + name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.initEnumClass();
    }

    @Override
    public CfgEnumType getCfgEnum() {
        return this.enumType;
    }

    void setCfgEnum(CfgEnumType cfgEnum) {
        this.enumType = cfgEnum;
    }

    public Class<E> getCfgEnumClass() {
        return this.enumClass;
    }

    public Collection<CfgDescriptionAttributeEnumItem<E>> getItems() {
        return this.items;
    }

    public CfgDescriptionAttributeEnumItem<E> getItem(String enumLiteral) {
        return this.itemByName.get(enumLiteral);
    }

    public CfgDescriptionAttributeEnumItem<E> getItem(E enumItem) {
        if (enumItem != null) {
            return this.getItem((E)enumItem.toString());
        }
        return null;
    }

    @Override
    protected void setTypeMask() {
        this.addTypeToMask(CfgTypeMask.Enum);
    }

    @Override
    protected void setComparer() {
        this.setComparer(new CfgBaseComparer());
    }

    void loadItems() {
        if (this.enumClass != null) {
            for (Object item0 : GEnum.values(this.enumClass)) {
                if (!(item0 instanceof GEnum)) continue;
                GEnum item = (GEnum)item0;
                CfgDescriptionAttributeEnumItem<GEnum> enumObject = new CfgDescriptionAttributeEnumItem<GEnum>();
                enumObject.setEnumDescription(this);
                enumObject.setName(item.name());
                enumObject.setDefaultEnumValue(item);
                enumObject.setIndex(item.ordinal());
                this.addItem(enumObject);
            }
        }
    }

    void loadLocales(Element enumLocales) {
        Element enumPairs = CfgUtilities.findChildElement(enumLocales, "pEnumPairs");
        if (enumPairs == null) {
            return;
        }
        NodeList enumPairsQuery = enumPairs.getChildNodes();
        block0: for (CfgDescriptionAttributeEnumItem<E> item0 : this.getItems()) {
            final CfgDescriptionAttributeEnumItem<E> item = item0;
            Element enumLocale = (Element)Linq.firstOrDefault(enumPairsQuery, (LinqConditions<Node>)new LinqConditionsAdaptor<Node>(){

                @Override
                public boolean condition(Node item1) {
                    return Linq.firstOrDefault(item1.getChildNodes(), (LinqConditions<Node>)new LinqConditionsAdaptor<Node>(){

                        @Override
                        public boolean condition(Node item2) {
                            return item2.getNodeName().equals("dwID") && ((Element)item2).getAttribute("value").equals(Integer.toString(item.getDefaultValue()));
                        }
                    }) != null;
                }
            });
            if (enumLocale == null) continue;
            for (Node item1 = enumLocale.getFirstChild(); item1 != null; item1 = item1.getNextSibling()) {
                if (!item1.getNodeName().equals("name")) continue;
                String locVal = ((Element)item1).getAttribute("value");
                if (locVal == null || locVal.equals("")) continue block0;
                item.setLocalizedName(locVal);
                continue block0;
            }
        }
    }

    void addItem(CfgDescriptionAttributeEnumItem<E> item) {
        if (item == null) {
            throw new IllegalArgumentException("item");
        }
        if (!item.isCfgType(CfgTypeMask.Enum)) {
            throw new IllegalArgumentException(WRONG_TYPE_STRING);
        }
        this.items.add(item);
        this.itemByName.put(item.getName(), item);
    }

    void removeItem(CfgDescriptionAttributeEnumItem<E> item) {
        if (item == null) {
            throw new IllegalArgumentException("item");
        }
        if (!item.isCfgType(CfgTypeMask.Enum)) {
            throw new IllegalArgumentException(WRONG_TYPE_STRING);
        }
        this.items.remove(item);
        this.itemByName.remove(item.getName());
    }
}

