/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.configuration.protocol.obj;

import com.genesyslab.platform.configuration.protocol.metadata.CfgDescription;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttribute;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeReference;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeReferenceClass;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionClass;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionObject;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionStructure;
import com.genesyslab.platform.configuration.protocol.metadata.CfgTypeMask;
import com.genesyslab.platform.configuration.protocol.obj.ConfDataCollection;
import com.genesyslab.platform.configuration.protocol.obj.ConfIntegerCollection;
import com.genesyslab.platform.configuration.protocol.obj.ConfObject;
import com.genesyslab.platform.configuration.protocol.obj.ConfObjectAttributeException;
import com.genesyslab.platform.configuration.protocol.obj.ConfObjectValueException;
import com.genesyslab.platform.configuration.protocol.obj.ConfStringCollection;
import com.genesyslab.platform.configuration.protocol.obj.ConfStructure;
import com.genesyslab.platform.configuration.protocol.obj.ConfStructureCollection;

public abstract class ConfObjectBase {
    private final CfgDescriptionClass classInfo;
    private final CfgDescriptionAttributeReference attrInfo;
    private final Object[] properties;

    protected ConfObjectBase(CfgDescription metadata) {
        if (metadata == null) {
            throw new ConfObjectAttributeException("ConfObjectBase.metadata is null");
        }
        this.classInfo = metadata.isCfgType(CfgTypeMask.Object) ? (CfgDescriptionClass)metadata : (metadata.isCfgType(CfgTypeMask.Structure) ? (CfgDescriptionClass)metadata : (metadata.isCfgType(CfgTypeMask.Reference) && metadata.isCfgType(CfgTypeMask.Class) ? ((CfgDescriptionAttributeReference)metadata).getCfgClass() : null));
        if (this.classInfo == null) {
            throw new ConfObjectAttributeException("ConfObjectBase.classInfo does not refer to a configuration structure");
        }
        this.attrInfo = metadata.isCfgType(CfgTypeMask.Attribute) && metadata.isCfgType(CfgTypeMask.Reference) ? (CfgDescriptionAttributeReference)metadata : null;
        int maxIndex = -1;
        for (CfgDescriptionAttribute attr : this.classInfo.getAttributes()) {
            int idx = attr.getIndex();
            if (idx < 0) {
                throw new ConfObjectAttributeException(this.classInfo.getName(), attr.getSchemaName(), "Negative attribute index detected");
            }
            if (idx <= maxIndex) continue;
            maxIndex = idx;
        }
        if (maxIndex < 0) {
            throw new ConfObjectAttributeException(this.classInfo.getName(), "Class has no attributes");
        }
        if (maxIndex > 100) {
            throw new ConfObjectAttributeException(this.classInfo.getName(), "Class has attribute(s) with huge index");
        }
        this.properties = new Object[maxIndex + 1];
    }

    public CfgDescriptionClass getClassInfo() {
        return this.classInfo;
    }

    public CfgDescriptionAttributeReference getAttributeInfo() {
        return this.attrInfo;
    }

    public CfgDescriptionAttribute getPropertyInfo(String propName) {
        CfgDescriptionAttribute attr = this.classInfo.getAttribute(propName);
        if (attr == null) {
            throw new ConfObjectAttributeException(this.classInfo.getName(), propName, "No such attribute in the class");
        }
        return attr;
    }

    public Object getPropertyValue(String propName) {
        return this.properties[this.getPropertyInfo(propName).getIndex()];
    }

    public Object getPropertyValue(int propIndex) {
        if (propIndex < 0 || propIndex >= this.properties.length) {
            throw new ConfObjectAttributeException("Property index is out of range (" + propIndex + " to [0.." + (propIndex - 1) + "])");
        }
        return this.properties[propIndex];
    }

    public Object getOrCreatePropertyValue(String propName) {
        CfgDescriptionAttribute attrInfo = this.getPropertyInfo(propName);
        Object value = this.properties[attrInfo.getIndex()];
        if (value == null && (value = this.createChildElement(attrInfo)) != null) {
            this.properties[attrInfo.getIndex()] = value;
        }
        return value;
    }

    public void setPropertyValue(String propName, Object propValue) {
        CfgDescriptionAttribute attr = this.getPropertyInfo(propName);
        this.checkTypeCompatibility(attr, propValue);
        this.properties[attr.getIndex()] = propValue;
    }

    public void setPropertyValue(int propIndex, Object propValue) {
        if (propIndex < 0 || propIndex >= this.properties.length) {
            throw new ConfObjectAttributeException("Property index is out of range (" + propIndex + " to [0.." + (propIndex - 1) + "])");
        }
        this.properties[propIndex] = propValue;
    }

    protected void checkTypeCompatibility(CfgDescriptionAttribute attrInfo, Object value) {
        if (value == null) {
            return;
        }
        if (attrInfo.isCfgType(CfgTypeMask.List)) {
            if (attrInfo.isCfgType(CfgTypeMask.Class) && !(value instanceof ConfStructureCollection)) {
                throw new ConfObjectValueException(this.classInfo.getName(), attrInfo.getSchemaName(), "Attribute value should be ConfStructureCollection");
            }
        } else if (attrInfo.isCfgType(CfgTypeMask.Primitive)) {
            if (attrInfo.isCfgType(CfgTypeMask.String)) {
                if (!(value instanceof String)) {
                    throw new ConfObjectValueException(this.classInfo.getName(), attrInfo.getSchemaName(), "Attribute value should be String");
                }
            } else if (attrInfo.isCfgType(CfgTypeMask.Integer) && !(value instanceof Integer)) {
                throw new ConfObjectValueException(this.classInfo.getName(), attrInfo.getSchemaName(), "Attribute value should be Integer");
            }
        }
    }

    protected Object createChildElement(CfgDescriptionAttribute attrInfo) {
        Object value = null;
        if (attrInfo.isCfgType(CfgTypeMask.List)) {
            if (attrInfo.isCfgType(CfgTypeMask.Structure)) {
                value = new ConfStructureCollection((CfgDescriptionAttributeReferenceClass)attrInfo);
            } else if (attrInfo.isCfgType(CfgTypeMask.Link)) {
                value = new ConfIntegerCollection((CfgDescriptionAttributeReference)attrInfo);
            } else if (attrInfo.isCfgType(CfgTypeMask.Integer)) {
                value = new ConfIntegerCollection((CfgDescriptionAttributeReference)attrInfo);
            } else if (attrInfo.isCfgType(CfgTypeMask.String)) {
                value = new ConfStringCollection((CfgDescriptionAttributeReference)attrInfo);
            }
        } else if (attrInfo.isCfgType(CfgTypeMask.Structure)) {
            value = new ConfStructure((CfgDescriptionStructure)((CfgDescriptionAttributeReferenceClass)attrInfo).getCfgClass());
        } else if (attrInfo.isCfgType(CfgTypeMask.Object)) {
            value = new ConfObject((CfgDescriptionObject)((CfgDescriptionAttributeReferenceClass)attrInfo).getCfgClass());
        } else {
            throw new ConfObjectAttributeException(this.classInfo.getName(), attrInfo.getSchemaName(), "Wrong attribute type for automatic child structure creation");
        }
        return value;
    }

    public String toString() {
        return this.toString(true, true);
    }

    public String toString(boolean truncate, boolean hideAllowed) {
        StringBuilder sb = new StringBuilder();
        this.toStringHelper(sb, "", truncate, hideAllowed);
        return sb.toString();
    }

    protected void toStringHelper(StringBuilder buffer, String prefix, boolean truncate, boolean hideAllowed) {
        buffer.append(this.getClass().getSimpleName()).append("(").append(this.classInfo.getName()).append(") {");
        this.toStringContentHelper(buffer, prefix + "\t", truncate, hideAllowed);
        buffer.append("\n").append(prefix).append("}");
    }

    protected void toStringContentHelper(StringBuilder buffer, String prefix, boolean truncate, boolean hideAllowed) {
        for (CfgDescriptionAttribute attr : this.classInfo.getAttributes()) {
            Object attrVal = this.properties[attr.getIndex()];
            if (attrVal == null) continue;
            buffer.append("\n").append(prefix).append("\"").append(attr.getSchemaName()).append("\" = ");
            if (attrVal instanceof ConfObjectBase) {
                ((ConfObjectBase)attrVal).toStringHelper(buffer, prefix, truncate, hideAllowed);
                continue;
            }
            if (attrVal instanceof ConfDataCollection) {
                ((ConfDataCollection)attrVal).toStringHelper(buffer, prefix, truncate, hideAllowed);
                continue;
            }
            String strVal = attrVal.toString();
            if (attrVal instanceof String) {
                buffer.append("\"");
                if (truncate && strVal.length() > 150) {
                    buffer.append(strVal.substring(0, 145)).append("...[len=").append(Integer.toString(strVal.length())).append("]");
                } else {
                    buffer.append(strVal);
                }
                buffer.append("\"");
                continue;
            }
            if (truncate && strVal.length() > 150) {
                buffer.append(strVal.substring(0, 145)).append("...[len=").append(Integer.toString(strVal.length())).append("]");
                continue;
            }
            buffer.append(strVal);
        }
    }
}

