/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.configuration.protocol.runtime.channel;

import com.genesyslab.platform.configuration.protocol.runtime.channel.TokenType;

public class CharDelimitersV6 {
    public static final char Binary = '\u0017';
    public static final char ItemEnd = '\u0018';
    public static final char KvlistStart = '\u0019';
    public static final char KvlistEnd = '\u001a';
    public static final char ListStart = '\u001b';
    public static final char ListEnd = '\u001c';
    public static final char ClassStart = '\u001d';
    public static final char ClassEnd = '\u001e';
    public static final char String = '\u001f';
    public static final char[] cfgLibEx = new char[]{'\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f'};

    private CharDelimitersV6() {
    }

    public static int indexOfAnyDelimiter(String str, int startIndex) {
        int len = str.length();
        if (len == 0 || startIndex < 0 || startIndex > len) {
            return -1;
        }
        for (int i = startIndex; i < len; ++i) {
            char chr = str.charAt(i);
            if (chr > '\u001f' || chr < '\u0017') continue;
            return i;
        }
        return -1;
    }

    public static TokenType getTokenType(char chr) {
        switch (chr) {
            case '\u0017': {
                return TokenType.BINARY;
            }
            case '\u0018': {
                return TokenType.END;
            }
            case '\u0019': {
                return TokenType.KVLIST;
            }
            case '\u001a': {
                return TokenType.END;
            }
            case '\u001b': {
                return TokenType.LIST;
            }
            case '\u001c': {
                return TokenType.END;
            }
            case '\u001d': {
                return TokenType.STRUCT;
            }
            case '\u001e': {
                return TokenType.END;
            }
            case '\u001f': {
                return TokenType.STRING;
            }
        }
        return TokenType.EMPTY;
    }
}

